/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import zeldaswordskills.util.LogHelper;

public class DirtyEntityAccessor {
    public static void damageEntity(EntityLivingBase target, DamageSource source, float amount) {
        target.func_70665_d(source, amount);
    }

    public static float getModifiedDamage(EntityLivingBase entity, DamageSource source, float amount) {
        amount = entity.func_70655_b(source, amount);
        amount = entity.func_70672_c(source, amount);
        return Math.max(amount - entity.func_110139_bj(), 0.0f);
    }

    public static void setLivingXp(EntityLiving entity, int xp, boolean add) {
        entity.field_70728_aV = add ? entity.field_70728_aV + xp : xp;
    }

    public static void setSize(Entity entity, float width, float height) {
        NBTTagCompound compound = entity.getEntityData();
        compound.func_74776_a("origWidth", entity.field_70130_N);
        compound.func_74776_a("origHeight", entity.field_70131_O);
        entity.func_70105_a(width, height);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).eyeHeight = 0.85f * height;
        }
    }

    public static void restoreOriginalSize(Entity entity) {
        NBTTagCompound compound = entity.getEntityData();
        if (compound.func_74764_b("origWidth") && compound.func_74764_b("origHeight")) {
            entity.func_70105_a(compound.func_74760_g("origWidth"), compound.func_74760_g("origHeight"));
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).eyeHeight = ((EntityPlayer)entity).getDefaultEyeHeight();
            }
        } else {
            LogHelper.warning("Attempted to restore original size without any available data");
        }
    }
}

