/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.block.tileentity.TileEntityCeramicJar;
import zeldaswordskills.client.render.block.RenderCeramicJar;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntityHookShot;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.gen.DungeonLootLists;

public class BlockCeramicJar
extends BlockContainer
implements IExplodable,
ISmashable {
    private static boolean keepInventory;

    public BlockCeramicJar() {
        super(Material.field_151571_B);
        this.func_149649_H();
        this.func_149722_s();
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
        this.func_149676_a(0.285f, 0.0f, 0.285f, 0.715f, 0.665f, 0.715f);
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta) {
        return BlockWeight.VERY_LIGHT;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
        world.func_147480_a(x, y, z, false);
        return Event.Result.ALLOW;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderCeramicJar.renderId;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCeramicJar();
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).func_149730_j();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && world.func_147439_a(x, y - 1, z).func_149730_j();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!keepInventory) {
            IInventory inv;
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IInventory && (inv = (IInventory)te).func_70301_a(0) == null && world.field_73012_v.nextFloat() < Config.getJarDropChance()) {
                inv.func_70299_a(0, ChestGenHooks.getInfo((String)DungeonLootLists.JAR_DROPS).getOneItem(world.field_73012_v));
            }
            WorldUtils.dropContainerBlockInventory(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player.func_70694_bm() == null) {
            ItemStack invStack;
            ItemStack jarStack = new ItemStack((Block)this);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IInventory && (invStack = ((IInventory)te).func_70301_a(0)) != null) {
                NBTTagCompound item = new NBTTagCompound();
                invStack.func_77955_b(item);
                jarStack.func_77982_d(new NBTTagCompound());
                jarStack.func_77978_p().func_74782_a("jarStack", (NBTBase)item);
            }
            player.func_70062_b(0, jarStack);
            keepInventory = true;
            world.func_147468_f(x, y, z);
            keepInventory = false;
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemSword) {
            WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
            world.func_147480_a(x, y, z, false);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("jarStack") && (te = world.func_147438_o(x, y, z)) instanceof IInventory) {
            ItemStack jarStack = ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("jarStack"));
            ((IInventory)te).func_70299_a(0, jarStack);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
        world.func_147480_a(x, y, z, false);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityArrow || entity instanceof EntityBoomerang || entity instanceof EntityHookShot) {
            WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
            world.func_147480_a(x, y, z, false);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!this.func_149718_j(world, x, y, z)) {
            WorldUtils.playSoundAt(world, x, y, z, "zeldaswordskills:break_jar", 0.4f, 0.5f);
            world.func_147480_a(x, y, z, false);
        }
    }
}

