/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;

public class EntityKeese
extends EntityBat
implements IMob,
IEntityVariant {
    private ChunkCoordinates currentFlightTarget;
    private static final int TYPE_INDEX = 17;
    private static final int SHOCK_INDEX = 18;
    private boolean swarmSpawned;

    public EntityKeese(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.9f);
        this.func_82236_f(true);
        this.setType(KeeseType.NORMAL);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)((byte)KeeseType.NORMAL.ordinal()));
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public KeeseType getType() {
        return KeeseType.values()[this.field_70180_af.func_75683_a(17)];
    }

    public void setType(KeeseType type) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)type.ordinal()));
        this.applyTypeTraits();
        this.updateMaxHealth();
    }

    @Override
    public void setType(int type) {
        this.setType(KeeseType.values()[type % KeeseType.values().length]);
    }

    private void setTypeOnSpawn() {
        KeeseType type = KeeseType.NORMAL;
        if (this.field_70170_p.field_73011_w.field_76575_d) {
            type = this.field_70146_Z.nextInt(8) > 0 ? KeeseType.FIRE : KeeseType.CURSED;
        } else if (this.field_70146_Z.nextInt(64) == 0) {
            type = KeeseType.CURSED;
        } else {
            BiomeGenBase biome = this.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            if (biome != null) {
                String name = biome.field_76791_y.toLowerCase();
                if (name.contains("frozen") || name.contains("ice") || name.contains("taiga") || name.contains("snow") || name.contains("cold")) {
                    type = KeeseType.ICE;
                } else if (name.contains("desert") || this.field_70146_Z.nextInt(8) == 0) {
                    type = KeeseType.THUNDER;
                }
            }
        }
        this.setType(type);
    }

    private void applyTypeTraits() {
        ZSSEntityInfo.get((EntityLivingBase)this).removeAllBuffs();
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.EVADE_UP, Integer.MAX_VALUE, 50);
        switch (this.getType()) {
            case CURSED: {
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 100);
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.WEAKNESS_HOLY, Integer.MAX_VALUE, 100);
                this.field_70728_aV = 7;
                break;
            }
            case FIRE: {
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 100);
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
                this.field_70178_ae = true;
                this.field_70728_aV = 3;
                break;
            }
            case ICE: {
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 100);
                this.field_70728_aV = 3;
                break;
            }
            case THUNDER: {
                ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 100);
                this.field_70728_aV = 5;
                break;
            }
            default: {
                this.field_70728_aV = 1;
            }
        }
    }

    private void updateMaxHealth() {
        switch (this.getType()) {
            case CURSED: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
                break;
            }
            case FIRE: 
            case ICE: 
            case THUNDER: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
                break;
            }
            default: {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
            }
        }
        this.func_70606_j(this.func_110138_aP());
    }

    protected boolean canShock() {
        return this.getType() == KeeseType.THUNDER;
    }

    public int getShockTime() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void setShockTime(int time) {
        this.field_70180_af.func_75692_b(18, (Object)time);
    }

    private float getDamage() {
        return 2.0f;
    }

    private DamageSource getDamageSource() {
        if (this.getShockTime() > 0) {
            return new DamageUtils.DamageSourceShock("shock", (Entity)this, this.field_70170_p.field_73013_u.func_151525_a() * 50, 1.0f);
        }
        switch (this.getType()) {
            case FIRE: {
                return new EntityDamageSource("mob", (Entity)this).func_76361_j();
            }
            case ICE: {
                return new DamageUtils.DamageSourceIce("mob", (Entity)this, 100, 0);
            }
        }
        return new EntityDamageSource("mob", (Entity)this);
    }

    protected void func_70600_l(int rarity) {
        if (this.getType() == KeeseType.CURSED) {
            switch (rarity) {
                case 1: {
                    this.func_70099_a(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EVIL_CRYSTAL.ordinal()), 0.0f);
                    break;
                }
                default: {
                    this.func_70099_a(new ItemStack(this.field_70146_Z.nextInt(8) == 0 ? ZSSItems.smallHeart : ZSSItems.heartPiece), 0.0f);
                    break;
                }
            }
        } else {
            switch (rarity) {
                case 1: {
                    this.func_70099_a(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.MONSTER_CLAW.ordinal()), 0.0f);
                    break;
                }
                default: {
                    this.func_70099_a(new ItemStack(this.field_70146_Z.nextInt(3) == 1 ? Items.field_151166_bC : ZSSItems.smallHeart), 0.0f);
                }
            }
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.field_70724_aR == 0 && this.func_70685_l((Entity)player) && this.func_70068_e((Entity)player) < 1.5 && (player.func_82169_q(3) == null || player.func_82169_q(3).func_77973_b() != ZSSItems.maskSkull) && player.func_70097_a(this.getDamageSource(), this.getDamage())) {
            this.field_70724_aR = this.field_70146_Z.nextInt(20) + 20;
            this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            switch (this.getType()) {
                case CURSED: {
                    this.applyRandomCurse(player);
                    break;
                }
                case FIRE: {
                    if (!(this.field_70146_Z.nextFloat() < 0.5f)) break;
                    player.func_70015_d(this.field_70146_Z.nextInt(4) + 4);
                    break;
                }
            }
        }
    }

    private void applyRandomCurse(EntityPlayer player) {
        switch (this.field_70146_Z.nextInt(16)) {
            case 0: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.ATTACK_DOWN, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(51) + 50);
                break;
            }
            case 1: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.DEFENSE_DOWN, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(26) + 25);
                break;
            }
            case 2: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.EVADE_DOWN, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(51) + 50);
                break;
            }
            case 3: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_COLD, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(51) + 50);
                break;
            }
            case 4: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_FIRE, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(51) + 50);
                break;
            }
            case 5: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_MAGIC, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(51) + 50);
                break;
            }
            case 6: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_SHOCK, this.field_70146_Z.nextInt(500) + 100, this.field_70146_Z.nextInt(51) + 50);
                break;
            }
            case 7: {
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(500) + 100, 1));
                break;
            }
            case 8: {
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(500) + 100, 1));
                break;
            }
            case 9: {
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, this.field_70146_Z.nextInt(100) + 50, this.field_70146_Z.nextInt(9) / 8));
                break;
            }
            case 10: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 1, this.field_70146_Z.nextInt(9) / 8));
                break;
            }
        }
    }

    public void func_70071_h_() {
        int time;
        super.func_70071_h_();
        if (!this.swarmSpawned && !this.field_70170_p.field_72995_K) {
            this.swarmSpawned = true;
            if (this.field_70146_Z.nextFloat() < Config.getKeeseSwarmChance()) {
                int n = Config.getKeeseSwarmSize() - this.field_70146_Z.nextInt(Config.getKeeseSwarmSize());
                for (int i = 0; i < n; ++i) {
                    EntityKeese k = new EntityKeese(this.field_70170_p);
                    double x = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 2.0f);
                    double z = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 2.0f);
                    k.func_70107_b(x, this.field_70163_u, z);
                    k.setTypeOnSpawn();
                    k.swarmSpawned = true;
                    this.field_70170_p.func_72838_d((Entity)k);
                }
            }
        }
        if ((time = this.getShockTime()) > 0) {
            this.setShockTime(time - 1);
            if (time % 8 > 6 && this.field_70146_Z.nextInt(4) == 0) {
                this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:shock", this.func_70599_aP(), 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.0f));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        block10: {
            block12: {
                block11: {
                    if (ZSSEntityInfo.get((EntityLivingBase)this).isBuffActive(Buff.STUN)) {
                        return;
                    }
                    super.func_70619_bc();
                    if (this.func_82235_h()) break block10;
                    if (!(this.currentFlightTarget == null || this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c) && this.currentFlightTarget.field_71572_b >= 1)) {
                        this.currentFlightTarget = null;
                    }
                    if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0) break block11;
                    float f = this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                    float f2 = this.field_70717_bb != null ? 1.0f : 4.0f;
                    if (!(f < f2)) break block12;
                }
                EntityPlayer entityPlayer = this.field_70717_bb = this.func_110144_aD() instanceof EntityPlayer ? (EntityPlayer)this.func_110144_aD() : this.field_70170_p.func_72890_a((Entity)this, 8.0);
                if (!(this.field_70717_bb == null || this.field_70717_bb.field_71075_bZ.field_75098_d || this.field_70717_bb.func_82169_q(3) != null && this.field_70717_bb.func_82169_q(3).func_77973_b() == ZSSItems.maskSkull)) {
                    this.currentFlightTarget = new ChunkCoordinates((int)this.field_70717_bb.field_70165_t, (int)this.field_70717_bb.field_70163_u + 1, (int)this.field_70717_bb.field_70161_v);
                    this.field_70170_p.func_72889_a(this.field_70717_bb, 1015, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                } else {
                    this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
                }
            }
            double d0 = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
            double d1 = (double)this.currentFlightTarget.field_71572_b + 0.1 - this.field_70163_u;
            double d2 = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
            float f = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += f1;
            if (this.field_70717_bb == null && this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), (int)this.field_70163_u + 1, MathHelper.func_76128_c((double)this.field_70161_v)).func_149721_r()) {
                this.func_82236_f(true);
            } else if (this.canShock() && this.getShockTime() == 0 && !ZSSEntityInfo.get((EntityLivingBase)this).isBuffActive(Buff.STUN) && this.field_70717_bb != null && (this.field_70718_bc > 0 && this.field_70146_Z.nextInt(20) == 0 || this.field_70146_Z.nextInt(300) == 0)) {
                this.setShockTime(this.field_70146_Z.nextInt(100) + this.field_70170_p.field_73013_u.func_151525_a() * 50);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_82235_h()) {
            this.func_82236_f(false);
        }
        if (this.getShockTime() > 0) {
            if (source instanceof EntityDamageSourceIndirect) {
                if (source.func_82725_o()) {
                    return super.func_70097_a(source, amount);
                }
                if (source.func_94541_c()) {
                    ZSSEntityInfo.get((EntityLivingBase)this).stun(20 + this.field_70146_Z.nextInt((int)(amount * 5.0f) + 1));
                    this.setShockTime(0);
                } else if (source instanceof IDamageSourceStun) {
                    this.setShockTime(0);
                }
            } else if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityLivingBase) {
                source.func_76346_g().func_70097_a(this.getDamageSource(), this.getDamage());
                this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:shock", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.0f));
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.swarmSpawned = compound.func_74767_n("SpawnedSwarm");
        this.field_70180_af.func_75692_b(17, (Object)compound.func_74771_c("KeeseType"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("SpawnedSwarm", this.swarmSpawned);
        compound.func_74774_a("KeeseType", this.field_70180_af.func_75683_a(17));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.setTypeOnSpawn();
        return data;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && (this.field_70163_u < 64.0 || this.field_70146_Z.nextInt(16) > 13) && this.isValidLightLevel() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_72801_o(i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) <= (float)this.field_70146_Z.nextInt(8);
    }

    public static enum KeeseType {
        NORMAL,
        FIRE,
        ICE,
        THUNDER,
        CURSED;

    }
}

