/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;

public class EntityBomb
extends EntityMobThrowable
implements IEntityBomb {
    private int fuseTime = 24;
    private float radius = 0.0f;
    private boolean canGrief = true;
    protected float motionFactor = 1.0f;
    protected float destructionFactor = 1.0f;
    private static final int BOMBTYPE_DATAWATCHER_INDEX = 22;

    public EntityBomb(World world) {
        super(world);
    }

    public EntityBomb(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityBomb(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.setDamage(0.0f);
        this.field_70180_af.func_75682_a(22, (Object)BombType.BOMB_STANDARD.ordinal());
    }

    public EntityBomb addTime(int time) {
        this.fuseTime = Math.max(this.fuseTime + time, this.fuseTime);
        return this;
    }

    public EntityBomb setTime(int time) {
        this.fuseTime = Math.max(time, 1);
        return this;
    }

    public EntityBomb setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public float getMotionFactor() {
        return this.motionFactor;
    }

    public EntityBomb setMotionFactor(float amount) {
        this.motionFactor = amount;
        return this;
    }

    @Override
    public float getDestructionFactor() {
        return this.destructionFactor;
    }

    public EntityBomb setDestructionFactor(float factor) {
        this.destructionFactor = factor;
        return this;
    }

    public boolean canGriefAdventureMode() {
        return Config.canGriefAdventure();
    }

    public EntityBomb setNoGrief() {
        this.canGrief = false;
        return this;
    }

    @Override
    public BombType getType() {
        return BombType.values()[this.field_70180_af.func_75679_c(22)];
    }

    public EntityBomb setType(BombType type) {
        this.field_70180_af.func_75692_b(22, (Object)type.ordinal());
        return this;
    }

    protected float func_70185_h() {
        return 0.075f;
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public void func_70071_h_() {
        Material material;
        boolean inFire;
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            f = 0.58800006f;
            Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            if (block.func_149688_o() != Material.field_151579_a) {
                f = block.field_149765_K * 0.98f;
            }
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        boolean bl = inFire = (material = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o()) == Material.field_151587_i || material == Material.field_151581_o || this.field_70170_p.func_147470_e(this.field_70121_D);
        if (this.isDud(inFire)) {
            this.fuseTime += 10;
            this.disarm(this.field_70170_p);
            return;
        }
        if (this.field_70173_aa % 20 == 0) {
            this.func_85030_a("zeldaswordskills:bomb_fuse", 1.0f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        if (!this.field_70170_p.field_72995_K && this.shouldExplode(inFire)) {
            CustomExplosion.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.radius == 0.0f ? ItemBomb.getRadius(this.getType()) : this.radius, this.getDamage(), this.canGrief);
            this.func_70106_y();
        }
    }

    public boolean disarm(World world) {
        if (!world.field_72995_K && this.fuseTime > 4) {
            this.func_70106_y();
            world.func_72838_d((Entity)new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ZSSItems.bomb, 1, this.getType().ordinal())));
            return true;
        }
        return false;
    }

    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        this.field_70159_w *= 0.5;
        this.field_70181_x *= -0.5;
        this.field_70179_y *= 0.5;
    }

    private boolean isDud(boolean inFire) {
        switch (this.getType()) {
            case BOMB_WATER: {
                return inFire || this.field_70173_aa > 8 && this.field_70170_p.field_73011_w.field_76574_g == -1;
            }
        }
        return this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v).func_149688_o() == Material.field_151586_h;
    }

    private boolean shouldExplode(boolean inFire) {
        boolean inNether = this.field_70170_p.field_73011_w.field_76574_g == -1 && this.getType() == BombType.BOMB_STANDARD;
        return this.field_70173_aa >= this.fuseTime || inNether || inFire && this.getType() == BombType.BOMB_STANDARD;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("bombType", (byte)this.getType().ordinal());
        compound.func_74768_a("fuseTime", this.fuseTime);
        compound.func_74776_a("bombRadius", this.radius);
        compound.func_74776_a("motionFactor", this.motionFactor);
        compound.func_74776_a("destructionFactor", this.destructionFactor);
        compound.func_74757_a("canGrief", this.canGrief);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(BombType.values()[compound.func_74771_c("bombType") % BombType.values().length]);
        this.fuseTime = compound.func_74762_e("fuseTime");
        this.radius = compound.func_74760_g("bombRadius");
        this.motionFactor = compound.func_74760_g("motionFactor");
        this.destructionFactor = compound.func_74760_g("destructionFactor");
        this.canGrief = compound.func_74767_n("canGrief");
    }
}

