/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import zeldaswordskills.client.particle.FXCycloneRing;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.WorldUtils;

public class EntityCyclone
extends EntityMobThrowable {
    private static float maxPitch = 0.4f;
    private float yaw = 0.0f;
    private float yawVelocity = 0.1f;
    private float pitch = 0.0f;
    private static float pitchVelocity = 0.0f;
    private static final int AREA_INDEX = 23;
    private List<Integer> affectedEntities = new ArrayList<Integer>();
    private List<ItemStack> capturedItems = new ArrayList<ItemStack>();
    private boolean canGrief = true;

    public EntityCyclone(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
    }

    public EntityCyclone(World world, EntityLivingBase entity) {
        super(world, entity);
        this.func_70105_a(1.0f, 2.0f);
        this.field_70165_t -= this.field_70159_w * 2.0;
        this.field_70161_v -= this.field_70179_y * 2.0;
    }

    public EntityCyclone(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_70105_a(1.0f, 2.0f);
    }

    public EntityCyclone(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.func_70105_a(1.0f, 2.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(23, (Object)Float.valueOf(2.0f));
    }

    public float getArea() {
        return this.field_70180_af.func_111145_d(23);
    }

    public EntityCyclone setArea(float radius) {
        this.field_70180_af.func_75692_b(23, (Object)Float.valueOf(radius));
        return this;
    }

    public EntityCyclone disableGriefing() {
        this.canGrief = false;
        return this;
    }

    protected DamageSource getDamageSource() {
        return new EntityDamageSourceIndirect("blast.wind", (Entity)this, (Entity)this.func_85052_h()).func_76349_b().func_82726_p();
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70058_J() {
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected float func_70182_d() {
        return 0.75f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x += 0.01;
        if (!this.field_70170_p.field_72995_K) {
            this.captureDrops();
            this.attackNearbyEntities();
            if (this.canGrief) {
                this.destroyLeaves();
            }
            if (this.field_70173_aa > 40) {
                this.func_70106_y();
                this.releaseDrops();
            } else if (this.field_70173_aa % 6 == 5) {
                this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:whirlwind", 0.6f, 1.0f);
            }
        } else {
            this.spawnParticleRing();
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Material m = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149688_o();
            if (m == Material.field_151584_j) {
                if (!this.field_70170_p.field_72995_K && this.canGrief && Config.canDekuDenude()) {
                    this.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, true);
                }
            } else if (m.func_76230_c()) {
                if (mop.field_72310_e == 1) {
                    this.field_70163_u = mop.field_72312_c + 1;
                    this.field_70125_A = 0.0f;
                    this.field_70181_x = 0.0;
                } else {
                    this.func_70106_y();
                    this.releaseDrops();
                }
            }
        } else if (mop.field_72308_g != null && (mop.field_72308_g != this.func_85052_h() || this.field_70173_aa >= 5)) {
            if (this.getDamage() > 0.0f && !this.affectedEntities.contains(mop.field_72308_g.func_145782_y())) {
                mop.field_72308_g.func_70097_a(this.getDamageSource(), this.getDamage());
                this.affectedEntities.add(mop.field_72308_g.func_145782_y());
            }
            if (!(mop.field_72308_g instanceof EntityLivingBase) || (double)this.field_70146_Z.nextFloat() > ((EntityLivingBase)mop.field_72308_g).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
                mop.field_72308_g.field_70159_w = this.field_70159_w * 1.8;
                mop.field_72308_g.field_70181_x = this.field_70181_x + 0.5;
                mop.field_72308_g.field_70179_y = this.field_70179_y * 1.8;
                mop.field_72308_g.field_70177_z += 30.0f * (float)this.field_70173_aa;
                if (mop.field_72308_g instanceof EntityPlayerMP && !this.field_70170_p.field_72995_K) {
                    ((EntityPlayerMP)mop.field_72308_g).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(mop.field_72308_g));
                }
            }
        }
    }

    private void attackNearbyEntities() {
        if (this.getDamage() > 0.0f) {
            double d = Math.max(0.5, (double)this.getArea() - 1.0);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(d, d, d));
            for (EntityLivingBase entity : entities) {
                if (this.affectedEntities.contains(entity.func_145782_y()) || entity == this.func_85052_h() && this.field_70173_aa < 8) continue;
                entity.func_70097_a(new EntityDamageSourceIndirect("tornado", (Entity)this, (Entity)this.func_85052_h()).func_76349_b().func_82726_p(), this.getDamage());
                this.affectedEntities.add(entity.func_145782_y());
            }
        }
    }

    private void captureDrops() {
        if (!this.field_70128_L) {
            double d = Math.max(0.5, (double)this.getArea() - 1.0);
            List items = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(d, d, d));
            for (EntityItem item : items) {
                this.capturedItems.add(item.func_92059_d());
                item.func_70106_y();
            }
        }
    }

    private void releaseDrops() {
        for (ItemStack stack : this.capturedItems) {
            WorldUtils.spawnItemWithRandom(this.field_70170_p, stack, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void destroyLeaves() {
        ArrayList<ChunkPosition> affectedBlockPositions = new ArrayList<ChunkPosition>(WorldUtils.getAffectedBlocksList(this.field_70170_p, this.field_70146_Z, this.getArea(), this.field_70165_t, this.field_70163_u, this.field_70161_v, null));
        for (ChunkPosition chunkposition : affectedBlockPositions) {
            int i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            int k = chunkposition.field_151328_c;
            Material m = this.field_70170_p.func_147439_a(i, j, k).func_149688_o();
            if ((m != Material.field_151584_j || !this.canGrief || !Config.canDekuDenude()) && m != Material.field_151585_k && m != Material.field_151582_l && m != Material.field_151569_G) continue;
            this.field_70170_p.func_147480_a(i, j, k, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticleRing() {
        this.yaw += this.yawVelocity;
        if ((double)this.yaw > Math.PI * 2) {
            this.yaw = (float)((double)this.yaw - Math.PI * 2);
        }
        if (Math.random() < 0.1) {
            pitchVelocity = 0.2f;
        }
        this.pitch += pitchVelocity;
        if (this.pitch > maxPitch) {
            this.pitch = maxPitch;
        }
        pitchVelocity = pitchVelocity > 0.0f ? (pitchVelocity -= 0.05f) : 0.0f;
        this.pitch = this.pitch > 0.0f ? (this.pitch -= 0.07f) : 0.0f;
        EffectRenderer effectRenderer = Minecraft.func_71410_x().field_71452_i;
        FXCycloneRing ring = new FXCycloneRing(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, this.yaw, this.pitch, 0.7f, effectRenderer);
        effectRenderer.func_78873_a((EntityFX)ring);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("areaOfEffect", this.getArea());
        compound.func_74783_a("affectedEntities", ArrayUtils.toPrimitive((Integer[])this.affectedEntities.toArray(new Integer[this.affectedEntities.size()])));
        NBTTagList items = new NBTTagList();
        for (ItemStack stack : this.capturedItems) {
            NBTTagCompound dropNBT = new NBTTagCompound();
            stack.func_77955_b(dropNBT);
            items.func_74742_a((NBTBase)dropNBT);
        }
        compound.func_74782_a("items", (NBTBase)items);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setArea(compound.func_74760_g("areaOfEffect"));
        int[] entities = compound.func_74759_k("affectedEntities");
        for (int i = 0; i < entities.length; ++i) {
            this.affectedEntities.add(entities[i]);
        }
        NBTTagList items = compound.func_150295_c("items", (int)compound.func_74732_a());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            this.capturedItems.add(ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i)));
        }
    }
}

