/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.util.WorldUtils;

public class EntitySeedShot
extends EntityThrowable {
    protected static final int CRITICAL_INDEX = 22;
    protected static final int SEEDTYPE_INDEX = 23;
    private float damage = 2.0f;
    private int knockback = 0;

    public EntitySeedShot(World world) {
        super(world);
    }

    public EntitySeedShot(World world, EntityLivingBase entity, float velocity) {
        this(world, entity, velocity, 1, 0.0f);
    }

    public EntitySeedShot(World world, EntityLivingBase entity, float velocity, int n, float spread) {
        super(world, entity);
        if (n > 1) {
            this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            float rotFactor = (float)(n / 2) * spread;
            this.field_70177_z += rotFactor * (float)(n % 2 == 0 ? 1 : -1);
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70129_M = 0.0f;
            float f = 0.4f;
            this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
            this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.func_70183_g()) / 180.0f * (float)Math.PI)) * f;
        }
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
    }

    public EntitySeedShot(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)SeedType.GRASS.ordinal());
    }

    public void setIsCritical(boolean isCrit) {
        this.field_70180_af.func_75692_b(22, (Object)((byte)(isCrit ? 1 : 0)));
    }

    public boolean getIsCritical() {
        return this.field_70180_af.func_75683_a(22) > 0;
    }

    public EntitySeedShot setType(SeedType type) {
        this.field_70180_af.func_75692_b(23, (Object)type.ordinal());
        return this;
    }

    public SeedType getType() {
        return SeedType.values()[this.field_70180_af.func_75679_c(23)];
    }

    public void setDamage(float value) {
        this.damage = value;
    }

    public float getDamage() {
        return this.damage;
    }

    public DamageSource getDamageSource() {
        switch (this.getType()) {
            case DEKU: {
                return new DamageUtils.DamageSourceStunIndirect("slingshot", (Entity)this, (Entity)this.func_85052_h(), 80, 2).setCanStunPlayers().func_76349_b();
            }
            case NETHERWART: {
                return new EntityDamageSourceIndirect("slingshot", (Entity)this, (Entity)this.func_85052_h()).func_76361_j().func_76349_b();
            }
        }
        return new EntityDamageSourceIndirect("slingshot", (Entity)this, (Entity)this.func_85052_h()).func_76349_b();
    }

    public void setKnockback(int value) {
        this.knockback = value;
    }

    public int getKnockback() {
        return this.knockback;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        String particle = this.getType() == SeedType.DEKU ? "largeexplode" : "crit";
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_72869_a(particle, this.field_70165_t - this.field_70159_w * (double)i / 4.0, this.field_70163_u - this.field_70181_x * (double)i / 4.0, this.field_70161_v - this.field_70179_y * (double)i / 4.0, this.field_70159_w, this.field_70181_x + 0.2, this.field_70179_y);
        }
        if (mop.field_72308_g != null) {
            if (this.func_70027_ad() && !(mop.field_72308_g instanceof EntityEnderman)) {
                mop.field_72308_g.func_70015_d(5);
            }
            if (mop.field_72308_g.func_70097_a(this.getDamageSource(), this.calculateDamage())) {
                float f;
                this.func_85030_a("random.successful_hit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (this.knockback > 0 && (f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                    double d = (double)this.knockback * (double)0.6f / (double)f;
                    mop.field_72308_g.func_70024_g(this.field_70159_w * d, 0.1, this.field_70179_y * d);
                }
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase entity = (EntityLivingBase)mop.field_72308_g;
                    switch (this.getType()) {
                        case COCOA: {
                            entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 0));
                            break;
                        }
                        case PUMPKIN: {
                            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 0));
                            break;
                        }
                    }
                    if (this.func_85052_h() instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)mop.field_72308_g), (Entity)this.func_85052_h());
                        EnchantmentHelper.func_151385_b((EntityLivingBase)this.func_85052_h(), (Entity)mop.field_72308_g);
                    }
                }
                if (!(mop.field_72308_g instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
            }
        } else {
            this.func_85030_a("random.successful_hit", 0.3f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == Blocks.field_150471_bO) {
                WorldUtils.activateButton(this.field_70170_p, Blocks.field_150471_bO, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            }
            this.func_70106_y();
        }
    }

    protected float calculateDamage() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        float dmg = f * this.damage;
        if (this.getIsCritical()) {
            dmg += this.field_70146_Z.nextFloat() * (this.damage / 4.0f) + 0.25f;
        }
        return dmg;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isCritical", this.getIsCritical());
        compound.func_74774_a("seedType", (byte)this.getType().ordinal());
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("knockback", this.knockback);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setIsCritical(compound.func_74767_n("isCritical"));
        this.setType(SeedType.values()[compound.func_74771_c("seedType")]);
        this.damage = compound.func_74760_g("damage");
        this.knockback = compound.func_74762_e("knockback");
    }

    public static enum SeedType {
        NONE,
        COCOA,
        DEKU,
        GRASS,
        MELON,
        NETHERWART,
        PUMPKIN;

    }
}

