/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityChu;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemChuJelly
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private static final Map<EntityChu.ChuType, Item> jellyMap = new EnumMap<EntityChu.ChuType, Item>(EntityChu.ChuType.class);

    public ItemChuJelly() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabMisc);
    }

    private EntityChu.ChuType getType(ItemStack stack) {
        return EntityChu.ChuType.values()[stack.func_77960_j() % EntityChu.ChuType.values().length];
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity.getClass().isAssignableFrom(EntityVillager.class)) {
            EntityVillager entityVillager = (EntityVillager)entity;
            ZSSVillagerInfo villager = ZSSVillagerInfo.get(entityVillager);
            MerchantRecipeList trades = entityVillager.func_70934_b(player);
            EntityChu.ChuType type = this.getType(stack);
            entityVillager.func_70642_aH();
            if (villager != null && villager.isChuTrader() && jellyMap.containsKey((Object)type)) {
                if (villager.getJelliesReceived(type) == 0) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.jelly.first"));
                    villager.addJelly(type, 1);
                    --stack.field_77994_a;
                } else if (villager.canSellType(type, stack)) {
                    MerchantRecipe trade = new MerchantRecipe(new ItemStack(stack.func_77973_b(), 4, type.ordinal()), new ItemStack(Items.field_151166_bC, (type.ordinal() + 1) * 8), new ItemStack(jellyMap.get((Object)type)));
                    if (MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                        player.field_70170_p.func_72956_a((Entity)player, "zeldaswordskills:success", 1.0f, 1.0f);
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.jelly.new_stock"));
                        PlayerUtils.addItemToInventory(player, new ItemStack(jellyMap.get((Object)type)));
                    } else {
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.jelly.in_stock"));
                    }
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.jelly.need_more"));
                }
                if (stack.field_77994_a == 0) {
                    player.func_70062_b(0, null);
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.jelly.gross"));
            }
        }
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EntityChu.ChuType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.iconArray[damage % EntityChu.ChuType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[EntityChu.ChuType.values().length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.jelly_chu.desc.0"));
    }

    public static void initializeJellies() {
        jellyMap.put(EntityChu.ChuType.RED, ZSSItems.potionRed);
        jellyMap.put(EntityChu.ChuType.GREEN, ZSSItems.potionGreen);
        jellyMap.put(EntityChu.ChuType.BLUE, ZSSItems.potionBlue);
        jellyMap.put(EntityChu.ChuType.YELLOW, ZSSItems.potionYellow);
    }
}

