/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.item.IHandleToss;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.item.ZSSItems;

public class ItemHeldBlock
extends Item
implements IHandleToss,
IUnenchantable {
    public ItemHeldBlock() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_111206_d("stone");
    }

    public static ItemStack getBlockStack(Block block, int metadata, ItemStack gauntlets) {
        ItemStack stack = new ItemStack(ZSSItems.heldBlock);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("blockID", Block.func_149682_b((Block)block));
        stack.func_77978_p().func_74768_a("metadata", metadata);
        if (gauntlets != null) {
            stack.func_77978_p().func_74782_a("gauntlets", (NBTBase)gauntlets.func_77955_b(new NBTTagCompound()));
        }
        return stack;
    }

    public Block getBlockFromStack(ItemStack stack) {
        return stack.func_77942_o() ? Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID")) : null;
    }

    public int getMetaFromStack(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("metadata") : 0;
    }

    public boolean dropHeldBlock(ItemStack stack, World world, EntityPlayer player) {
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        int meta = this.getMetaFromStack(stack);
        Block block = this.getBlockFromStack(stack);
        if (block != null) {
            int dx;
            Vec3 vec3 = player.func_70040_Z();
            int n = Math.abs(vec3.field_72450_a) < 0.25 ? 0 : (dx = vec3.field_72450_a < 0.0 ? -1 : 1);
            int dz = Math.abs(vec3.field_72449_c) < 0.25 ? 0 : (vec3.field_72449_c < 0.0 ? -1 : 1);
            boolean flag = this.tryDropBlock(stack, world, x + dx, y + 1, z + dz, dx, dz, block, meta, 4);
            if (!flag) {
                flag = this.tryDropBlock(stack, world, x, y + 1, z, -dx, -dz, block, meta, 5);
            }
            if (!flag && !block.func_149688_o().func_76220_a()) {
                flag = this.placeBlockAt(stack, player, world, x, y, z, 1, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, block, meta);
            }
            if (flag) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            }
            return flag;
        }
        return false;
    }

    private boolean tryDropBlock(ItemStack stack, World world, int x, int y, int z, int dx, int dz, Block block, int meta, int n) {
        boolean flag = false;
        for (int i = 0; i < n && !flag; ++i) {
            for (int j = 0; j < n - i && !flag; ++j) {
                for (int k = 0; k < 4 && !flag; ++k) {
                    flag = this.tryPlaceBlock(stack, world, x + dz * j, y - k, z + dx * j, block, meta);
                    if (flag) continue;
                    flag = this.tryPlaceBlock(stack, world, x - dz * j, y - k, z - dx * j, block, meta);
                }
            }
            x += dx;
            z += dz;
        }
        return flag;
    }

    private boolean tryPlaceBlock(ItemStack stack, World world, int x, int y, int z, Block block, int meta) {
        int placedMeta;
        Block b = world.func_147439_a(x, y, z);
        if (world.func_147439_a(x, y - 1, z).func_149730_j() && b.isReplaceable((IBlockAccess)world, x, y, z) && world.func_147472_a(block, x, y, z, false, 1, null, stack) && world.func_147465_d(x, y, z, block, placedMeta = block.func_149660_a(world, x, y, z, 1, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, meta), 3)) {
            if (world.func_147439_a(x, y, z) == block) {
                block.func_149714_e(world, x, y, z, placedMeta);
                if (block instanceof ILiftable) {
                    ((ILiftable)block).onHeldBlockPlaced(world, stack, x, y, z, placedMeta);
                }
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (isHeld) {
            if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
                entity.field_70159_w *= 0.25;
                entity.field_70179_y *= 0.25;
            }
        } else if (entity instanceof EntityPlayer && this.dropHeldBlock(stack, world, (EntityPlayer)entity)) {
            ItemStack gauntlets = stack.func_77942_o() && stack.func_77978_p().func_74764_b("gauntlets") ? ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("gauntlets")) : null;
            ((EntityPlayer)entity).field_71071_by.func_70299_a(slot, gauntlets);
        }
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150431_aC) {
            side = 1;
        } else if (b != Blocks.field_150395_bd && b != Blocks.field_150329_H && b != Blocks.field_150330_I && !b.isReplaceable((IBlockAccess)world, x, y, z)) {
            switch (side) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                    break;
                }
            }
        }
        Block block = this.getBlockFromStack(stack);
        if (block == null || stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, stack) && !(block instanceof ILiftable)) {
            return false;
        }
        if (y == 255 && block.func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147472_a(block, x, y, z, false, side, null, stack)) {
            int meta = this.getMetaFromStack(stack);
            int placedMeta = block.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, meta);
            if (this.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, block, placedMeta)) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                ItemStack gauntlets = stack.func_77942_o() && stack.func_77978_p().func_74764_b("gauntlets") ? ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("gauntlets")) : null;
                player.func_70062_b(0, gauntlets);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, Block block, int meta) {
        if (!world.func_147465_d(x, y, z, block, meta, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == block) {
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_149714_e(world, x, y, z, meta);
            if (block instanceof ILiftable) {
                ((ILiftable)block).onHeldBlockPlaced(world, stack, x, y, z, meta);
            }
        }
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        Block block = this.getBlockFromStack(stack);
        return block != null ? block.func_149739_a() : Blocks.field_150348_b.func_149739_a();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        Block block = this.getBlockFromStack(stack);
        return block != null ? block.func_149691_a(1, this.getMetaFromStack(stack)) : Blocks.field_150348_b.func_149691_a(1, 0);
    }

    @Override
    public void onItemTossed(EntityItem item, EntityPlayer player) {
        ItemStack stack = item.func_92059_d();
        if (this.dropHeldBlock(stack, player.func_130014_f_(), player)) {
            ItemStack gauntlets = stack.func_77942_o() && stack.func_77978_p().func_74764_b("gauntlets") ? ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("gauntlets")) : null;
            player.func_70062_b(0, gauntlets);
            item.func_70106_y();
        }
    }
}

