/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemKeyBig
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemKeyBig() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabKeys);
    }

    public static ItemStack getKeyForBiome(World world, int x, int z) {
        BossType type = BossType.getBossType(world, x, z);
        if (type != null) {
            return new ItemStack(ZSSItems.keyBig, 1, type.ordinal());
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity.getClass().isAssignableFrom(EntityVillager.class)) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 16));
                if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sell.0"));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.1"));
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.0"));
            }
        }
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.func_147439_a(x, y, z) == ZSSBlocks.doorLocked && stack.func_77960_j() == (world.func_72805_g(x, y, z) & 0xFFFFFFF7)) {
            --stack.field_77994_a;
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_door", 0.4f, 0.5f);
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74837_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[]{BossType.values()[stack.func_77960_j() % BossType.values().length].getDisplayName()});
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a().substring(9) + stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (BossType boss : BossType.values()) {
            list.add(new ItemStack(item, 1, boss.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.iconArray[damage % BossType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[BossType.values().length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:key_" + BossType.values()[i].getUnlocalizedName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.keybig.desc.0"));
    }
}

