/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IZoom;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntitySeedShot;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemSlingshot
extends Item
implements IFairyUpgrade,
IUnenchantable,
IZoom,
IBattlegearWeapon {
    protected final int seedsFired;
    protected final float spread;
    private static final Map<EntitySeedShot.SeedType, Item> typeToSeed = new EnumMap<EntitySeedShot.SeedType, Item>(EntitySeedShot.SeedType.class);

    public static void initializeSeeds() {
        typeToSeed.put(EntitySeedShot.SeedType.COCOA, Items.field_151100_aR);
        typeToSeed.put(EntitySeedShot.SeedType.DEKU, ZSSItems.dekuNut);
        typeToSeed.put(EntitySeedShot.SeedType.GRASS, Items.field_151014_N);
        typeToSeed.put(EntitySeedShot.SeedType.MELON, Items.field_151081_bc);
        typeToSeed.put(EntitySeedShot.SeedType.NETHERWART, Items.field_151075_bm);
        typeToSeed.put(EntitySeedShot.SeedType.PUMPKIN, Items.field_151080_bb);
    }

    public ItemSlingshot() {
        this(1, 0.0f);
    }

    public ItemSlingshot(int seedsFired, float spread) {
        this.seedsFired = seedsFired;
        this.spread = spread;
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMaxZoomTime() {
        return 20.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getZoomFactor() {
        return 0.15f;
    }

    public int func_77619_b() {
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.hasSeeds(player)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int ticksUsed) {
        int charge = this.func_77626_a(stack) - ticksUsed;
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        EntitySeedShot.SeedType type = this.getSeedType(player);
        if (f < 0.3f || type == EntitySeedShot.SeedType.NONE) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        for (int i = 0; i < this.seedsFired; ++i) {
            float factor;
            EntitySeedShot seedShot = new EntitySeedShot(world, (EntityLivingBase)player, f, i + 1, this.spread).setType(type);
            if (f == 1.0f) {
                seedShot.setIsCritical(true);
            }
            float f2 = this.seedsFired == 1 ? 2.2f : (factor = this.seedsFired < 4 ? 1.4f : 1.0f);
            float damage = type == EntitySeedShot.SeedType.GRASS ? 1.0f : (type == EntitySeedShot.SeedType.NETHERWART || type == EntitySeedShot.SeedType.DEKU ? 1.5f : 1.25f);
            int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
            if (k > 0) {
                damage += (float)k * 0.25f + 0.25f;
            }
            seedShot.setDamage(damage * factor);
            int l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack);
            seedShot.setKnockback(l > 0 ? l : (type == EntitySeedShot.SeedType.MELON ? 1 : 0));
            if (type == EntitySeedShot.SeedType.NETHERWART || EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                seedShot.func_70015_d(100);
            }
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)seedShot);
        }
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        if (!player.field_71075_bZ.field_75098_d) {
            Item seed;
            PlayerUtils.consumeInventoryItem(player, seed, (seed = typeToSeed.get((Object)type)) == Items.field_151100_aR ? 3 : 0, 1);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 6 + 2 * this.seedsFired));
                if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sell.0"));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.1"));
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.0"));
            }
        }
        return true;
    }

    protected boolean hasSeeds(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ItemSeeds || stack.func_77973_b() == ZSSItems.dekuNut) {
                return true;
            }
            if (stack.func_77973_b() != Items.field_151100_aR || stack.func_77960_j() != 3) continue;
            return true;
        }
        return false;
    }

    protected EntitySeedShot.SeedType getSeedType(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null) continue;
            if (stack.func_77973_b() == Items.field_151014_N) {
                return EntitySeedShot.SeedType.GRASS;
            }
            if (stack.func_77973_b() == Items.field_151081_bc) {
                return EntitySeedShot.SeedType.MELON;
            }
            if (stack.func_77973_b() == Items.field_151075_bm) {
                return EntitySeedShot.SeedType.NETHERWART;
            }
            if (stack.func_77973_b() == Items.field_151080_bb) {
                return EntitySeedShot.SeedType.PUMPKIN;
            }
            if (stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 3) {
                return EntitySeedShot.SeedType.COCOA;
            }
            if (stack.func_77973_b() != ZSSItems.dekuNut) continue;
            return EntitySeedShot.SeedType.DEKU;
        }
        return player.field_71075_bZ.field_75098_d ? EntitySeedShot.SeedType.GRASS : EntitySeedShot.SeedType.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.slingshot.desc.0"));
        if (this.seedsFired > 1) {
            list.add(EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"tooltip.zss.slingshot.desc.1", (Object[])new Object[]{this.seedsFired}));
        }
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.func_92059_d();
        if (stack.func_77973_b() == ZSSItems.slingshot && core.consumeRupees(Config.getSlingshotCostOne())) {
            item.func_70106_y();
            player.func_71029_a((StatBase)ZSSAchievements.fairySlingshot);
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.scattershot), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else if (stack.func_77973_b() == ZSSItems.scattershot && core.consumeRupees(Config.getSlingshotCostTwo())) {
            item.func_70106_y();
            player.func_71029_a((StatBase)ZSSAchievements.fairySupershot);
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.supershot), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            this.addFairyEnchantments(stack, player, core);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return true;
    }

    private void addFairyEnchantments(ItemStack stack, EntityPlayer player, TileEntityDungeonCore core) {
        int newLvl;
        byte hearts = ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.bonusHeart);
        int divisor = this.seedsFired == 1 ? 5 : (this.seedsFired < 4 ? 7 : 10);
        int lvl = newLvl = Math.min(hearts / divisor, Enchantment.field_77345_t.func_77325_b());
        boolean flag = false;
        boolean playSound = false;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("ench")) {
            NBTTagList enchList = (NBTTagList)stack.func_77978_p().func_74781_a("ench");
            for (int i = 0; i < enchList.func_74745_c(); ++i) {
                NBTTagCompound compound = enchList.func_150305_b(i);
                if (compound.func_74765_d("id") != Enchantment.field_77345_t.field_77352_x) continue;
                short oldLvl = compound.func_74765_d("lvl");
                for (lvl = newLvl - oldLvl; lvl > 0 && core.consumeRupees(divisor * 2); --lvl) {
                }
                if ((newLvl -= lvl) > oldLvl) {
                    enchList.func_74744_a(i);
                    stack.func_77966_a(Enchantment.field_77345_t, newLvl);
                    playSound = true;
                }
                flag = true;
                break;
            }
        }
        if (!flag) {
            while (lvl > 0 && core.consumeRupees(divisor * 2)) {
                --lvl;
            }
            if ((newLvl -= lvl) > 0) {
                playSound = true;
                stack.func_77966_a(Enchantment.field_77345_t, newLvl);
            }
        }
        if (playSound) {
            player.func_71029_a((StatBase)ZSSAchievements.fairyEnchantment);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_blessing", 1.0f, 1.0f);
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.fairy.laugh.unworthy"));
        }
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return false;
    }
}

