/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.client.PacketISpawnParticles;
import zeldaswordskills.util.LogHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemSpiritCrystal
extends Item
implements ISacredFlame,
ISpawnParticles {
    private final int spiritType;
    private final int costToUse;
    private final int timeToUse;

    public ItemSpiritCrystal(int type, int cost, int time) {
        this.spiritType = type;
        this.costToUse = cost;
        this.timeToUse = time;
        this.func_77656_e(128);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int cost = 0;
        if (!ZSSPlayerInfo.get(player).isNayruActive()) {
            if (this.spiritType == 2 && player.func_70093_af()) {
                this.mark(stack, world, player);
                cost = 1;
            } else if (this.spiritType == 4) {
                cost = this.handleNayru(stack, world, player);
            } else {
                player.func_71008_a(stack, this.func_77626_a(stack));
                String sound = this.spiritType == 1 ? "zeldaswordskills:success" : "zeldaswordskills:flame_absorb";
                player.func_85030_a(sound, 1.0f, 1.0f);
            }
            if (this.damageStack(stack, player, cost)) {
                stack = new ItemStack(ZSSItems.crystalSpirit);
            }
        } else {
            player.func_85030_a("zeldaswordskills:magic_failure", 1.0f, 1.0f);
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int ticksRemaining) {
        if (this.func_77626_a(stack) - ticksRemaining > this.timeToUse) {
            int cost = 0;
            switch (this.spiritType) {
                case 1: {
                    cost = this.handleDin(stack, world, player);
                    break;
                }
                case 2: {
                    cost = this.handleFarore(stack, world, player);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    LogHelper.warning("Invalid spirit type " + this.spiritType + " while using spirit crystal");
                }
            }
            if (this.damageStack(stack, player, cost)) {
                player.func_70062_b(0, new ItemStack(ZSSItems.crystalSpirit));
            }
        }
    }

    @Override
    public boolean onActivatedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        return false;
    }

    @Override
    public boolean onClickedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        if (world.field_72995_K) {
            return false;
        }
        if (stack.func_77960_j() == 0) {
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.spirit_crystal.sacred_flame.full"));
        } else if (isActive) {
            if (this.spiritType == type) {
                int originalDamage = stack.func_77960_j();
                stack.func_77964_b(0);
                world.func_72956_a((Entity)player, "zeldaswordskills:success", 1.0f, 1.0f);
                return world.field_73012_v.nextInt(stack.func_77958_k()) < originalDamage;
            }
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.spirit_crystal.sacred_flame.mismatch"));
        } else {
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.sacred_flame.inactive"));
        }
        return false;
    }

    private boolean damageStack(ItemStack stack, EntityPlayer player, int amount) {
        if (amount > 0) {
            stack.func_77972_a(amount, (EntityLivingBase)player);
            return stack.field_77994_a == 0;
        }
        return false;
    }

    private boolean canUse(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77960_j() >= this.costToUse;
    }

    private int handleDin(ItemStack stack, World world, EntityPlayer player) {
        float radius = 5.0f;
        if (!world.field_72995_K) {
            PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, this, radius), player, 64.0);
            this.affectDinBlocks(world, player, radius);
        }
        this.affectDinEntities(world, player, radius);
        world.func_72956_a((Entity)player, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        return this.costToUse;
    }

    private void affectDinBlocks(World world, EntityPlayer player, float radius) {
        ArrayList<ChunkPosition> affectedBlockPositions = new ArrayList<ChunkPosition>(WorldUtils.getAffectedBlocksList(world, world.field_73012_v, radius, player.field_70165_t, player.field_70163_u, player.field_70161_v, null));
        for (ChunkPosition chunkposition : affectedBlockPositions) {
            int i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            int k = chunkposition.field_151328_c;
            Block block = world.func_147439_a(i, j, k);
            if (block.func_149688_o() == Material.field_151579_a && Config.isDinIgniteEnabled()) {
                Block block1 = world.func_147439_a(i, j - 1, k);
                if (!block1.func_149730_j() || world.field_73012_v.nextInt(8) != 0) continue;
                world.func_147449_b(i, j, k, (Block)Blocks.field_150480_ab);
                continue;
            }
            if (!WorldUtils.canMeltBlock(world, block, i, j, k)) continue;
            world.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            world.func_147468_f(i, j, k);
        }
    }

    private void affectDinEntities(World world, EntityPlayer player, float radius) {
        int i = MathHelper.func_76128_c((double)(player.field_70165_t - (double)radius - 1.0));
        int j = MathHelper.func_76128_c((double)(player.field_70165_t + (double)radius + 1.0));
        int k = MathHelper.func_76128_c((double)(player.field_70163_u - (double)radius - 1.0));
        int l1 = MathHelper.func_76128_c((double)(player.field_70163_u + (double)radius + 1.0));
        int i2 = MathHelper.func_76128_c((double)(player.field_70161_v - (double)radius - 1.0));
        int j2 = MathHelper.func_76128_c((double)(player.field_70161_v + (double)radius + 1.0));
        List list = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)i2, (double)j, (double)l1, (double)j2));
        Vec3 vec3 = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d2;
            Entity entity;
            double d0 = entity.field_70165_t - player.field_70165_t;
            entity = (Entity)list.get(k2);
            double d1 = entity.field_70163_u + (double)entity.func_70047_e() - player.field_70163_u;
            double d8 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + (d2 = entity.field_70161_v - player.field_70161_v) * d2));
            if (d8 == 0.0) continue;
            d0 /= d8;
            d1 /= d8;
            d2 /= d8;
            double d10 = world.func_72842_a(vec3, entity.field_70121_D);
            float amount = 32.0f * (float)d10;
            if (entity.func_70045_F()) {
                amount *= 0.25f;
            }
            if (entity.func_70097_a(new EntityDamageSourceIndirect("magic.din", (Entity)player, (Entity)player).func_76361_j().func_82726_p(), amount) && !entity.func_70045_F() && (double)world.field_73012_v.nextFloat() < d10) {
                entity.func_70015_d(10);
            }
            double d11 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d10);
            entity.field_70159_w += d0 * d11;
            entity.field_70181_x += d1 * d11;
            entity.field_70179_y += d2 * d11;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double posX, double posY, double posZ, float radius, Vec3 lookVector) {
        int i1 = MathHelper.func_76128_c((double)(posX + (double)radius));
        int j1 = MathHelper.func_76128_c((double)(posY + (double)radius));
        int k1 = MathHelper.func_76128_c((double)(posZ + (double)radius));
        for (int i = MathHelper.func_76128_c((double)(posX - (double)radius)); i < i1; ++i) {
            for (int j = MathHelper.func_76128_c((double)(posY - (double)radius + 1.0)); j < j1; ++j) {
                for (int k = MathHelper.func_76128_c((double)(posZ - (double)radius)); k < k1; ++k) {
                    double d0 = (float)i + world.field_73012_v.nextFloat();
                    double d1 = (float)j + world.field_73012_v.nextFloat();
                    double d2 = (float)k + world.field_73012_v.nextFloat();
                    double d3 = d0 - posX;
                    double d4 = d1 - posY;
                    double d5 = d2 - posZ;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)radius + 0.1);
                    world.func_72869_a("flame", (d0 + posX * 1.0) / 2.0, (d1 + posY * 1.0) / 2.0, (d2 + posZ * 1.0) / 2.0, d3 *= (d7 *= (double)(world.field_73012_v.nextFloat() * world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    world.func_72869_a("smoke", d0, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    private int handleFarore(ItemStack stack, World world, EntityPlayer player) {
        if (this.canUse(stack)) {
            double[] coordinates = this.getRecallCoordinates(stack);
            if (coordinates != null) {
                if (this.getDimension(stack) == player.field_70170_p.field_73011_w.field_76574_g) {
                    player.func_70634_a(coordinates[0], coordinates[1], coordinates[2]);
                    player.func_85030_a("zeldaswordskills:success", 1.0f, 1.0f);
                    return this.costToUse;
                }
                player.func_85030_a("zeldaswordskills:magic_failure", 1.0f, 1.0f);
                if (world.field_72995_K) {
                    PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.spirit_crystal.farore.fail.dimension", (Object[])new Object[]{StatCollector.func_74838_a((String)(this.func_77658_a() + ".name"))}));
                }
            } else {
                player.func_85030_a("zeldaswordskills:magic_failure", 1.0f, 1.0f);
                if (world.field_72995_K) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.spirit_crystal.farore.fail.mark"));
                }
            }
        }
        return 0;
    }

    private int handleNayru(ItemStack stack, World world, EntityPlayer player) {
        if (this.canUse(stack)) {
            ZSSPlayerInfo.get(player).activateNayru();
            world.func_72956_a((Entity)player, "zeldaswordskills:success", 1.0f, 1.0f);
            return this.costToUse;
        }
        return 0;
    }

    private void mark(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("zssFWdimension", world.field_73011_w.field_76574_g);
        stack.func_77978_p().func_74780_a("zssFWposX", player.field_70165_t);
        stack.func_77978_p().func_74780_a("zssFWposY", player.field_70163_u);
        stack.func_77978_p().func_74780_a("zssFWposZ", player.field_70161_v);
        world.func_72956_a((Entity)player, "zeldaswordskills:success", 1.0f, 1.0f);
    }

    private int getDimension(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("zssFWdimension") ? stack.func_77978_p().func_74762_e("zssFWdimension") : Integer.MAX_VALUE;
    }

    private double[] getRecallCoordinates(ItemStack stack) {
        double[] coordinates = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("zssFWposX")) {
            coordinates = new double[]{stack.func_77978_p().func_74769_h("zssFWposX"), stack.func_77978_p().func_74769_h("zssFWposY"), stack.func_77978_p().func_74769_h("zssFWposZ")};
        }
        return coordinates;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.1")));
    }
}

