/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.client.render.item.RenderBigItem;
import zeldaswordskills.client.render.item.RenderHeldItemBlock;
import zeldaswordskills.client.render.item.RenderItemBomb;
import zeldaswordskills.client.render.item.RenderItemBombBag;
import zeldaswordskills.client.render.item.RenderItemCustomBow;
import zeldaswordskills.client.render.item.RenderItemDungeonBlock;
import zeldaswordskills.client.render.item.RenderItemShield;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityChu;
import zeldaswordskills.entity.EntityKeese;
import zeldaswordskills.entity.EntityOctorok;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemArmorBoots;
import zeldaswordskills.item.ItemArmorTunic;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ItemBoomerang;
import zeldaswordskills.item.ItemBrokenSword;
import zeldaswordskills.item.ItemChuJelly;
import zeldaswordskills.item.ItemCustomEgg;
import zeldaswordskills.item.ItemCustomVariantEgg;
import zeldaswordskills.item.ItemDekuLeaf;
import zeldaswordskills.item.ItemDoorLocked;
import zeldaswordskills.item.ItemFairyBottle;
import zeldaswordskills.item.ItemHammer;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.item.ItemHeroBow;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ItemKeyBig;
import zeldaswordskills.item.ItemMagicMirror;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemMiscZSS;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ItemPickupOnly;
import zeldaswordskills.item.ItemPowerGauntlets;
import zeldaswordskills.item.ItemSkillOrb;
import zeldaswordskills.item.ItemSlingshot;
import zeldaswordskills.item.ItemSpiritCrystal;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ItemZeldaArrow;
import zeldaswordskills.item.ItemZeldaPotion;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.dispenser.BehaviorDispenseCustomMobEgg;
import zeldaswordskills.lib.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.LogHelper;

public class ZSSItems {
    private static final Map<Item, Integer> itemList = new HashMap<Item, Integer>(256);
    private static int sortId = 0;
    private static Comparator<Item> itemComparator = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            if (itemList.containsKey(a) && itemList.containsKey(b)) {
                return (Integer)itemList.get(a) - (Integer)itemList.get(b);
            }
            LogHelper.warning(String.format("A mod item %s or %s is missing a comparator mapping", a.func_77658_a(), b.func_77658_a()));
            return GameData.getItemRegistry().getId((Object)a) - GameData.getItemRegistry().getId((Object)b);
        }
    };
    public static Comparator<ItemStack> itemstackComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack a, ItemStack b) {
            if (a.func_77973_b() == b.func_77973_b()) {
                if (a.func_77973_b() == skillOrb && (a.func_77960_j() == SkillBase.bonusHeart.getId() || b.func_77960_j() == SkillBase.bonusHeart.getId())) {
                    return a.func_77960_j() == SkillBase.bonusHeart.getId() ? 127 : -128;
                }
                return a.func_77960_j() - b.func_77960_j();
            }
            return itemComparator.compare(a.func_77973_b(), b.func_77973_b());
        }
    };
    private static boolean enableGrassArrowDrop;
    private static boolean enableGrassBombDrop;
    private static boolean enableGrassEmeraldDrop;
    private static boolean enableBombLoot;
    private static boolean enableBombBagLoot;
    private static boolean enableHeartLoot;
    private static boolean allowGoldSmelting;
    private static boolean enableStartingGear;
    private static boolean enableAutoEquip;
    private static boolean enableOrb;
    private static boolean enableFullSet;
    private static boolean enableTunic;
    private static boolean enableSword;
    private static final List<ItemStack> grassDrops;
    public static final ItemArmor.ArmorMaterial WOOD;
    public static Item skillWiper;
    public static Item skillOrb;
    public static Item heartPiece;
    public static Item keyBig;
    public static Item keySkeleton;
    public static Item keySmall;
    public static Item bomb;
    public static Item bombBag;
    public static Item magicMirror;
    public static Item crystalSpirit;
    public static Item crystalDin;
    public static Item crystalFarore;
    public static Item crystalNayru;
    public static Item dekuLeaf;
    public static Item dekuNut;
    public static Item gauntletsSilver;
    public static Item gauntletsGolden;
    public static Item hookshot;
    public static Item hookshotAddon;
    public static Item rodFire;
    public static Item rodIce;
    public static Item rodTornado;
    public static Item fairyBottle;
    public static Item potionRed;
    public static Item potionGreen;
    public static Item potionBlue;
    public static Item potionYellow;
    public static Item rocsFeather;
    public static Item pendant;
    public static Item masterOre;
    public static Item jellyChu;
    public static Item treasure;
    public static Item doorLocked;
    public static Item heldBlock;
    public static Item powerPiece;
    public static Item smallHeart;
    public static Item throwingRock;
    public static Item tunicHeroHelm;
    public static Item tunicHeroChest;
    public static Item tunicHeroLegs;
    public static Item tunicHeroBoots;
    public static Item tunicGoronHelm;
    public static Item tunicGoronChest;
    public static Item tunicGoronLegs;
    public static Item tunicZoraHelm;
    public static Item tunicZoraChest;
    public static Item tunicZoraLegs;
    public static Item bootsHeavy;
    public static Item bootsHover;
    public static Item bootsPegasus;
    public static Item bootsRubber;
    public static Item shieldDeku;
    public static Item shieldHylian;
    public static Item shieldMirror;
    public static Item swordBroken;
    public static Item swordKokiri;
    public static Item swordOrdon;
    public static Item swordGiant;
    public static Item swordBiggoron;
    public static Item swordMaster;
    public static Item swordTempered;
    public static Item swordGolden;
    public static Item swordMasterTrue;
    public static Item hammer;
    public static Item hammerSkull;
    public static Item hammerMegaton;
    public static Item boomerang;
    public static Item boomerangMagic;
    public static Item slingshot;
    public static Item scattershot;
    public static Item supershot;
    public static Item heroBow;
    public static Item arrowBomb;
    public static Item arrowBombWater;
    public static Item arrowBombFire;
    public static Item arrowFire;
    public static Item arrowIce;
    public static Item arrowLight;
    public static Item maskBlast;
    public static Item maskBunny;
    public static Item maskCouples;
    public static Item maskGerudo;
    public static Item maskGiants;
    public static Item maskGibdo;
    public static Item maskHawkeye;
    public static Item maskKeaton;
    public static Item maskScents;
    public static Item maskSkull;
    public static Item maskSpooky;
    public static Item maskStone;
    public static Item maskTruth;
    public static Item maskDeku;
    public static Item maskGoron;
    public static Item maskZora;
    public static Item maskFierce;
    public static Item maskMajora;
    public static Item eggSpawner;
    public static Item eggChu;
    public static Item eggKeese;
    public static Item eggOctorok;

    public static void init(Configuration config) {
        enableGrassArrowDrop = config.get("Drops", "Enable arrow drops from grass (must use sword)", true).getBoolean(true);
        enableGrassBombDrop = config.get("Drops", "Enable bomb drops from grass (must use sword)", false).getBoolean(false);
        enableGrassEmeraldDrop = config.get("Drops", "Enable emerald drops from grass (must use sword)", true).getBoolean(true);
        enableBombLoot = config.get("Loot", "Enable bombs in vanilla chests", false).getBoolean(false);
        enableBombBagLoot = config.get("Loot", "Enable bomb bags in vanilla chests", false).getBoolean(false);
        enableHeartLoot = config.get("Loot", "Enable heart pieces in vanilla chests", false).getBoolean(false);
        allowGoldSmelting = config.get("Recipes", "Smelt all those disarmed pigmen swords into gold ingots", false).getBoolean(false);
        enableStartingGear = config.get("Bonus Gear", "Enable bonus starting equipment", false).getBoolean(false);
        enableAutoEquip = config.get("Bonus Gear", "Automatically equip starting equipment", true).getBoolean(true);
        enableOrb = config.get("Bonus Gear", "Grants a single Basic Sword skill orb", true).getBoolean(true);
        enableFullSet = config.get("Bonus Gear", "Grants a full set of Kokiri clothing: hat, tunic, trousers, boots", true).getBoolean(true);
        enableTunic = config.get("Bonus Gear", "Grants only a Kokiri Tunic (if full set is disabled)", true).getBoolean(true);
        enableSword = config.get("Bonus Gear", "Grants a Kokiri sword (a named wooden sword)", true).getBoolean(true);
    }

    public static void init() {
        ZSSItems.initItems();
        ZSSItems.registerItems();
        ItemChuJelly.initializeJellies();
        ItemHeroBow.initializeArrows();
        ItemSlingshot.initializeSeeds();
        ZSSItems.registerRecipes();
        ZSSItems.addVanillaDungeonLoot();
        TradeHandler.registerTrades();
        ZSSItems.addGrassDrops();
        ZSSItems.addDispenserBehaviors();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)bomb, (IItemRenderer)new RenderItemBomb());
        MinecraftForgeClient.registerItemRenderer((Item)bombBag, (IItemRenderer)new RenderItemBombBag());
        MinecraftForgeClient.registerItemRenderer((Item)hammer, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)hammerMegaton, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)hammerSkull, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)swordBiggoron, (IItemRenderer)new RenderBigItem(0.75f));
        MinecraftForgeClient.registerItemRenderer((Item)swordGiant, (IItemRenderer)new RenderBigItem(0.75f));
        MinecraftForgeClient.registerItemRenderer((Item)heroBow, (IItemRenderer)new RenderItemCustomBow());
        MinecraftForgeClient.registerItemRenderer((Item)shieldDeku, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)shieldHylian, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)shieldMirror, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)heldBlock, (IItemRenderer)new RenderHeldItemBlock());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ZSSBlocks.dungeonCore), (IItemRenderer)new RenderItemDungeonBlock());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ZSSBlocks.dungeonStone), (IItemRenderer)new RenderItemDungeonBlock());
    }

    private static void addGrassDrops() {
        for (int i = 0; i < 10; ++i) {
            grassDrops.add(new ItemStack(smallHeart));
            if (enableGrassArrowDrop && i % 3 == 2) {
                grassDrops.add(new ItemStack(Items.field_151032_g));
            }
            if (i % 3 != 0) continue;
            grassDrops.add(new ItemStack(dekuNut));
        }
        if (enableGrassBombDrop) {
            grassDrops.add(new ItemStack(bomb));
        }
        if (enableGrassEmeraldDrop) {
            grassDrops.add(new ItemStack(Items.field_151166_bC));
        }
    }

    public static ItemStack getRandomGrassDrop(Random rand) {
        return grassDrops.get(rand.nextInt(grassDrops.size()));
    }

    public static boolean grantBonusGear(EntityPlayer player) {
        if (!enableStartingGear) {
            return false;
        }
        if (enableSword) {
            player.field_71071_by.func_70441_a(new ItemStack(swordKokiri));
        }
        if (enableOrb) {
            player.field_71071_by.func_70441_a(new ItemStack(skillOrb, 1, (int)SkillBase.swordBasic.getId()));
        }
        if (enableFullSet) {
            ItemStack[] set = new ItemStack[]{new ItemStack(tunicHeroBoots), new ItemStack(tunicHeroLegs), new ItemStack(tunicHeroChest), new ItemStack(tunicHeroHelm)};
            for (int i = 0; i < set.length; ++i) {
                if (enableAutoEquip && player.func_82169_q(i) == null) {
                    player.func_70062_b(i + 1, set[i]);
                    continue;
                }
                player.field_71071_by.func_70441_a(set[i]);
            }
        } else if (enableTunic) {
            if (enableAutoEquip && player.func_82169_q(3) == null) {
                player.func_70062_b(3, new ItemStack(tunicHeroChest));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(tunicHeroChest));
            }
        }
        return true;
    }

    private static void initItems() {
        skillOrb = new ItemSkillOrb().func_77655_b("zss.skillorb");
        heartPiece = new ItemMiscZSS(12).func_77655_b("zss.heartpiece").func_77637_a(ZSSCreativeTabs.tabSkills);
        skillWiper = new ItemMiscZSS(0).func_77655_b("zss.skill_wiper").func_77637_a(ZSSCreativeTabs.tabSkills);
        tunicHeroHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.hero_tunic_helm");
        tunicHeroChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).func_77655_b("zss.hero_tunic_chest");
        tunicHeroLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.hero_tunic_legs");
        tunicGoronHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.goron_tunic_helm");
        tunicGoronChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).func_77655_b("zss.goron_tunic_chest");
        tunicGoronLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.goron_tunic_legs");
        tunicZoraHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.zora_tunic_helm");
        tunicZoraChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).setEffect(new PotionEffect(Potion.field_76427_o.func_76396_c(), 90, 0)).func_77655_b("zss.zora_tunic_chest");
        tunicZoraLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.zora_tunic_legs");
        tunicHeroBoots = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 3).func_77655_b("zss.hero_tunic_boots");
        bootsHeavy = new ItemArmorBoots(ItemArmor.ArmorMaterial.IRON, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_heavy");
        bootsHover = new ItemArmorBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_hover");
        bootsPegasus = new ItemArmorBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_pegasus");
        bootsRubber = new ItemArmorBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_rubber");
        shieldDeku = new ItemZeldaShield(30, 3.0f, 5.0f).func_77655_b("zss.shield_deku");
        shieldHylian = new ItemZeldaShield(18, 5.0f, 3.5f).func_77655_b("zss.shield_hylian");
        shieldMirror = new ItemZeldaShield(24, 4.0f, 4.0f).func_77655_b("zss.shield_mirror");
        swordKokiri = new ItemZeldaSword(Item.ToolMaterial.IRON, -1.0f).func_77655_b("zss.sword_kokiri").func_77656_e(256);
        swordOrdon = new ItemZeldaSword(Item.ToolMaterial.IRON, 1.0f).func_77655_b("zss.sword_ordon").func_77656_e(512);
        swordGiant = new ItemZeldaSword(Item.ToolMaterial.IRON, 6.0f, true).func_77655_b("zss.sword_giant").func_77656_e(32);
        swordBiggoron = new ItemZeldaSword(Item.ToolMaterial.IRON, 6.0f, true).setNoItemOnBreak().func_77655_b("zss.sword_biggoron").func_77656_e(0);
        swordMaster = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 2.0f).setMasterSword().func_77655_b("zss.sword_master").func_77656_e(0);
        swordTempered = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 4.0f).setMasterSword().func_77655_b("zss.sword_tempered").func_77656_e(0);
        swordGolden = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 6.0f).setMasterSword().func_77655_b("zss.sword_golden").func_77656_e(0);
        swordMasterTrue = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 8.0f).setMasterSword().func_77655_b("zss.sword_master_true").func_77656_e(0);
        swordBroken = new ItemBrokenSword().func_77655_b("zss.sword_broken");
        hammer = new ItemHammer(BlockWeight.VERY_LIGHT, 8.0f, 50.0f).func_77655_b("zss.hammer");
        hammerSkull = new ItemHammer(BlockWeight.MEDIUM, 12.0f, 50.0f).func_77655_b("zss.hammer_skull");
        hammerMegaton = new ItemHammer(BlockWeight.VERY_HEAVY, 16.0f, 50.0f).func_77655_b("zss.hammer_megaton");
        boomerang = new ItemBoomerang(4.0f, 12).func_77655_b("zss.boomerang");
        boomerangMagic = new ItemBoomerang(6.0f, 24).setCaptureAll().func_77655_b("zss.boomerang_magic");
        heroBow = new ItemHeroBow().func_77655_b("zss.bow_hero");
        arrowBomb = new ItemZeldaArrow("arrow_bomb", false);
        arrowBombFire = new ItemZeldaArrow("arrow_bomb_fire", false);
        arrowBombWater = new ItemZeldaArrow("arrow_bomb_water", false);
        arrowFire = new ItemZeldaArrow("arrow_fire", true);
        arrowIce = new ItemZeldaArrow("arrow_ice", true);
        arrowLight = new ItemZeldaArrow("arrow_light", true);
        slingshot = new ItemSlingshot().func_77655_b("zss.slingshot");
        scattershot = new ItemSlingshot(3, 30.0f).func_77655_b("zss.scattershot");
        supershot = new ItemSlingshot(5, 15.0f).func_77655_b("zss.supershot");
        doorLocked = new ItemDoorLocked().func_77655_b("zss.doorlocked");
        keyBig = new ItemKeyBig().func_77655_b("zss.keybig").func_77664_n();
        keySmall = new ItemMiscZSS(6).func_77655_b("zss.keysmall").func_77664_n().func_77637_a(ZSSCreativeTabs.tabKeys);
        keySkeleton = new ItemMiscZSS(32).func_77655_b("zss.keyskeleton").func_77664_n().func_77625_d(1).func_77637_a(ZSSCreativeTabs.tabKeys);
        hookshot = new ItemHookShot().func_77655_b("zss.hookshot");
        hookshotAddon = new ItemHookShotUpgrade().func_77655_b("zss.hookshot.upgrade");
        bombBag = new ItemBombBag().func_77655_b("zss.bombbag");
        bomb = new ItemBomb().func_77655_b("zss.bomb");
        crystalDin = new ItemSpiritCrystal(1, 8, 16).func_77655_b("zss.spirit_crystal_din");
        crystalFarore = new ItemSpiritCrystal(2, 8, 70).func_77655_b("zss.spirit_crystal_farore");
        crystalNayru = new ItemSpiritCrystal(4, 16, 0).func_77655_b("zss.spirit_crystal_nayru");
        gauntletsSilver = new ItemPowerGauntlets(BlockWeight.MEDIUM).func_77655_b("zss.gauntlets_silver");
        gauntletsGolden = new ItemPowerGauntlets(BlockWeight.VERY_HEAVY).func_77655_b("zss.gauntlets_golden");
        magicMirror = new ItemMagicMirror().func_77655_b("zss.magicmirror");
        fairyBottle = new ItemFairyBottle().func_77655_b("zss.fairybottle");
        potionRed = new ItemZeldaPotion(0, 0.0f, 20.0f).func_77655_b("zss.potion_red");
        potionGreen = new ItemZeldaPotion(20, 40.0f, 0.0f).func_77655_b("zss.potion_green");
        potionBlue = new ItemZeldaPotion(20, 40.0f, 40.0f).func_77655_b("zss.potion_blue");
        potionYellow = new ItemZeldaPotion().setBuffEffect(Buff.RESIST_SHOCK, 6000, 100, 1.0f).func_77655_b("zss.potion_yellow");
        rodFire = new ItemMagicRod(EntityMagicSpell.MagicType.FIRE, 8.0f, 8.0f).func_77655_b("zss.rod_fire");
        rodIce = new ItemMagicRod(EntityMagicSpell.MagicType.ICE, 6.0f, 8.0f).func_77655_b("zss.rod_ice");
        rodTornado = new ItemMagicRod(EntityMagicSpell.MagicType.WIND, 4.0f, 4.0f).func_77655_b("zss.rod_tornado");
        maskBlast = new ItemMask(ItemArmor.ArmorMaterial.IRON, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_blast");
        maskBunny = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(1, 64).func_77655_b("zss.mask_bunny");
        maskCouples = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(40, 32).func_77655_b("zss.mask_couples");
        maskGerudo = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_gerudo");
        maskGiants = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_giants");
        maskGibdo = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_gibdo");
        maskHawkeye = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_hawkeye");
        maskKeaton = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(8, 16).func_77655_b("zss.mask_keaton");
        maskScents = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(32, 32).func_77655_b("zss.mask_scents");
        maskSkull = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(20, 10).func_77655_b("zss.mask_skull");
        maskSpooky = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(16, 8).func_77655_b("zss.mask_spooky");
        maskStone = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setEffect(new PotionEffect(Potion.field_76441_p.func_76396_c(), 100, 0)).func_77655_b("zss.mask_stone");
        maskTruth = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_truth");
        maskDeku = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_deku");
        maskGoron = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_goron");
        maskZora = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_zora");
        maskFierce = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_fierce");
        maskMajora = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setEffect(new PotionEffect(Potion.field_82731_v.func_76396_c(), 100, 1)).func_77655_b("zss.mask_majora");
        pendant = new ItemPendant().func_77655_b("zss.pendant");
        crystalSpirit = new ItemMiscZSS(0).func_77655_b("zss.spirit_crystal_empty").func_77625_d(1).func_77637_a(ZSSCreativeTabs.tabTools);
        masterOre = new ItemMiscZSS(24).func_77655_b("zss.masterore");
        rocsFeather = new ItemMiscZSS(12).func_77655_b("zss.rocs_feather").func_77637_a(ZSSCreativeTabs.tabTools);
        dekuLeaf = new ItemDekuLeaf().func_77655_b("zss.deku_leaf");
        dekuNut = new ItemMiscZSS(2).func_77655_b("zss.deku_nut").func_77637_a(ZSSCreativeTabs.tabTools);
        jellyChu = new ItemChuJelly().func_77655_b("zss.jelly_chu");
        treasure = new ItemTreasure().func_77655_b("zss.treasure");
        heldBlock = new ItemHeldBlock().func_77655_b("zss.held_block");
        powerPiece = new ItemPickupOnly().func_77655_b("zss.power_piece");
        smallHeart = new ItemPickupOnly().func_77655_b("zss.heart");
        throwingRock = new Item().func_77655_b("zss.throwing_rock").func_111206_d("zeldaswordskills:throwing_rock").func_77625_d(16);
        eggSpawner = new ItemCustomEgg().func_77655_b("zss.spawn_egg");
        eggChu = new ItemCustomVariantEgg(EntityChu.class, "chu").func_77655_b("zss.eggChu");
        eggKeese = new ItemCustomVariantEgg(EntityKeese.class, "keese").func_77655_b("zss.eggKeese");
        eggOctorok = new ItemCustomVariantEgg(EntityOctorok.class, "octorok").func_77655_b("zss.eggOctorok");
    }

    public static void registerItemBlock(Item block) {
        if (block instanceof ItemBlock) {
            itemList.put(block, sortId++);
        } else {
            LogHelper.warning("Tried to register a non-ItemBlock item for " + block.func_77658_a());
        }
    }

    private static void registerItems() {
        try {
            for (Field f : ZSSItems.class.getFields()) {
                Item item;
                if (!Item.class.isAssignableFrom(f.getType()) || (item = (Item)f.get(null)) == null) continue;
                itemList.put(item, sortId++);
                GameRegistry.registerItem((Item)item, (String)item.func_77658_a().replace("item.", "").trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerRecipes() {
        if (allowGoldSmelting) {
            FurnaceRecipes.func_77602_a().func_151396_a(Items.field_151010_B, new ItemStack(Items.field_151043_k), 0.0f);
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.pedestal, 3, 8), (Object[])new Object[]{"qqq", "qpq", "qqq", Character.valueOf('q'), Blocks.field_150371_ca, Character.valueOf('p'), new ItemStack(ZSSBlocks.pedestal, 1, 8)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(arrowBomb), (Object[])new Object[]{"b", "a", Character.valueOf('b'), new ItemStack(bomb, 1, BombType.BOMB_STANDARD.ordinal()), Character.valueOf('a'), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(arrowBombFire), (Object[])new Object[]{"b", "a", Character.valueOf('b'), new ItemStack(bomb, 1, BombType.BOMB_FIRE.ordinal()), Character.valueOf('a'), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(arrowBombWater), (Object[])new Object[]{"b", "a", Character.valueOf('b'), new ItemStack(bomb, 1, BombType.BOMB_WATER.ordinal()), Character.valueOf('a'), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.ceramicJar, 8), (Object[])new Object[]{"c c", "c c", " c ", Character.valueOf('c'), Items.field_151118_aC});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skillOrb, 1, (int)SkillBase.bonusHeart.getId()), (Object[])new Object[]{"HH", "HH", Character.valueOf('H'), heartPiece});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicGoronHelm), (Object[])new Object[]{tunicHeroHelm, new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicGoronLegs), (Object[])new Object[]{tunicHeroLegs, new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicZoraHelm), (Object[])new Object[]{tunicHeroHelm, new ItemStack(Items.field_151100_aR, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicZoraLegs), (Object[])new Object[]{tunicHeroLegs, new ItemStack(Items.field_151100_aR, 1, 4)});
    }

    private static void addVanillaDungeonLoot() {
        if (enableBombLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(bomb, 1, BombType.BOMB_STANDARD.ordinal()), 1, 3, Config.getBombWeight()), true, true);
        }
        if (enableBombBagLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(bombBag), 1, 1, Config.getBombBagWeight()), true, false);
        }
        if (enableHeartLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillOrb, 1, (int)SkillBase.bonusHeart.getId()), 1, 1, Config.getHeartWeight()), false, false);
        }
    }

    private static void addLootToAll(WeightedRandomChestContent loot, boolean smith, boolean bonus) {
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(loot);
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(loot);
        if (smith) {
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(loot);
        }
        if (bonus) {
            ChestGenHooks.getInfo((String)"bonusChest").addItem(loot);
        }
    }

    private static void addDispenserBehaviors() {
        BlockDispenser.field_149943_a.func_82595_a((Object)eggSpawner, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggChu, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggKeese, (Object)new BehaviorDispenseCustomMobEgg());
        BlockDispenser.field_149943_a.func_82595_a((Object)eggOctorok, (Object)new BehaviorDispenseCustomMobEgg());
    }

    static {
        grassDrops = new ArrayList<ItemStack>();
        WOOD = EnumHelper.addArmorMaterial((String)"Wood", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)5);
    }
}

