/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.lib;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import zeldaswordskills.entity.ZSSEntities;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.BossType;

public class Config {
    public static Configuration config;
    private static boolean enableOffhandMaster;
    private static boolean enableStunPlayer;
    private static boolean enableSwingSpeed;
    private static int baseSwingSpeed;
    private static boolean enableHardcoreZeldaFanMode;
    private static boolean enableVanillaLift;
    private static boolean enableVanillaSmash;
    private static boolean alwaysPickupHearts;
    private static int bossHealthFactor;
    private static int bossNumber;
    private static boolean allowJarsInWater;
    private static int jarGenChance;
    private static int jarsPerCluster;
    private static int jarGenChanceSub;
    private static int jarsPerClusterSub;
    private static int jarClustersPerChunkSub;
    private static int jarGenChanceNether;
    private static int jarsPerClusterNether;
    private static int jarClustersPerChunkNether;
    private static int keeseSwarmChance;
    private static int keeseSwarmSize;
    private static int sacredRefreshRate;
    private static boolean showSecretMessage;
    private static boolean disableVanillaBuffs;
    private static boolean isBuffBarEnabled;
    private static boolean isBuffBarHorizontal;
    private static boolean isBuffBarLeft;
    private static boolean arrowsConsumeFlame;
    private static int bombFuseTime;
    private static boolean onlyBombSecretStone;
    private static boolean bombsGriefAdventure;
    private static boolean enableDekuDenude;
    private static boolean enableDinIgnite;
    private static boolean enableDinMelt;
    private static boolean disableAllUnenchantables;
    private static int heroBowUpgradeCost;
    private static boolean enableFireArrowIgnite;
    private static boolean enableFireArrowMelt;
    private static boolean enableLightArrowNoClip;
    private static boolean enableAutoBombArrows;
    private static int hookshotRange;
    private static boolean enableHookshotBreakBlocks;
    private static boolean enableHookshotSound;
    private static int rodUpgradeCost;
    private static int temperedRequiredKills;
    private static int slingshotUpgradeOne;
    private static int slingshotUpgradeTwo;
    private static boolean allowVanillaControls;
    private static boolean doubleTap;
    private static int maxBonusHearts;
    private static boolean autoTarget;
    private static boolean enablePlayerTarget;
    private static int hitsToDisplay;
    private static int disarmTimingBonus;
    private static int disarmPenalty;
    private static boolean requireFullHealth;
    private static boolean avoidModBlocks;
    private static boolean enableWindows;
    private static boolean enableBossDungeons;
    private static int minBossDistance;
    private static int minBossDistanceNether;
    private static int minLandDistance;
    private static int minDistanceNether;
    private static int minOceanDistance;
    private static int genAttemptsPerChunk;
    private static int secretRoomChance;
    private static int mainDungeonDifficulty;
    private static int genAttemptsPerChunkNether;
    private static int secretRoomChanceNether;
    private static int netherDungeonDifficulty;
    private static int fairySpawnerChance;
    private static int resetSpawnerTime;
    private static int lockedChestChance;
    private static int doubleChestChance;
    private static int barredRoomChance;
    private static int heartPieceChance;
    private static int randomBossItemChance;
    private static int minNumChestItems;
    private static int bombWeight;
    private static int bombBagWeight;
    private static int heartPieceWeight;
    private static int bigKeyWeight;
    private static int smallKeyWeight;
    private static int lockedLootWeight;
    private static int grassDropChance;
    private static int jarDropChance;
    private static int creeperDrop;
    private static boolean enableOrbDrops;
    private static int randomDropChance;
    private static int genericMobDropChance;
    private static Map<Byte, Integer> orbDropChance;
    private static int powerDropRate;
    private static boolean enableTradeBombBag;
    private static int minBombBagPrice;
    private static boolean enableTradeBomb;
    private static boolean enableArrowTrades;
    private static int maskBuyChance;
    private static int friendTradesRequired;

    public static void init(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/zeldaswordskills.cfg"));
        config.load();
        ZSSEntities.init(config);
        ZSSItems.init(config);
        enableOffhandMaster = config.get("Mod Support", "[BattleGear2] Allow Master Swords to be held in the off-hand", false).getBoolean(false);
        enableStunPlayer = config.get("General", "Whether players can be stunned; if false, item use is still interrupted", false).getBoolean(false);
        enableSwingSpeed = config.get("General", "Whether the swing speed timer prevents all left-clicks, or only items that use swing speeds", true).getBoolean(true);
        baseSwingSpeed = config.get("General", "Default swing speed (anti-left-click-spam): Sets base number of ticks between each left-click (0 to disable)[0-20]", 0).getInt();
        enableVanillaLift = config.get("General", "Whether vanilla blocks can be picked up using appropriate items (e.g. gauntlets)", true).getBoolean(true);
        enableVanillaSmash = config.get("General", "Whether vanilla blocks can be smashed using appropriate items (e.g. hammers)", true).getBoolean(true);
        alwaysPickupHearts = config.get("General", "Always pick up small hearts regardless of health", false).getBoolean(false);
        enableHardcoreZeldaFanMode = config.get("General", "Hardcore Zelda Fan: Start with only 3 hearts (applies a -14 max health modifier, so it can be enabled or disabled at any time)", false).getBoolean(false);
        bossHealthFactor = config.get("General", "[Boss] Boss health multiplier, as a percent increase per difficulty level (will not apply to real bosses) [100-500]", 250).getInt();
        bossNumber = config.get("General", "[Boss] Number of boss mobs to spawn in Boss Dungeons (will not apply to real bosses) [1-8]", 4).getInt();
        allowJarsInWater = config.get("General", "[Ceramic Jars][Surface] Allow ceramic jars to generate in water", true).getBoolean(true);
        jarGenChance = config.get("General", "[Ceramic Jars][Surface] Chance of generating a jar cluster in a given chunk [0-100]", 50).getInt();
        jarsPerCluster = config.get("General", "[Ceramic Jars][Surface] Max number of jars per jar cluster [2-20]", 8).getInt();
        jarGenChanceSub = config.get("General", "[Ceramic Jars][Underground] Chance for each jar cluster to generate [0-100]", 65).getInt();
        jarsPerClusterSub = config.get("General", "[Ceramic Jars][Underground] Max number of jars per cluster [2-20]", 8).getInt();
        jarClustersPerChunkSub = config.get("General", "[Ceramic Jars][Underground] Max number of jar clusters per chunk [1-20]", 10).getInt();
        jarGenChanceNether = config.get("General", "[Ceramic Jars][Nether] Chance for each jar cluster to generate [0-100]", 50).getInt();
        jarsPerClusterNether = config.get("General", "[Ceramic Jars][Nether] Max number of jars per cluster [2-20]", 8).getInt();
        jarClustersPerChunkNether = config.get("General", "[Ceramic Jars][Nether] Max number of jar clusters per chunk [1-20]", 8).getInt();
        keeseSwarmChance = config.get("General", "[Mobs][Keese] Chance of Keese spawning in a swarm (0 to disable)[0-100]", 25).getInt();
        keeseSwarmSize = config.get("General", "[Mobs][Keese] Maximum number of Keese that can spawn in a swarm [4-16]", 6).getInt();
        sacredRefreshRate = config.get("General", "[Sacred Flames] Number of days before flame rekindles itself (0 to disable) [0-30]", 7).getInt();
        showSecretMessage = config.get("General", "Whether to show a chat message when striking secret blocks", false).getBoolean(false);
        disableVanillaBuffs = config.get("General", "[Mob Buff] Disable all buffs (resistances and weaknesses) for vanilla mobs", false).getBoolean(false);
        isBuffBarEnabled = config.get("General", "[Buff HUD] Whether the buff bar should be displayed at all times", true).getBoolean(true);
        isBuffBarHorizontal = config.get("General", "[Buff HUD] Whether the buff bar should be displayed horizontally", true).getBoolean(true);
        isBuffBarLeft = config.get("General", "[Buff HUD] Whether the buff bar should be displayed on the left side of the screen", false).getBoolean(false);
        arrowsConsumeFlame = config.get("Item", "[Arrows] Whether transforming arrows with the Sacred Flames has a chance to consume the flame", true).getBoolean(true);
        bombFuseTime = config.get("Item", "[Bombs] Minimum fuse time; set to 0 to disable held bomb ticks [0-128]", 56).getInt();
        onlyBombSecretStone = config.get("Item", "[Bombs] Whether bombs are non-griefing, i.e. can only destroy secret stone", false).getBoolean(false);
        enableDekuDenude = config.get("Item", "[Deku Leaf] Allow Deku Leaf whirlwind to destroy leaves", true).getBoolean(true);
        enableDinIgnite = config.get("Item", "[Din's Fire] Whether Din's Fire can set blocks on fire", false).getBoolean(false);
        enableDinMelt = config.get("Item", "[Din's Fire] Whether Din's Fire can melt unbreakable ice blocks", true).getBoolean(true);
        disableAllUnenchantables = config.get("Item", "[Enchantments] Disable the vanilla behavior allowing unenchantable items to be enchanted using the anvil", false).getBoolean(false);
        heroBowUpgradeCost = config.get("Item", "[Hero's Bow] Cost (in emeralds) to upgrade, per level [128 - 640]", 192).getInt();
        enableFireArrowIgnite = config.get("Item", "[Hero's Bow] Whether the fire arrow can ignite affected blocks", true).getBoolean(true);
        enableFireArrowMelt = config.get("Item", "[Hero's Bow] Whether the fire arrow can melt unbreakable ice blocks", true).getBoolean(true);
        enableLightArrowNoClip = config.get("Item", "[Hero's Bow] Whether the light arrow can penetrate blocks", true).getBoolean(true);
        enableAutoBombArrows = config.get("Item", "[Hero's Bow] Whether to automate bomb arrow firing when sneaking", true).getBoolean(true);
        hookshotRange = config.get("Item", "[Hookshot] Max range of non-extended hookshots [4-16]", 8).getInt();
        enableHookshotBreakBlocks = config.get("Item", "[Hookshot] Whether hookshots are allowed to destroy certain blocks such as glass", true).getBoolean(true);
        enableHookshotSound = config.get("Item", "[Hookshot] Whether to play the 'itembreak' sound when the hookshot misses", true).getBoolean(true);
        rodUpgradeCost = config.get("Item", "[Magic Rods] Cost (in emeralds) to upgrade (note that the Tornado Rod costs 3/4 this value) [128-1280]", 768).getInt();
        temperedRequiredKills = config.get("Item", "[Master Sword] Number of mobs that need to be killed to upgrade the Tempered Sword [100-1000]", 300).getInt();
        slingshotUpgradeOne = config.get("Item", "[Slingshot] Cost (in emeralds) for first upgrade [64- 320]", 128).getInt();
        slingshotUpgradeTwo = config.get("Item", "[Slingshot] Cost (in emeralds) for second upgrade [128 - 640]", 320).getInt();
        allowVanillaControls = config.get("Skills", "Allow vanilla controls to activate skills", true).getBoolean(true);
        autoTarget = config.get("Skills", "Enable auto-targeting of next opponent", true).getBoolean(true);
        enablePlayerTarget = config.get("Skills", "Enable targeting of players by default (can be toggled in game)", true).getBoolean(true);
        doubleTap = config.get("Skills", "Require double tap activation (double-tap always required for vanilla movement keys)", true).getBoolean(true);
        maxBonusHearts = config.get("Skills", "Max Bonus Hearts [0-50]", 20).getInt();
        hitsToDisplay = config.get("Skills", "Max hits to display in Combo HUD [0-12]", 3).getInt();
        disarmTimingBonus = config.get("Skills", "[Parry] Bonus to disarm based on timing: tenths of a percent added per tick remaining on the timer [0-50]", 25).getInt();
        disarmPenalty = config.get("Skills", "[Parry] Penalty to disarm chance: percent per Parry level of the opponent, default negates defender's skill bonus so disarm is based entirely on timing [0-20]", 10).getInt();
        requireFullHealth = config.get("Skills", "[Super Spin Attack | Sword Beam] True to require a completely full health bar to use, or false to allow a small amount to be missing per level", false).getBoolean(false);
        avoidModBlocks = config.get("Dungeon Generation", "Whether to prevent ZSS structures from generating if any non-vanilla blocks are detected", true).getBoolean(true);
        enableWindows = config.get("Dungeon Generation", "Whether boss dungeons are allowed to have windows or not", true).getBoolean(true);
        enableBossDungeons = config.get("Dungeon Generation", "Enable Boss Dungeon generation", true).getBoolean(true);
        mainDungeonDifficulty = config.get("Dungeon Generation", "[Overworld] Adjust secret rooms so they are more hidden [1 = less, 3 = most]", 2).getInt();
        secretRoomChance = config.get("Dungeon Generation", "[Overworld] Chance (as a percent) per iteration of secret room generating [1-100]", 80).getInt();
        minLandDistance = config.get("Dungeon Generation", "[Overworld] Minimum number of blocks between land-based secret rooms [2-16]", 6).getInt();
        minOceanDistance = config.get("Dungeon Generation", "[Overworld] Minimum number of blocks between ocean-based secret rooms [2-32]", 6).getInt();
        minBossDistance = config.get("Dungeon Generation", "[Overworld] Minimum number of chunks between Boss Dungeons [8-128]", 24).getInt();
        genAttemptsPerChunk = config.get("Dungeon Generation", "[Overworld] Secret room generation attempts per chunk (0 to disable) [0-20]", 12).getInt();
        netherDungeonDifficulty = config.get("Dungeon Generation", "[Nether] Adjust secret rooms so they are more hidden [1 = less, 3 = most]", 2).getInt();
        secretRoomChanceNether = config.get("Dungeon Generation", "[Nether] Chance (as a percent) per iteration of secret room generating [1-100]", 80).getInt();
        minDistanceNether = config.get("Dungeon Generation", "[Nether] Minimum number of blocks between land-based secret rooms [2-16]", 6).getInt();
        minBossDistanceNether = config.get("Dungeon Generation", "[Nether] Minimum number of chunks between Boss Dungeons [8-64]", 12).getInt();
        genAttemptsPerChunkNether = config.get("Dungeon Generation", "[Nether] Secret room generation attempts per chunk (0 to disable) [0-20]", 12).getInt();
        fairySpawnerChance = config.get("Dungeon Generation", "Chance (as a percent) for certain dungeons to have fairy spawners [0-100]", 10).getInt();
        resetSpawnerTime = config.get("Dungeon Generation", "Maximum number of days required for fairies to replenish [2-10]", 7).getInt();
        lockedChestChance = config.get("Loot", "Chance (as a percent) a chest will be locked [10-50]", 33).getInt();
        doubleChestChance = config.get("Loot", "Chance (as a percent) a secret room may have two chests [0-25]", 10).getInt();
        barredRoomChance = config.get("Loot", "Chance that a secret room's entrance will be barred by some obstacle [1-50]", 25).getInt();
        heartPieceChance = config.get("Loot", "Chance (as a percent) of a heart piece generating in secret room chests [0-100]", 60).getInt();
        randomBossItemChance = config.get("Loot", "Chance (as a percent) of a random boss-level item being added to locked chest loot table [0-50]", 25).getInt();
        minNumChestItems = config.get("Loot", "Minimum number of random chest contents for first chest [1-10]", 4).getInt();
        bombWeight = config.get("Loot", "Weight: Bomb [1-10]", 5).getInt();
        bombBagWeight = config.get("Loot", "Weight: Bomb Bag (locked chest weight only) [1-10]", 3).getInt();
        heartPieceWeight = config.get("Loot", "Weight: Heart Piece (vanilla chests only) [1-10]", 1).getInt();
        bigKeyWeight = config.get("Loot", "Weight: Key, Big [1-10]", 3).getInt();
        smallKeyWeight = config.get("Loot", "Weight: Key, Small [1-10]", 4).getInt();
        lockedLootWeight = config.get("Loot", "Weight: Locked Chest Content [1-10]", 3).getInt();
        grassDropChance = config.get("Drops", "Chance (as a percent) of loot dropping from grass [0-100]", 15).getInt();
        jarDropChance = config.get("Drops", "Chance (as a percent) of loot dropping from empty jars when broken [0-100]", 20).getInt();
        creeperDrop = config.get("Drops", "Chance (as a percent) for creepers to drop bombs [0-100]", 10).getInt();
        enableOrbDrops = config.get("Drops", "[Skill Orbs] Enable skill orbs to drop as loot from mobs", true).getBoolean(true);
        randomDropChance = config.get("Drops", "[Skill Orbs] Chance (as a percent) for specified mobs to drop a random orb [0-100]", 10).getInt();
        genericMobDropChance = config.get("Drops", "[Skill Orbs] Chance (as a percent) for random mobs to drop a random orb [0-100]", 1).getInt();
        orbDropChance = new HashMap<Byte, Integer>(SkillBase.getNumSkills());
        for (SkillBase skill : SkillBase.getSkills()) {
            if (!skill.canDrop()) continue;
            orbDropChance.put(skill.getId(), config.get("Drops", "[Skill Orbs] Chance (in tenths of a percent) for " + skill.getDisplayName() + " [0-10]", 5).getInt());
        }
        powerDropRate = config.get("Drops", "[Piece of Power] Approximate number of enemies you need to kill before a piece of power drops [minimum 20]", 50).getInt();
        friendTradesRequired = config.get("Trade", "Number of unlocked trades required before a villager considers you 'friend' [3+]", 6).getInt();
        enableTradeBombBag = config.get("Trade", "[Bomb Bag] Enable random villager trades for bomb bags", true).getBoolean(true);
        minBombBagPrice = config.get("Trade", "[Bomb Bag] Minimum price (in emeralds) [32-64]", 64).getInt();
        enableTradeBomb = config.get("Trade", "[Bombs] Enable random villager trades for bombs", true).getBoolean(true);
        enableArrowTrades = config.get("Trade", "[Hero's Bow] Whether magic arrows (fire, ice, light) can be purchased", true).getBoolean(true);
        maskBuyChance = config.get("Trade", "[Masks] Chance that a villager will be interested in purchasing a random mask [1-15]", 5).getInt();
    }

    public static void postInit() {
        for (BossType type : BossType.values()) {
            BossType.addBiomes(type, config.get("Dungeon Generation", String.format("[Boss Dungeon] List of biomes in which %ss can generate", type.getDisplayName()), type.getDefaultBiomes()).getStringList());
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean allowOffhandMaster() {
        return enableOffhandMaster;
    }

    public static boolean canPlayersBeStunned() {
        return enableStunPlayer;
    }

    public static boolean affectAllSwings() {
        return enableSwingSpeed;
    }

    public static int getBaseSwingSpeed() {
        return MathHelper.func_76125_a((int)baseSwingSpeed, (int)0, (int)20);
    }

    public static boolean canLiftVanilla() {
        return enableVanillaLift;
    }

    public static boolean canSmashVanilla() {
        return enableVanillaSmash;
    }

    public static boolean alwaysPickupHearts() {
        return alwaysPickupHearts;
    }

    public static boolean isHardcoreZeldaFan() {
        return enableHardcoreZeldaFanMode;
    }

    public static float getBossHealthFactor() {
        return MathHelper.func_76131_a((float)((float)bossHealthFactor * 0.01f), (float)1.0f, (float)5.0f);
    }

    public static int getNumBosses() {
        return MathHelper.func_76125_a((int)bossNumber, (int)1, (int)8);
    }

    public static boolean genJarsInWater() {
        return allowJarsInWater;
    }

    public static float getJarGenChance() {
        return MathHelper.func_76131_a((float)((float)jarGenChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static int getJarsPerCluster() {
        return MathHelper.func_76125_a((int)jarsPerCluster, (int)2, (int)20);
    }

    public static float getJarGenChanceSub() {
        return MathHelper.func_76131_a((float)((float)jarGenChanceSub * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static int getJarClustersPerChunkSub() {
        return MathHelper.func_76125_a((int)jarClustersPerChunkSub, (int)1, (int)20);
    }

    public static int getJarsPerClusterSub() {
        return MathHelper.func_76125_a((int)jarsPerClusterSub, (int)2, (int)20);
    }

    public static float getJarGenChanceNether() {
        return MathHelper.func_76131_a((float)((float)jarGenChanceNether * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static int getJarClustersPerChunkNether() {
        return MathHelper.func_76125_a((int)jarClustersPerChunkNether, (int)1, (int)20);
    }

    public static int getJarsPerClusterNether() {
        return MathHelper.func_76125_a((int)jarsPerClusterNether, (int)2, (int)20);
    }

    public static int getSacredFlameRefreshRate() {
        return MathHelper.func_76125_a((int)sacredRefreshRate, (int)0, (int)30);
    }

    public static boolean showSecretMessage() {
        return showSecretMessage;
    }

    public static boolean areVanillaBuffsDisabled() {
        return disableVanillaBuffs;
    }

    public static float getKeeseSwarmChance() {
        return (float)MathHelper.func_76125_a((int)keeseSwarmChance, (int)0, (int)100) * 0.01f;
    }

    public static int getKeeseSwarmSize() {
        return MathHelper.func_76125_a((int)keeseSwarmSize, (int)4, (int)16);
    }

    public static boolean isBuffBarEnabled() {
        return isBuffBarEnabled;
    }

    public static boolean isBuffBarHorizontal() {
        return isBuffBarHorizontal;
    }

    public static boolean isBuffBarLeft() {
        return isBuffBarLeft;
    }

    public static boolean getArrowsConsumeFlame() {
        return arrowsConsumeFlame;
    }

    public static boolean onlyBombSecretStone() {
        return onlyBombSecretStone;
    }

    public static boolean canGriefAdventure() {
        return bombsGriefAdventure;
    }

    public static int getBombFuseTime() {
        return MathHelper.func_76125_a((int)bombFuseTime, (int)0, (int)128);
    }

    public static boolean canDekuDenude() {
        return enableDekuDenude;
    }

    public static boolean isDinIgniteEnabled() {
        return enableDinIgnite;
    }

    public static boolean isDinMeltEnabled() {
        return enableDinMelt;
    }

    public static boolean allUnenchantablesAreDisabled() {
        return disableAllUnenchantables;
    }

    public static int getHeroBowUpgradeCost() {
        return MathHelper.func_76125_a((int)heroBowUpgradeCost, (int)128, (int)640);
    }

    public static boolean enableFireArrowIgnite() {
        return enableFireArrowIgnite;
    }

    public static boolean enableFireArrowMelt() {
        return enableFireArrowMelt;
    }

    public static boolean enableLightArrowNoClip() {
        return enableLightArrowNoClip;
    }

    public static boolean enableAutoBombArrows() {
        return enableAutoBombArrows;
    }

    public static int getHookshotRange() {
        return MathHelper.func_76125_a((int)hookshotRange, (int)4, (int)16);
    }

    public static boolean canHookshotBreakBlocks() {
        return enableHookshotBreakBlocks;
    }

    public static boolean enableHookshotMissSound() {
        return enableHookshotSound;
    }

    public static int getRodUpgradeCost() {
        return MathHelper.func_76125_a((int)rodUpgradeCost, (int)128, (int)1280);
    }

    public static int getRequiredKills() {
        return MathHelper.func_76125_a((int)temperedRequiredKills, (int)100, (int)1000) - 1;
    }

    public static int getSlingshotCostOne() {
        return MathHelper.func_76125_a((int)slingshotUpgradeOne, (int)64, (int)320);
    }

    public static int getSlingshotCostTwo() {
        return MathHelper.func_76125_a((int)slingshotUpgradeTwo, (int)128, (int)640);
    }

    public static boolean allowVanillaControls() {
        return allowVanillaControls;
    }

    public static boolean requiresDoubleTap() {
        return doubleTap;
    }

    public static byte getMaxBonusHearts() {
        return (byte)MathHelper.func_76125_a((int)maxBonusHearts, (int)0, (int)50);
    }

    public static boolean autoTargetEnabled() {
        return autoTarget;
    }

    public static boolean toggleAutoTarget() {
        autoTarget = !autoTarget;
        return autoTarget;
    }

    public static boolean canTargetPlayers() {
        return enablePlayerTarget;
    }

    public static boolean toggleTargetPlayers() {
        enablePlayerTarget = !enablePlayerTarget;
        return enablePlayerTarget;
    }

    public static int getHitsToDisplay() {
        return Math.max(hitsToDisplay, 0);
    }

    public static float getDisarmPenalty() {
        return 0.01f * (float)MathHelper.func_76125_a((int)disarmPenalty, (int)0, (int)20);
    }

    public static float getDisarmTimingBonus() {
        return 0.001f * (float)MathHelper.func_76125_a((int)disarmTimingBonus, (int)0, (int)50);
    }

    public static float getHealthAllowance(int level) {
        return requireFullHealth ? 0.0f : 0.6f * (float)level;
    }

    public static boolean avoidModBlocks() {
        return avoidModBlocks;
    }

    public static boolean areWindowsEnabled() {
        return enableWindows;
    }

    public static boolean areBossDungeonsEnabled() {
        return enableBossDungeons;
    }

    public static int getMinBossDistance() {
        return MathHelper.func_76125_a((int)minBossDistance, (int)8, (int)128);
    }

    public static int getMinLandDistance() {
        return MathHelper.func_76125_a((int)minLandDistance, (int)2, (int)16);
    }

    public static int getMinOceanDistance() {
        return MathHelper.func_76125_a((int)minOceanDistance, (int)2, (int)32);
    }

    public static int getAttemptsPerChunk() {
        return Math.min(genAttemptsPerChunk, 20);
    }

    public static float getSecretRoomChance() {
        return MathHelper.func_76131_a((float)((float)secretRoomChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static int getMainDungeonDifficulty() {
        return MathHelper.func_76125_a((int)mainDungeonDifficulty, (int)1, (int)3);
    }

    public static int getNetherMinBossDistance() {
        return MathHelper.func_76125_a((int)minBossDistanceNether, (int)8, (int)64);
    }

    public static int getNetherMinDistance() {
        return MathHelper.func_76125_a((int)minDistanceNether, (int)2, (int)16);
    }

    public static int getNetherAttemptsPerChunk() {
        return Math.min(genAttemptsPerChunkNether, 20);
    }

    public static float getNetherSecretRoomChance() {
        return MathHelper.func_76131_a((float)((float)secretRoomChanceNether * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static int getNetherDungeonDifficulty() {
        return MathHelper.func_76125_a((int)netherDungeonDifficulty, (int)1, (int)3);
    }

    public static float getFairySpawnerChance() {
        return MathHelper.func_76131_a((float)((float)fairySpawnerChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static int getDaysToRespawn() {
        return MathHelper.func_76125_a((int)resetSpawnerTime, (int)2, (int)10);
    }

    public static float getLockedChestChance() {
        return MathHelper.func_76131_a((float)((float)lockedChestChance * 0.01f), (float)0.1f, (float)0.5f);
    }

    public static float getDoubleChestChance() {
        return MathHelper.func_76131_a((float)((float)doubleChestChance * 0.01f), (float)0.0f, (float)0.25f);
    }

    public static float getBarredRoomChance() {
        return MathHelper.func_76131_a((float)((float)barredRoomChance * 0.01f), (float)0.01f, (float)0.5f);
    }

    public static float getHeartPieceChance() {
        return MathHelper.func_76131_a((float)((float)heartPieceChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static float getRandomBossItemChance() {
        return MathHelper.func_76131_a((float)((float)randomBossItemChance * 0.01f), (float)0.0f, (float)0.5f);
    }

    public static int getMinNumItems() {
        return MathHelper.func_76125_a((int)minNumChestItems, (int)1, (int)10);
    }

    public static int getBombWeight() {
        return MathHelper.func_76125_a((int)bombWeight, (int)1, (int)10);
    }

    public static int getBombBagWeight() {
        return MathHelper.func_76125_a((int)bombBagWeight, (int)1, (int)10);
    }

    public static int getHeartWeight() {
        return MathHelper.func_76125_a((int)heartPieceWeight, (int)1, (int)10);
    }

    public static int getBigKeyWeight() {
        return MathHelper.func_76125_a((int)bigKeyWeight, (int)1, (int)10);
    }

    public static int getSmallKeyWeight() {
        return MathHelper.func_76125_a((int)smallKeyWeight, (int)1, (int)10);
    }

    public static int getLockedLootWeight() {
        return MathHelper.func_76125_a((int)lockedLootWeight, (int)1, (int)10);
    }

    public static float getGrassDropChance() {
        return MathHelper.func_76131_a((float)((float)grassDropChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static float getJarDropChance() {
        return MathHelper.func_76131_a((float)((float)jarDropChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static float getCreeperDropChance() {
        return MathHelper.func_76131_a((float)((float)creeperDrop * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static boolean areOrbDropsEnabled() {
        return enableOrbDrops;
    }

    public static float getChanceForRandomDrop() {
        return MathHelper.func_76131_a((float)((float)randomDropChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static float getRandomMobDropChance() {
        return MathHelper.func_76131_a((float)((float)genericMobDropChance * 0.0f), (float)0.0f, (float)1.0f);
    }

    public static float getDropChance(int orbID) {
        int i = orbDropChance.containsKey((byte)orbID) ? orbDropChance.get((byte)orbID) : 0;
        return MathHelper.func_76131_a((float)((float)i * 0.001f), (float)0.0f, (float)0.01f);
    }

    public static int getPowerDropRate() {
        return Math.max(powerDropRate, 20);
    }

    public static boolean enableTradeBomb() {
        return enableTradeBomb;
    }

    public static boolean enableTradeBombBag() {
        return enableTradeBombBag;
    }

    public static int getMinBombBagPrice() {
        return Math.max(minBombBagPrice, 32);
    }

    public static boolean areArrowTradesEnabled() {
        return enableArrowTrades;
    }

    public static float getMaskBuyChance() {
        return MathHelper.func_76131_a((float)((float)maskBuyChance * 0.01f), (float)0.01f, (float)0.15f);
    }

    public static int getFriendTradesRequired() {
        return Math.max(friendTradesRequired, 3);
    }
}

