/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.bidirectional;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.LogHelper;

public class DeactivateSkillPacket
implements IMessage {
    private byte skillId;

    public DeactivateSkillPacket() {
    }

    public DeactivateSkillPacket(SkillActive skill) {
        this.skillId = skill.getId();
    }

    public void fromBytes(ByteBuf buffer) {
        this.skillId = buffer.readByte();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.skillId);
    }

    public static class Handler
    implements IMessageHandler<DeactivateSkillPacket, IMessage> {
        public IMessage onMessage(DeactivateSkillPacket message, MessageContext ctx) {
            EntityPlayer player = ZSSMain.proxy.getPlayerEntity(ctx);
            if (ZSSPlayerSkills.get(player) != null) {
                SkillBase skill = ZSSPlayerSkills.get(player).getPlayerSkill(message.skillId);
                if (skill instanceof SkillActive) {
                    ((SkillActive)skill).deactivate(player);
                } else {
                    LogHelper.warning("Error processing DeactivateSkillPacket for " + player + "; skill with ID " + message.skillId + " was not valid for this player.");
                }
            }
            return null;
        }
    }
}

