/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.packet.client.AbstractClientMessageHandler;

public class SyncPlayerInfoPacket
implements IMessage {
    private NBTTagCompound compound;
    private boolean validate = true;

    public SyncPlayerInfoPacket() {
    }

    public SyncPlayerInfoPacket(ZSSPlayerInfo info) {
        this.compound = new NBTTagCompound();
        info.saveNBTData(this.compound);
    }

    public SyncPlayerInfoPacket setReset() {
        this.validate = false;
        return this;
    }

    public void fromBytes(ByteBuf buffer) {
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
        this.validate = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
        buffer.writeBoolean(this.validate);
    }

    public static class Handler
    extends AbstractClientMessageHandler<SyncPlayerInfoPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, SyncPlayerInfoPacket message, MessageContext ctx) {
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            if (info != null) {
                info.loadNBTData(message.compound);
                if (message.validate) {
                    info.getPlayerSkills().validateSkills();
                }
            }
            return null;
        }
    }
}

