/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.network.packet.client.AbstractClientMessageHandler;
import zeldaswordskills.skills.SkillBase;

public class SyncSkillPacket
implements IMessage {
    private byte id;
    private NBTTagCompound compound;

    public SyncSkillPacket() {
    }

    public SyncSkillPacket(SkillBase skill) {
        this.id = skill.getId();
        this.compound = new NBTTagCompound();
        skill.writeToNBT(this.compound);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.id);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
    }

    public void fromBytes(ByteBuf buffer) {
        this.id = buffer.readByte();
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public static class Handler
    extends AbstractClientMessageHandler<SyncSkillPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, SyncSkillPacket message, MessageContext ctx) {
            ZSSPlayerSkills.get(player).syncClientSideSkill(message.id, message.compound);
            return null;
        }
    }
}

