/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.network.packet.client.AbstractClientMessageHandler;
import zeldaswordskills.skills.Combo;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.util.LogHelper;

public class UpdateComboPacket
implements IMessage {
    private NBTTagCompound compound;

    public UpdateComboPacket() {
    }

    public UpdateComboPacket(Combo combo) {
        this.compound = combo.writeToNBT();
    }

    public void fromBytes(ByteBuf buffer) {
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
    }

    public static class Handler
    extends AbstractClientMessageHandler<UpdateComboPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, UpdateComboPacket message, MessageContext ctx) {
            Combo combo = Combo.readFromNBT(message.compound);
            try {
                ICombo skill = (ICombo)((Object)ZSSPlayerSkills.get(player).getPlayerSkill(combo.getSkill()));
                if (skill != null) {
                    combo.getEntityFromWorld(player.field_70170_p);
                    skill.setCombo(combo);
                }
            }
            catch (ClassCastException e) {
                LogHelper.warning("Class Cast Exception from invalid Combo skill id of " + combo.getSkill());
            }
            return null;
        }
    }
}

