/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.server;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.packet.server.AbstractServerMessageHandler;
import zeldaswordskills.util.PlayerUtils;

public class BorrowMaskPacket
implements IMessage {
    private ItemStack mask;

    public BorrowMaskPacket() {
    }

    public BorrowMaskPacket(ItemStack mask) {
        this.mask = mask;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.mask == null ? 0 : 1);
        if (this.mask != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.mask);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.mask = buffer.readByte() > 0 ? ByteBufUtils.readItemStack((ByteBuf)buffer) : null;
    }

    public static class Handler
    extends AbstractServerMessageHandler<BorrowMaskPacket> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, BorrowMaskPacket message, MessageContext ctx) {
            if (message.mask != null) {
                PlayerUtils.addItemToInventory(player, message.mask);
                ZSSPlayerInfo.get(player).setBorrowedMask(message.mask.func_77973_b());
            }
            return null;
        }
    }
}

