/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.network.packet.server.AbstractServerMessageHandler;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Dash;
import zeldaswordskills.util.LogHelper;

public class DashImpactPacket
implements IMessage {
    private byte hitType;
    private int entityId;

    public DashImpactPacket() {
    }

    public DashImpactPacket(EntityPlayer player, MovingObjectPosition mop) {
        byte by = this.hitType = mop != null ? (byte)mop.field_72313_a.ordinal() : (byte)0;
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            this.entityId = mop.field_72308_g.func_145782_y();
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.hitType = buffer.readByte();
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            this.entityId = buffer.readInt();
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.hitType);
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            buffer.writeInt(this.entityId);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<DashImpactPacket> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, DashImpactPacket message, MessageContext ctx) {
            Dash dash = (Dash)ZSSPlayerSkills.get(player).getActiveSkill(SkillBase.dash);
            if (dash != null && dash.isActive()) {
                MovingObjectPosition mop = null;
                if (message.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
                    Entity entityHit = player.field_70170_p.func_73045_a(message.entityId);
                    if (entityHit != null) {
                        mop = new MovingObjectPosition(entityHit);
                    } else {
                        LogHelper.warning("Could not retrieve valid entity for MovingObjectPosition while handling Dash Packet!");
                    }
                }
                dash.onImpact(player.field_70170_p, player, mop);
            }
            return null;
        }
    }
}

