/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.network.packet.server.AbstractServerMessageHandler;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.LogHelper;

public class TargetIdPacket
implements IMessage {
    private byte skillId;
    private Entity entity;
    private int entityId;
    boolean isNull = false;

    public TargetIdPacket() {
    }

    public TargetIdPacket(SkillBase skill) throws IllegalArgumentException {
        if (!(skill instanceof ILockOnTarget)) {
            throw new IllegalArgumentException("Parameter 'skill' must be an instance of ILockOnTarget while constructing TargetIdPacket");
        }
        this.skillId = skill.getId();
        this.entity = ((ILockOnTarget)((Object)skill)).getCurrentTarget();
    }

    public void fromBytes(ByteBuf buffer) {
        if (buffer.readByte() == 1) {
            this.skillId = buffer.readByte();
            this.entityId = buffer.readInt();
        } else {
            this.isNull = true;
        }
    }

    public void toBytes(ByteBuf buffer) {
        if (this.entity != null) {
            buffer.writeByte(1);
            buffer.writeByte((int)this.skillId);
            buffer.writeInt(this.entity.func_145782_y());
        } else {
            buffer.writeByte(0);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<TargetIdPacket> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, TargetIdPacket message, MessageContext ctx) {
            ILockOnTarget skill = ZSSPlayerSkills.get(player).getTargetingSkill();
            if (skill != null) {
                if (message.isNull) {
                    skill.setCurrentTarget(null);
                } else {
                    Entity entity = player.field_70170_p.func_73045_a(message.entityId);
                    skill.setCurrentTarget(entity);
                    if (entity == null) {
                        LogHelper.warning("Invalid target; entity with id " + message.entityId + " is null");
                    }
                }
            }
            return null;
        }
    }
}

