/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import zeldaswordskills.api.item.HookshotType;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.EntityOctorok;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.LogHelper;
import zeldaswordskills.world.crisis.BossBattle;
import zeldaswordskills.world.crisis.DesertBattle;
import zeldaswordskills.world.crisis.EarthBattle;
import zeldaswordskills.world.crisis.FireBattle;
import zeldaswordskills.world.crisis.ForestBattle;
import zeldaswordskills.world.crisis.OceanBattle;

public enum BossType {
    HELL("temple_fire", FireBattle.class, EntityBlaze.class, 7, "hell"),
    DESERT("temple_desert", DesertBattle.class, EntityBlaze.class, 1, "desert", "deserthills"),
    FOREST("temple_forest", ForestBattle.class, EntityCaveSpider.class, 4, "forest", "foresthills"),
    TAIGA("temple_ice", BossBattle.class, EntitySkeleton.class, 5, "coldtaiga", "coldtaigahills", "iceplains"),
    OCEAN("temple_water", OceanBattle.class, EntityOctorok.class, 1, "ocean", "frozenocean", "deepocean"),
    SWAMP("temple_wind", BossBattle.class, EntityWitch.class, 4, "swampland"),
    MOUNTAIN("temple_earth", EarthBattle.class, EntityZombie.class, 3, "extremehills", "extremehillsedge");

    private final String unlocalizedName;
    private final String[] defaultBiomes;
    private final Class<? extends BossBattle> bossBattle;
    private final Class<? extends IMob> bossMob;
    public final int metadata;
    private static final Map<String, BossType> stringToTypeMap;
    private static final Map<String, BossType> bossBiomeList;
    private static final ItemStack[] desertItems;
    private static final ItemStack[] forestItems;
    private static final ItemStack[] mountainItems;
    private static final ItemStack[] netherItems;
    private static final ItemStack[] oceanItems;
    private static final ItemStack[] swampItems;
    private static final ItemStack[] taigaItems;

    private BossType(String name, Class<? extends BossBattle> bossBattle, Class<? extends IMob> bossMob, int block, String ... defaultBiomes) {
        this.unlocalizedName = name;
        this.defaultBiomes = defaultBiomes;
        this.bossBattle = bossBattle;
        this.bossMob = bossMob;
        this.metadata = block;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getDisplayName() {
        return StatCollector.func_74838_a((String)("dungeon.zss." + this.unlocalizedName + ".name"));
    }

    public String[] getDefaultBiomes() {
        return this.defaultBiomes;
    }

    public String toString() {
        return String.format("Name: %s BossMob: %s Block: %s", this.getUnlocalizedName(), this.bossMob != null ? this.bossMob.toString() : "NULL", this.metadata);
    }

    public static void addBiomes(BossType type, String[] biomeNames) {
        for (String biome : biomeNames) {
            if (biome.length() < 1) continue;
            if (bossBiomeList.containsKey(biome = biome.toLowerCase().replace(" ", ""))) {
                LogHelper.warning(String.format("Error while adding %s for %s: biome already mapped to %s", biome, type.getDisplayName(), bossBiomeList.get(biome).getDisplayName()));
                continue;
            }
            bossBiomeList.put(biome, type);
        }
    }

    public static BossType getBossType(String name) {
        if (stringToTypeMap.isEmpty()) {
            for (BossType type : BossType.values()) {
                stringToTypeMap.put(type.unlocalizedName, type);
            }
        }
        return stringToTypeMap.get(name.toLowerCase());
    }

    public static BossType getBossType(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome == null) {
            LogHelper.warning("Null biome at " + x + "/" + z + " while getting Boss Type");
            return null;
        }
        return bossBiomeList.get(biome.field_76791_y.toLowerCase().replace(" ", ""));
    }

    public ItemStack getSpecialItem() {
        switch (this) {
            case DESERT: {
                return new ItemStack(ZSSItems.pendant, 1, ItemPendant.PendantType.COURAGE.ordinal());
            }
            case MOUNTAIN: {
                return new ItemStack(ZSSItems.pendant, 1, ItemPendant.PendantType.POWER.ordinal());
            }
            case OCEAN: {
                return new ItemStack(ZSSItems.pendant, 1, ItemPendant.PendantType.WISDOM.ordinal());
            }
        }
        return null;
    }

    public ItemStack getRandomSpecialItem(Random rand) {
        ItemStack[] items = null;
        switch (this) {
            case DESERT: {
                items = desertItems;
                break;
            }
            case FOREST: {
                items = forestItems;
                break;
            }
            case HELL: {
                items = netherItems;
                break;
            }
            case MOUNTAIN: {
                items = mountainItems;
                break;
            }
            case OCEAN: {
                items = oceanItems;
                break;
            }
            case SWAMP: {
                items = swampItems;
                break;
            }
            case TAIGA: {
                items = taigaItems;
                break;
            }
        }
        if (items != null && items.length > 0) {
            return items[rand.nextInt(items.length)];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BossBattle getBossBattle(TileEntityDungeonCore core) {
        if (this.bossBattle == null) {
            LogHelper.warning("Error retrieving boss battle event for " + this.toString());
            return null;
        }
        BossBattle battle = null;
        try {
            try {
                battle = this.bossBattle.getConstructor(TileEntityDungeonCore.class).newInstance(new Object[]{core});
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Object var4_6 = null;
                return battle;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var4_7 = null;
                return battle;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Object var4_8 = null;
                return battle;
            }
        }
        finally {
            return battle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Entity getNewMob(World world) {
        if (this.bossMob == null) {
            LogHelper.warning("Error retrieving boss mob for " + this.toString());
            return null;
        }
        Entity entity = null;
        try {
            try {
                entity = (Entity)this.bossMob.getConstructor(World.class).newInstance(world);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Object var4_6 = null;
                return entity;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var4_7 = null;
                return entity;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Object var4_8 = null;
                return entity;
            }
        }
        finally {
            return entity;
        }
    }

    static {
        stringToTypeMap = new HashMap<String, BossType>();
        bossBiomeList = new HashMap<String, BossType>();
        desertItems = new ItemStack[]{new ItemStack(ZSSItems.boomerang), new ItemStack(ZSSItems.bootsHover), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal()), new ItemStack(ZSSItems.maskGibdo), new ItemStack(ZSSItems.rodFire)};
        forestItems = new ItemStack[]{new ItemStack(ZSSItems.dekuLeaf), new ItemStack(ZSSItems.heroBow), new ItemStack(ZSSItems.hookshot, 1, HookshotType.WOOD_SHOT.ordinal()), new ItemStack(ZSSItems.maskHawkeye)};
        mountainItems = new ItemStack[]{new ItemStack(ZSSItems.bootsPegasus), new ItemStack(ZSSItems.maskBlast), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal()), new ItemStack(ZSSItems.swordBroken, 1, Item.func_150891_b((Item)ZSSItems.swordGiant))};
        netherItems = new ItemStack[]{new ItemStack(ZSSItems.keySkeleton), new ItemStack(ZSSItems.heroBow), new ItemStack(ZSSItems.hookshotAddon, 1, ItemHookShotUpgrade.AddonType.MULTI.ordinal()), new ItemStack(ZSSItems.maskMajora), new ItemStack(ZSSItems.tunicGoronChest)};
        oceanItems = new ItemStack[]{new ItemStack(ZSSItems.bootsHeavy), new ItemStack(ZSSItems.maskStone), new ItemStack(ZSSItems.slingshot), new ItemStack(ZSSItems.tunicZoraChest)};
        swampItems = new ItemStack[]{new ItemStack(ZSSItems.bootsRubber), new ItemStack(ZSSItems.hammer), new ItemStack(ZSSItems.heroBow), new ItemStack(ZSSItems.maskHawkeye), new ItemStack(ZSSItems.rodTornado)};
        taigaItems = new ItemStack[]{new ItemStack(ZSSItems.boomerang), new ItemStack(ZSSItems.bootsHover), new ItemStack(ZSSItems.gauntletsSilver), new ItemStack(ZSSItems.maskGiants), new ItemStack(ZSSItems.rodIce)};
    }
}

