/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import zeldaswordskills.util.ZSSLogFormatter;

public class LogHelper {
    private static Logger logger = Logger.getLogger("Zelda Sword Skills".replace(" ", ""));
    private static Handler consoleHandler = new ConsoleHandler();
    private static Formatter zssFormatter = new ZSSLogFormatter();

    public static void init() {
        LogHelper.init(Level.INFO);
    }

    public static void init(Level level) {
        logger.setLevel(level);
        consoleHandler.setFormatter(zssFormatter);
        consoleHandler.setLevel(logger.getLevel());
        logger.setUseParentHandlers(false);
        logger.addHandler(consoleHandler);
    }

    public static void log(Level logLevel, String message) {
        logger.log(logLevel, message);
    }

    public static void severe(String message) {
        logger.log(Level.SEVERE, message);
    }

    public static void warning(String message) {
        logger.log(Level.WARNING, message);
    }

    public static void info(String message) {
        logger.log(Level.INFO, message);
    }

    public static void fine(String message) {
        logger.log(Level.FINE, message);
    }

    public static void finer(String message) {
        logger.log(Level.FINER, message);
    }

    public static void finest(String message) {
        logger.log(Level.FINEST, message);
    }
}

