/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import mods.battlegear2.api.core.IBattlePlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.item.ISkillItem;
import zeldaswordskills.api.item.ISword;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.bidirectional.PlaySoundPacket;

public class PlayerUtils {
    public static boolean isUsingItem(EntityPlayer player) {
        if (player.func_71039_bw()) {
            return true;
        }
        if (ZSSMain.isBG2Enabled) {
            return ((IBattlePlayer)player).isBattlemode() && ((IBattlePlayer)player).isBlockingWithShield();
        }
        return false;
    }

    public static boolean isHoldingSword(EntityPlayer player) {
        return player.func_70694_bm() != null && PlayerUtils.isSwordItem(player.func_70694_bm().func_77973_b());
    }

    public static boolean isHoldingSkillItem(EntityPlayer player) {
        return player.func_70694_bm() != null && PlayerUtils.isSkillItem(player.func_70694_bm().func_77973_b());
    }

    public static boolean isSwordItem(Item item) {
        return item instanceof ItemSword || item instanceof ISword;
    }

    public static boolean isSkillItem(Item item) {
        return PlayerUtils.isSwordItem(item) || item instanceof ISkillItem;
    }

    public static boolean isHoldingZeldaSword(EntityPlayer player) {
        return player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemZeldaSword;
    }

    public static boolean isHoldingMasterSword(EntityPlayer player) {
        return PlayerUtils.isHoldingZeldaSword(player) && ((ItemZeldaSword)player.func_70694_bm().func_77973_b()).isMasterSword();
    }

    public static boolean hasMasterSword(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemZeldaSword) || !((ItemZeldaSword)stack.func_77973_b()).isMasterSword()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return PlayerUtils.hasItem(player, item, -1);
    }

    public static boolean hasItem(EntityPlayer player, ItemStack stack) {
        return PlayerUtils.hasItem(player, stack.func_77973_b(), stack.func_77960_j());
    }

    public static boolean hasItem(EntityPlayer player, Item item, int meta) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item || meta != -1 && stack.func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    public static float getHealthMissing(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 0.0f : player.func_110138_aP() - player.func_110143_aJ();
    }

    public static void addItemToInventory(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item, int required) {
        return PlayerUtils.consumeInventoryItem(player, item, 0, required);
    }

    public static boolean consumeInventoryItem(EntityPlayer player, ItemStack stack, int required) {
        return PlayerUtils.consumeInventoryItem(player, stack.func_77973_b(), stack.func_77960_j(), required);
    }

    public static boolean consumeInventoryItem(EntityPlayer player, Item item, int meta, int required) {
        int consumed = required;
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && consumed > 0; ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            if (invStack == null || invStack.func_77973_b() != item || invStack.func_77960_j() != meta) continue;
            if (invStack.field_77994_a <= consumed) {
                consumed -= invStack.field_77994_a;
                player.field_71071_by.func_70299_a(i, null);
                continue;
            }
            player.field_71071_by.func_70299_a(i, invStack.func_77979_a(invStack.field_77994_a - consumed));
            consumed = 0;
            break;
        }
        if (consumed > 0) {
            player.field_71071_by.func_70441_a(new ItemStack(item, required - consumed, meta));
        }
        return consumed == 0;
    }

    public static void sendChat(EntityPlayer player, String message) {
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static void playSound(EntityPlayer player, String sound, float volume, float pitch) {
        if (player.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new PlaySoundPacket(sound, volume, pitch, (Entity)player));
        } else {
            PacketDispatcher.sendTo(new PlaySoundPacket(sound, volume, pitch), (EntityPlayerMP)player);
        }
    }

    public static void playRandomizedSound(EntityPlayer player, String sound, float f, float add) {
        float volume = player.field_70170_p.field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * f + add);
        PlayerUtils.playSound(player, sound, volume, pitch);
    }
}

