/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.lang.reflect.Field;
import zeldaswordskills.util.LogHelper;

public class ReflectionHelper {
    public static Field getField(String f, Class c) {
        try {
            return c.getDeclaredField(f);
        }
        catch (NoSuchFieldException e) {
            return c.getSuperclass() != null ? ReflectionHelper.getField(f, c.getSuperclass()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getValueFor(String f, Object o) {
        try {
            Field field = ReflectionHelper.getField(f, o.getClass());
            if (field != null) {
                field.setAccessible(true);
                LogHelper.info(String.format("Retrieved value %s from field %s: ", field.get(o), f));
                return field.get(o);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Boolean.FALSE;
    }

    public static Boolean setValueFor(String f, Object o, Object v) {
        try {
            Field field = ReflectionHelper.getField(f, o.getClass());
            if (field != null) {
                field.setAccessible(true);
                field.set(o, v);
                LogHelper.info(String.format("Set field %f to value %s: ", f, field.get(o)));
                return Boolean.TRUE;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Boolean.FALSE;
    }
}

