/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TargetUtils {
    private static final int MAX_DISTANCE = 256;
    private static final double MAX_DISTANCE_SQ = 65536.0;

    public static double getReachDistanceSq(EntityPlayer player) {
        return 38.5;
    }

    public static boolean canReachTarget(EntityPlayer player, Entity target) {
        return player.func_70685_l(target) && player.func_70068_e(target) < TargetUtils.getReachDistanceSq(player);
    }

    public static MovingObjectPosition checkForImpact(World world, Entity entity, Entity shooter, double hitBox, boolean flag) {
        Vec3 vec3 = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        Vec3 vec31 = Vec3.func_72443_a((double)(entity.field_70165_t + entity.field_70159_w), (double)(entity.field_70163_u + entity.field_70181_x), (double)(entity.field_70161_v + entity.field_70179_y));
        MovingObjectPosition mop = world.func_147447_a(vec3, vec31, false, true, false);
        vec3 = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        vec31 = Vec3.func_72443_a((double)(entity.field_70165_t + entity.field_70159_w), (double)(entity.field_70163_u + entity.field_70181_x), (double)(entity.field_70161_v + entity.field_70179_y));
        if (mop != null) {
            vec31 = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
        }
        Entity target = null;
        List list = world.func_72839_b(entity, entity.field_70121_D.func_72321_a(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition mop1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == shooter && !flag || (mop1 = (axisalignedbb = entity1.field_70121_D.func_72314_b(hitBox, hitBox, hitBox)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(mop1.field_72307_f)) < d0) && d0 != 0.0) continue;
            target = entity1;
            d0 = d1;
        }
        if (target != null) {
            mop = new MovingObjectPosition(target);
        }
        if (mop != null && mop.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)mop.field_72308_g;
            if (player.field_71075_bZ.field_75102_a || shooter instanceof EntityPlayer && !((EntityPlayer)shooter).func_96122_a(player)) {
                mop = null;
            }
        }
        return mop;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMouseOverEntity(Entity entity) {
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        return mop != null && mop.field_72308_g == entity;
    }

    @SideOnly(value=Side.CLIENT)
    public static Entity getMouseOverEntity() {
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        return mop == null ? null : mop.field_72308_g;
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius) {
        return TargetUtils.acquireLookTarget(seeker, distance, radius, false);
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius, boolean closestToSeeker) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        EntityLivingBase currentTarget = null;
        double currentDistance = 65536.0;
        Vec3 vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((targetX += vec3.field_72450_a) - radius), (double)((targetY += vec3.field_72448_b) - radius), (double)((targetZ += vec3.field_72449_c) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target)) continue;
                double d = closestToSeeker ? target.func_70068_e((Entity)seeker) : target.func_70092_e(targetX, targetY, targetZ);
                double newDistance = d;
                if (!(newDistance < currentDistance)) continue;
                currentTarget = target;
                currentDistance = newDistance;
            }
        }
        return currentTarget;
    }

    public static final List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        Vec3 vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((targetX += vec3.field_72450_a) - radius), (double)((targetY += vec3.field_72448_b) - radius), (double)((targetZ += vec3.field_72449_c) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target) || targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public static final boolean isTargetInFrontOf(Entity seeker, Entity target, float fov) {
        double dx = target.field_70165_t - seeker.field_70165_t;
        double dz = target.field_70161_v - seeker.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }

    public static final boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return TargetUtils.isTargetInSight(seeker.func_70040_Z(), seeker, target);
    }

    private static final boolean isTargetInSight(Vec3 vec3, EntityLivingBase seeker, Entity target) {
        return seeker.func_70685_l(target) && TargetUtils.isTargetInFrontOf((Entity)seeker, target, 60.0f);
    }

    public static final void applyArrowSettings(EntityArrow arrow, ItemStack bow, float charge) {
        int l;
        int k;
        if (charge < 0.0f) {
            charge = 0.0f;
        }
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        if (charge == 1.0f) {
            arrow.func_70243_d(true);
        }
        if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)k * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70240_a(l);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
            arrow.func_70015_d(100);
        }
    }

    public static void setEntityHeading(Entity entity, double vecX, double vecY, double vecZ, float velocity, float wobble, boolean backwards) {
        float vectorLength = MathHelper.func_76133_a((double)(vecX * vecX + vecY * vecY + vecZ * vecZ));
        vecX /= (double)vectorLength;
        vecY /= (double)vectorLength;
        vecZ /= (double)vectorLength;
        vecX += entity.field_70170_p.field_73012_v.nextGaussian() * (double)(entity.field_70170_p.field_73012_v.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)wobble;
        vecY += entity.field_70170_p.field_73012_v.nextGaussian() * (double)(entity.field_70170_p.field_73012_v.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)wobble;
        vecZ += entity.field_70170_p.field_73012_v.nextGaussian() * (double)(entity.field_70170_p.field_73012_v.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)wobble;
        entity.field_70159_w = vecX *= (double)velocity;
        entity.field_70181_x = vecY *= (double)velocity;
        entity.field_70179_y = vecZ *= (double)velocity;
        float f = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
        entity.field_70126_B = entity.field_70177_z = (float)(backwards ? -1 : 1) * (float)(Math.atan2(vecX, vecZ) * 180.0 / Math.PI);
        entity.field_70127_C = entity.field_70125_A = (float)(backwards ? -1 : 1) * (float)(Math.atan2(vecY, f) * 180.0 / Math.PI);
    }

    public static boolean isOnTeam(EntityPlayer player, EntityLivingBase entity) {
        if (entity == player) {
            return true;
        }
        if (player.func_142014_c(entity)) {
            return true;
        }
        if (entity instanceof IEntityOwnable) {
            return ((IEntityOwnable)entity).func_152113_b().equals(player.func_70005_c_());
        }
        return false;
    }

    public static boolean canEntitySeeSky(World world, Entity entity) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int y = MathHelper.func_76128_c((double)entity.field_70163_u) + 1; y < world.func_72940_L(); ++y) {
            if (world.func_147437_c(x, y, z)) continue;
            return false;
        }
        return true;
    }

    public static final void knockTargetBack(EntityLivingBase pushedEntity, EntityLivingBase pushingEntity) {
        if (pushedEntity.func_70104_M()) {
            double dx = pushedEntity.field_70165_t - pushingEntity.field_70165_t;
            double dz = pushedEntity.field_70161_v - pushingEntity.field_70161_v;
            while (dx * dx + dz * dz < 1.0E-4) {
                dx = (Math.random() - Math.random()) * 0.01;
                dz = (Math.random() - Math.random()) * 0.01;
            }
            pushedEntity.func_70653_a((Entity)pushingEntity, 0.0f, -dx, -dz);
        }
    }
}

