/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public abstract class RoomBase {
    public static final int SOUTH = 0;
    public static final int WEST = 1;
    public static final int NORTH = 2;
    public static final int EAST = 3;
    public boolean submerged = false;
    public boolean inLava = false;
    public boolean inOcean = false;
    public boolean inMountain = false;
    public boolean inNether = false;
    public boolean isLocked = false;
    protected StructureBoundingBox bBox;
    public final int chunkX;
    public final int chunkZ;
    protected final Block blockRequired;
    protected int metadata = 0;
    protected static final Set<Block> replaceBlocks = new HashSet<Block>();
    protected int validations = 0;
    protected static final int NUM_VALIDATIONS = 8;

    public final StructureBoundingBox getBoundingBox() {
        return this.bBox;
    }

    public final int getArea() {
        return this.bBox.func_78883_b() * this.bBox.func_78880_d();
    }

    public final int getVolume() {
        return this.bBox.func_78883_b() * this.bBox.func_78882_c() * this.bBox.func_78880_d();
    }

    public abstract boolean generate(ZSSMapGenBase var1, World var2, Random var3, int var4, int var5, int var6);

    protected abstract void decorateDungeon(World var1, Random var2);

    protected abstract void placeDungeonCore(World var1);

    protected void placePedestal(World world, int offsetY) {
        StructureGenUtils.setBlockAtPosition(world, this.bBox, this.bBox.func_78883_b() / 2, offsetY, this.bBox.func_78880_d() / 2, ZSSBlocks.pedestal, 0);
        int x = StructureGenUtils.getXWithOffset(this.bBox, this.bBox.func_78883_b() / 2, this.bBox.func_78880_d() / 2);
        int y = StructureGenUtils.getYWithOffset(this.bBox, offsetY);
        int z = StructureGenUtils.getZWithOffset(this.bBox, this.bBox.func_78883_b() / 2, this.bBox.func_78880_d() / 2);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).setSword(new ItemStack(ZSSItems.swordMaster), null);
        }
    }

    public RoomBase(int chunkX, int chunkZ, int size, int maxHeight, Block blockRequired) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.blockRequired = blockRequired;
        this.bBox = new StructureBoundingBox(1, 1, 1, Math.max(size, 3), MathHelper.func_76125_a((int)size, (int)3, (int)maxHeight), Math.max(size, 3));
    }

    protected boolean canGenerate(World world) {
        int failedAmount = 0;
        int maxFail = this.bBox.func_78883_b() * this.bBox.func_78880_d() / 2;
        for (int i = this.bBox.field_78897_a; i <= this.bBox.field_78893_d; ++i) {
            for (int j = this.bBox.field_78895_b; j <= this.bBox.field_78894_e; ++j) {
                for (int k = this.bBox.field_78896_c; k <= this.bBox.field_78892_f; ++k) {
                    Block block = world.func_147439_a(i, j, k);
                    if (this.canReplaceBlockAt(j, block)) continue;
                    if (block == ZSSBlocks.secretStone || Config.avoidModBlocks() && Block.func_149682_b((Block)block) > 255) {
                        return false;
                    }
                    if (++failedAmount <= maxFail) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void doStandardRoomGen(World world, Random rand) {
        StructureGenUtils.fillWithBlocks(world, this.bBox, 0, this.bBox.func_78883_b(), 0, this.bBox.func_78882_c(), 0, this.bBox.func_78880_d(), ZSSBlocks.secretStone, this.getMetadata());
        this.genSubmerged(world);
        this.generateAir(world);
        this.decorateDungeon(world, rand);
    }

    protected boolean isWellHidden(World world) {
        int difficulty = Config.getMainDungeonDifficulty();
        if (this.inOcean) {
            return true;
        }
        Material material = !this.inNether && StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, Material.field_151586_h, 1) > 0 ? Material.field_151586_h : Material.field_151579_a;
        int above = StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, material, 1);
        int below = StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, material, -1);
        if (this.inNether) {
            return world.field_73012_v.nextFloat() < 0.35f - (float)difficulty * 0.1f || (difficulty != 3 || above + below < 4) && StructureGenUtils.getNumBlocksOfMaterialInArea(world, this.bBox, material, 1) < this.getArea() / (difficulty + 1);
        }
        return world.field_73012_v.nextFloat() < 0.35f - (float)difficulty * 0.1f || above + below < 5 - difficulty;
    }

    protected boolean canReplaceBlockAt(World world, int x, int y, int z) {
        return this.canReplaceBlockAt(y, world.func_147439_a(x, y, z));
    }

    protected boolean canReplaceBlockAt(int y, Block block) {
        if (block == null) {
            return false;
        }
        boolean flag1 = this.submerged && !this.inLava && block.func_149688_o() == Material.field_151586_h;
        boolean flag2 = this.inNether && block.func_149688_o() == Material.field_151587_i;
        return replaceBlocks.contains(block) || flag1 || flag2 || block.func_149688_o().func_76224_d() && y < this.bBox.field_78894_e - 2;
    }

    protected int getMetadata() {
        return this.metadata + (this.isLocked ? 8 : 0);
    }

    protected abstract void setMetadata(World var1, int var2, int var3);

    protected void generateAir(World world) {
        if (!this.inOcean) {
            StructureGenUtils.fillWithBlocks(world, this.bBox, 1, this.bBox.func_78883_b() - 1, this.submerged ? (this.inLava || this.isLocked ? 2 : 3) : 1, this.bBox.func_78882_c() - 1, 1, this.bBox.func_78880_d() - 1, Blocks.field_150350_a, 0);
        }
    }

    protected void genSubmerged(World world) {
        if (this.submerged && this.bBox.func_78883_b() > 3) {
            int fillTo = this.inLava ? 2 : (this.inOcean ? this.bBox.func_78882_c() - 1 : 3);
            Block block = this.inLava ? Blocks.field_150353_l : Blocks.field_150355_j;
            StructureGenUtils.fillWithBlocks(world, this.bBox, 1, this.bBox.func_78883_b() - 1, 1, fillTo, 1, this.bBox.func_78880_d() - 1, block, 0);
        }
    }

    protected boolean placeInOcean(World world, boolean sink) {
        this.bBox.func_78886_a(0, 4, 0);
        int x = this.bBox.func_78881_e();
        int z = this.bBox.func_78891_g();
        boolean flag = world.func_72807_a((int)x, (int)z).field_76791_y.toLowerCase().contains("ocean");
        if (flag && !this.inLava && world.func_147439_a(x, this.bBox.field_78894_e, z).func_149688_o() == Material.field_151586_h) {
            for (int count = 0; this.bBox.field_78895_b > 16 && count < 8 && world.func_147439_a(x, this.bBox.field_78895_b, z).func_149688_o() == Material.field_151586_h; ++count) {
                this.bBox.func_78886_a(0, -1, 0);
            }
            if (world.func_147439_a(x, this.bBox.field_78895_b, z).func_149688_o() != Material.field_151586_h) {
                this.inOcean = true;
                StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151586_h, 6, false, false);
                if (sink) {
                    int diff = Config.getMainDungeonDifficulty();
                    int adj = 2 - diff;
                    if (world.field_73012_v.nextFloat() > (float)diff * 0.25f) {
                        adj = diff == 3 ? ++adj : (adj += world.field_73012_v.nextFloat() < 0.5f ? 1 : -1);
                    }
                    this.bBox.func_78886_a(0, -(this.bBox.func_78882_c() - adj), 0);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean placeInNether(World world) {
        while (this.bBox.field_78895_b > 8 && world.func_147439_a(this.bBox.func_78881_e(), this.bBox.field_78895_b, this.bBox.func_78891_g()).func_149688_o() == Material.field_151587_i) {
            this.bBox.func_78886_a(0, -1, 0);
        }
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151587_i, 4, false, false);
        return world.func_147439_a(this.bBox.func_78881_e(), this.bBox.field_78895_b, this.bBox.func_78891_g()) != ZSSBlocks.secretStone;
    }

    protected boolean validateTopLayer(World world) {
        int invalidBlocks = 0;
        int area = this.getArea();
        ++this.validations;
        for (int i = this.bBox.field_78897_a; i <= this.bBox.field_78893_d; ++i) {
            for (int k = this.bBox.field_78896_c; k <= this.bBox.field_78892_f; ++k) {
                if (this.validations > 8 || this.bBox.field_78895_b < 5) {
                    return false;
                }
                Block block = world.func_147439_a(i, this.bBox.field_78894_e, k);
                if (block != null && block.func_149688_o().func_76224_d()) {
                    this.submerged = true;
                    this.inLava = block == Blocks.field_150353_l;
                    this.bBox.func_78886_a(0, -1, 0);
                    return this.inNether && this.bBox.field_78894_e < 48 || this.validateTopLayer(world);
                }
                if (block == this.blockRequired || ++invalidBlocks <= area / 2) continue;
                this.bBox.func_78886_a(0, -1, 0);
                return this.validateTopLayer(world);
            }
        }
        return true;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("BB", (NBTBase)this.bBox.func_151535_h());
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.bBox = new StructureBoundingBox(compound.func_74759_k("BB"));
    }

    static {
        replaceBlocks.add(Blocks.field_150347_e);
        replaceBlocks.add(Blocks.field_150348_b);
        replaceBlocks.add(Blocks.field_150346_d);
        replaceBlocks.add((Block)Blocks.field_150349_c);
        replaceBlocks.add(Blocks.field_150351_n);
        replaceBlocks.add(Blocks.field_150424_aL);
        replaceBlocks.add((Block)Blocks.field_150354_m);
        replaceBlocks.add(Blocks.field_150322_A);
        replaceBlocks.add(Blocks.field_150433_aE);
    }
}

