/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.interfaces;

import com.pvp.BetterPvP;
import com.pvp.interfaces.DynamicTexture;
import com.pvp.interfaces.Interface;
import com.pvp.interfaces.MinimapChunk;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class Minimap {
    public Interface screen;
    public static final int frame = 9;
    public static final int loadSide = 16;
    public Minecraft mc = Minecraft.func_71410_x();
    private boolean caving = false;
    public static final Color radarMobs = new Color(255, 237, 36);
    public static final Color radarPlayers = new Color(255, 255, 255);
    public static final Color radarItems = new Color(255, 0, 0);
    public static final Color radarOther = new Color(174, 0, 255);
    public static final ResourceLocation mapTextures = new ResourceLocation("xaeromaptexture");
    public static DynamicTexture mapTexture = new DynamicTexture(mapTextures);
    public static MinimapChunk[][] mapBlocks0 = new MinimapChunk[16][16];
    public static MinimapChunk[][] mapBlocks1 = new MinimapChunk[16][16];
    public static ArrayList<Entity> loadedEntities = new ArrayList();
    public static int blocksLoaded = 0;
    public MapLoader loader = new MapLoader();
    public MinimapChunk[][] currentBlocks = mapBlocks1;
    public MinimapChunk[][] loadingBlocks = mapBlocks0;
    public int loadingMapX = 0;
    public int loadingMapZ = 0;
    public int loadedMapX = 0;
    public int loadedMapZ = 0;
    private byte[] bytes = new byte[786432];
    private byte drawYState = 0;

    public Minimap(Interface i) {
        this.screen = i;
        new Thread(this.loader).start();
    }

    public int loadBlockColor(int par1, int par2) {
        MinimapChunk chunk;
        boolean isglowing;
        int k = (int)this.mc.field_71439_g.field_70163_u;
        Block toReturn = null;
        boolean underwater = false;
        boolean underair = false;
        int lowPoint = this.caving ? k - 30 : 0;
        int highPoint = k + (this.caving ? 1 : 30);
        if (lowPoint < 0) {
            lowPoint = 0;
        }
        for (int i = highPoint; i >= lowPoint; --i) {
            Block got = this.mc.field_71439_g.field_70170_p.func_147439_a(par1, i, par2);
            if (!(got instanceof BlockAir) && underair) {
                if (got == Blocks.field_150355_j || got == Blocks.field_150358_i) {
                    underwater = true;
                    continue;
                }
                k = i;
                toReturn = got;
                break;
            }
            if (!(got instanceof BlockAir)) continue;
            underair = true;
        }
        double brightness = (double)(k * 3) / 256.0;
        int color = 1;
        if (toReturn != null) {
            color = toReturn.func_149688_o().func_151565_r().field_76291_p;
        }
        int l = color >> 16 & 0xFF;
        int i1 = color >> 8 & 0xFF;
        int j1 = color & 0xFF;
        if (underwater) {
            l = (l + 0) / 2;
            i1 = (i1 + 100) / 2;
            j1 = (j1 + 255) / 2;
        }
        if ((l = (int)((double)l * ((isglowing = toReturn == Blocks.field_150353_l || toReturn == Blocks.field_150356_k || toReturn == Blocks.field_150426_aN) ? 1.0 : brightness))) > 255) {
            l = 255;
        }
        if ((i1 = (int)((double)i1 * (isglowing ? 1.0 : brightness))) > 255) {
            i1 = 255;
        }
        if ((j1 = (int)((double)j1 * (isglowing ? 1.0 : brightness))) > 255) {
            j1 = 255;
        }
        color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        int chunkX = (par1 >> 4) - this.loadingMapX;
        int chunkZ = (par2 >> 4) - this.loadingMapZ;
        if (chunkX < 0 || chunkX >= 16 || chunkZ < 0 || chunkZ >= 16) {
            return 1;
        }
        MinimapChunk[] chunkmap = this.loadingBlocks[chunkX];
        if (chunkmap == null) {
            chunkmap = new MinimapChunk[16];
            this.loadingBlocks[chunkX] = chunkmap;
        }
        if ((chunk = chunkmap[chunkZ]) == null) {
            chunkmap[chunkZ] = chunk = new MinimapChunk();
        }
        chunk.colors[par1 & 0xF][par2 & 0xF] = color;
        return color;
    }

    public int getMapX() {
        return ((int)this.mc.field_71439_g.field_70165_t >> 4) - 8;
    }

    public int getMapZ() {
        return ((int)this.mc.field_71439_g.field_70161_v >> 4) - 8;
    }

    public int getLoadedBlockColor(int par1, int par2) {
        int chunkX = (par1 >> 4) - this.loadedMapX;
        int chunkZ = (par2 >> 4) - this.loadedMapZ;
        if (chunkX < 0 || chunkX >= 16 || chunkZ < 0 || chunkZ >= 16) {
            return 1;
        }
        if (this.currentBlocks[chunkX][chunkZ] != null) {
            return this.currentBlocks[chunkX][chunkZ].colors[par1 & 0xF][par2 & 0xF];
        }
        return 1;
    }

    public double getAngle() {
        double angle;
        double rotation = this.mc.field_71439_g.field_70177_z;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0) {
            angle += 360.0;
        }
        angle /= 180.0;
        return angle *= Math.PI;
    }

    public double getZoom() {
        return 1 + BetterPvP.getSettings().zoom;
    }

    public void updateMapFrame() {
        double offy;
        double offx;
        int mapW = (this.screen.w - 18) * 2;
        int mapH = (this.screen.h - 18) * 2;
        double angle = this.getAngle();
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        int currentState = this.drawYState;
        EntityClientPlayerMP p = this.mc.field_71439_g;
        int halfW = mapW / 2;
        int halfH = mapH / 2;
        double zoom = this.getZoom();
        long before = System.currentTimeMillis();
        for (int currentX = 0; currentX < mapW; ++currentX) {
            for (int currentY = currentState; currentY < mapH; currentY += 2) {
                double Y;
                int blockZ;
                offx = (double)(currentX - halfW) / this.getZoom();
                double X = ps * offx + pc * (offy = (double)(currentY - halfH) / this.getZoom());
                int blockX = (int)(this.mc.field_71439_g.field_70165_t + X - 1.0);
                int j = this.getLoadedBlockColor(blockX, blockZ = (int)(this.mc.field_71439_g.field_70161_v + (Y = ps * offy - pc * offx) - 1.0));
                if (j == 0) continue;
                this.putColor(this.bytes, currentX + 8, currentY + 8, j);
            }
            currentState = (byte)(currentState != 1 ? 1 : 0);
        }
        this.drawYState = (byte)(this.drawYState != 1 ? 1 : 0);
        for (int i = 0; i < loadedEntities.size(); ++i) {
            try {
                double brightness;
                Entity e = loadedEntities.get(i);
                if (e.func_70093_af() || e.func_82150_aj()) continue;
                offx = e.field_70165_t - p.field_70165_t;
                offy = e.field_70161_v - p.field_70161_v;
                double offh = p.field_70163_u - e.field_70163_u;
                double Y = pc * offx + ps * offy;
                double X = ps * offx - pc * offy;
                int drawX = mapW / 2 + (int)(X * zoom);
                int drawY = mapH / 2 + (int)(Y * zoom);
                if (drawX + 3 > mapW || drawY + 3 > mapH || drawX - 2 < 0 || drawY - 2 < 0) continue;
                int color = radarOther.hashCode();
                if (e instanceof EntityPlayer) {
                    color = radarPlayers.hashCode();
                } else if (e instanceof EntityLiving) {
                    color = radarMobs.hashCode();
                } else if (e instanceof EntityItem) {
                    color = radarItems.hashCode();
                }
                int l = color >> 16 & 0xFF;
                int i1 = color >> 8 & 0xFF;
                int j1 = color & 0xFF;
                double level = 20.0 - offh;
                if (level < 0.0) {
                    level = 0.0;
                }
                if ((l = (int)((double)l * (brightness = level / 20.0))) > 255) {
                    l = 255;
                }
                if ((i1 = (int)((double)i1 * brightness)) > 255) {
                    i1 = 255;
                }
                if ((j1 = (int)((double)j1 * brightness)) > 255) {
                    j1 = 255;
                }
                color = 0xFF000000 | l << 16 | i1 << 8 | j1;
                for (int a = drawX - 2; a < drawX + 4; ++a) {
                    for (int b = drawY - 2; b < drawY + 4; ++b) {
                        if ((a == drawX - 2 || a == drawX + 3) && (b == drawY - 2 || b == drawY + 3) || a == drawX + 2 && b == drawY - 2 || a == drawX + 3 && b == drawY - 1 || a == drawX - 2 && b == drawY + 2 || a == drawX - 1 && b == drawY + 3) continue;
                        if (a == drawX + 3 || b == drawY + 3 || a == drawX + 2 && b == drawY + 2) {
                            this.putColor(this.bytes, 8 + a, 8 + b, 0);
                            continue;
                        }
                        this.putColor(this.bytes, 8 + a, 8 + b, color);
                    }
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Minimap.mapTexture.buffer.put(this.bytes);
        Minimap.mapTexture.buffer.flip();
    }

    private boolean isCaving() {
        if (!BetterPvP.settings.getCaveMaps()) {
            return false;
        }
        int x = (int)this.mc.field_71439_g.field_70165_t;
        int y = (int)this.mc.field_71439_g.field_70163_u;
        int z = (int)this.mc.field_71439_g.field_70161_v;
        for (int i = y; i < y + 30; ++i) {
            Block got = this.mc.field_71439_g.field_70170_p.func_147439_a(x, i, z);
            if (!got.func_149688_o().func_76218_k()) continue;
            return true;
        }
        return false;
    }

    private void putColor(byte[] bytes, int x, int y, int color) {
        int pixel = (y * 512 + x) * 3;
        bytes[pixel] = (byte)(color >> 16 & 0xFF);
        bytes[pixel + 1] = (byte)(color >> 8 & 0xFF);
        bytes[pixel + 2] = (byte)(color & 0xFF);
    }

    public class MapLoader
    implements Runnable {
        @Override
        public void run() {
            int updateChunkX = 0;
            int updateChunkZ = 0;
            int x = 0;
            int z = 0;
            while (true) {
                long before = System.currentTimeMillis();
                try {
                    if (BetterPvP.getSettings() != null && BetterPvP.getSettings().getMinimap() && Minimap.this.mc.field_71439_g != null) {
                        if (updateChunkX == 0 && updateChunkZ == 0) {
                            Minimap.this.caving = Minimap.this.isCaving();
                            x = (int)Minimap.this.mc.field_71439_g.field_70165_t;
                            z = (int)Minimap.this.mc.field_71439_g.field_70161_v;
                            Minimap.this.loadingMapX = Minimap.this.getMapX();
                            Minimap.this.loadingMapZ = Minimap.this.getMapZ();
                        }
                        long before1 = System.currentTimeMillis();
                        this.updateChunk(updateChunkX, updateChunkZ);
                        if (updateChunkX == 15 && updateChunkZ == 15) {
                            MinimapChunk[][] bu = Minimap.this.currentBlocks;
                            Minimap.this.currentBlocks = Minimap.this.loadingBlocks;
                            Minimap.this.loadingBlocks = bu;
                            Minimap.this.loadingBlocks = new MinimapChunk[16][16];
                            Minimap.this.loadedMapX = Minimap.this.loadingMapX;
                            Minimap.this.loadedMapZ = Minimap.this.loadingMapZ;
                        }
                        if ((updateChunkX = (updateChunkX + 1) % 16) == 0) {
                            updateChunkZ = (updateChunkZ + 1) % 16;
                            EntityClientPlayerMP p = Minimap.this.mc.field_71439_g;
                            ArrayList<Entity> loadingEntities = new ArrayList<Entity>();
                            for (int i = 0; i < p.field_70170_p.field_72996_f.size(); ++i) {
                                try {
                                    Entity e = (Entity)p.field_70170_p.field_72996_f.get(i);
                                    if (e instanceof EntityPlayer ? e != p && (!BetterPvP.getSettings().getShowPlayers() || !BetterPvP.settings.getShowOtherTeam() && p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp()) : (e instanceof EntityLiving ? !BetterPvP.getSettings().getShowMobs() : (e instanceof EntityItem ? !BetterPvP.getSettings().getShowItems() : !BetterPvP.getSettings().getShowOther()))) continue;
                                    double offx = e.field_70165_t - p.field_70165_t;
                                    double offy = e.field_70161_v - p.field_70161_v;
                                    double offh = p.field_70163_u - e.field_70163_u;
                                    double offheight2 = offh * offh;
                                    double offx2 = offx * offx;
                                    double offy2 = offy * offy;
                                    double maxDistance = 31250.0 / (Minimap.this.getZoom() * Minimap.this.getZoom());
                                    if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > 400.0) continue;
                                    loadingEntities.add(e);
                                    if (loadingEntities.size() < 100 * BetterPvP.getSettings().entityAmount) continue;
                                    break;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            loadedEntities = loadingEntities;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int passed = (int)(System.currentTimeMillis() - before);
                try {
                    if (passed <= 5) {
                        Thread.sleep(5 - passed);
                        continue;
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                }
            }
        }

        public void updateChunk(int x, int z) {
            int chunkX = Minimap.this.loadingMapX + x;
            int chunkZ = Minimap.this.loadingMapZ + z;
            int x1 = chunkX * 16;
            int z1 = chunkZ * 16;
            for (int blockX = x1; blockX < x1 + 16; ++blockX) {
                for (int blockZ = z1; blockZ < z1 + 16; ++blockZ) {
                    Minimap.this.loadBlockColor(blockX, blockZ);
                }
            }
        }
    }
}

