/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.items;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.gui.GuiAtlasMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapData;

public class ItemAtlas
extends ItemMap {
    public boolean func_77643_m_() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            player.field_70125_A = 50.0f;
        }
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.openMapGUI(world, player, stack);
                return stack;
            }
            player.openGui((Object)BiblioCraft.instance, 100, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void openMapGUI(World world, EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasMap(world, player, stack));
    }

    private boolean getAtlasInventory(ItemStack stack, World world, EntityPlayer player, boolean autoCreate, boolean autoCenter, int zoomLevel, int selectedSlot) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            int i;
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i2 = 0; i2 < tagList.func_74745_c(); ++i2) {
                NBTTagCompound tag = tagList.func_150305_b(i2);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            ItemStack currentSlot = null;
            if (autoCenter) {
                for (i = 6; i < atlasInventory.func_70302_i_(); ++i) {
                    MapData mapdata;
                    currentSlot = atlasInventory.func_70301_a(i);
                    if (currentSlot == null || !(currentSlot.func_77973_b() instanceof ItemMap) || (mapdata = Items.field_151098_aY.func_77873_a(currentSlot, world)) == null || !this.isPlayerWithinMapData(mapdata, player, zoomLevel)) continue;
                    stack.func_77964_b(currentSlot.func_77960_j());
                    this.saveMapSlotToNBT(stack, player, i);
                    ByteBuf buffer = Unpooled.buffer();
                    ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)stack);
                    BiblioCraft.ch_BiblioAtlas.sendTo(new FMLProxyPacket(buffer, "BiblioAtlas"), (EntityPlayerMP)player);
                    return true;
                }
            } else {
                currentSlot = atlasInventory.func_70301_a(selectedSlot);
                if (currentSlot != null) {
                    stack.func_77964_b(currentSlot.func_77960_j());
                    this.saveMapSlotToNBT(stack, player, selectedSlot);
                    ByteBuf buffer = Unpooled.buffer();
                    ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)stack);
                    BiblioCraft.ch_BiblioAtlas.sendTo(new FMLProxyPacket(buffer, "BiblioAtlas"), (EntityPlayerMP)player);
                }
                return true;
            }
            if (autoCreate) {
                for (i = 6; i < atlasInventory.func_70302_i_(); ++i) {
                    currentSlot = atlasInventory.func_70301_a(i);
                    if (currentSlot == null || currentSlot.func_77973_b() != Items.field_151148_bJ || currentSlot.field_77994_a != 1) continue;
                    ItemStack newmap = this.makeNewMap(world, player, zoomLevel, stack);
                    atlasInventory.func_70299_a(i, newmap);
                    NBTTagCompound ntags = stack.func_77978_p();
                    if (ntags == null) {
                        ntags = new NBTTagCompound();
                    }
                    ntags.func_74768_a("mapSlot", -1);
                    NBTTagList itemList = new NBTTagList();
                    for (int n = 0; n < atlasInventory.func_70302_i_(); ++n) {
                        ItemStack invSlot = atlasInventory.func_70301_a(n);
                        if (invSlot == null) continue;
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74774_a("Slot", (byte)n);
                        invSlot.func_77955_b(tag);
                        itemList.func_74742_a((NBTBase)tag);
                    }
                    ntags.func_74782_a("Inventory", (NBTBase)itemList);
                    stack.func_77982_d(ntags);
                    stack.func_77964_b(currentSlot.func_77960_j());
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                    return true;
                }
            }
            this.saveMapSlotToNBT(stack, player, -1);
        }
        return false;
    }

    private void saveMapSlotToNBT(ItemStack stack, EntityPlayer player, int slot) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags.func_74768_a("mapSlot", slot);
            stack.func_77982_d(tags);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
        }
    }

    public ItemStack makeNewMap(World world, EntityPlayer player, int scale, ItemStack oldMap) {
        MapData oldmapdata = Items.field_151098_aY.func_77873_a(oldMap, world);
        double mx = 0.0;
        double mz = 0.0;
        int newXcenter = 0;
        int newZcenter = 0;
        ItemStack itemstack = new ItemStack((Item)Items.field_151098_aY, 1, world.func_72841_b("map"));
        String s = "map_" + itemstack.func_77960_j();
        MapData mapdata = new MapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = (byte)scale;
        int i = 128 * (1 << mapdata.field_76197_d);
        if (oldmapdata != null) {
            System.out.println(oldmapdata.field_76190_i);
            mx = oldmapdata.field_76201_a;
            mz = oldmapdata.field_76199_b;
            System.out.println("old map centers  " + mx + "    " + mz);
            switch (this.playerDirection(world, player, oldmapdata)) {
                case 0: {
                    newXcenter = (int)(mx + 128.0 * Math.pow(2.0, scale));
                    newZcenter = (int)mz;
                    break;
                }
                case 1: {
                    newXcenter = (int)(mx - 128.0 * Math.pow(2.0, scale));
                    newZcenter = (int)mz;
                    break;
                }
                case 2: {
                    newXcenter = (int)mx;
                    newZcenter = (int)(mz - 128.0 * Math.pow(2.0, scale));
                    break;
                }
                case 3: {
                    newXcenter = (int)mx;
                    newZcenter = (int)(mz + 128.0 * Math.pow(2.0, scale));
                    break;
                }
                default: {
                    newXcenter = (int)(Math.round(player.field_70165_t / (double)i) * (long)i);
                    newZcenter = (int)(Math.round(player.field_70161_v / (double)i) * (long)i);
                    break;
                }
            }
        } else {
            newXcenter = (int)(Math.round(player.field_70165_t / (double)i) * (long)i);
            newZcenter = (int)(Math.round(player.field_70161_v / (double)i) * (long)i);
        }
        mapdata.field_76201_a = newXcenter;
        mapdata.field_76199_b = newZcenter;
        mapdata.field_76200_c = world.field_73011_w.field_76574_g;
        mapdata.func_76185_a();
        return itemstack;
    }

    private int playerDirection(World world, EntityPlayer player, MapData mapdata) {
        double px = player.field_70165_t;
        double pz = player.field_70161_v;
        double mx = mapdata.field_76201_a;
        double mz = mapdata.field_76199_b;
        byte scale = mapdata.field_76197_d;
        double factor = 64.0 * Math.pow(2.0, scale);
        if (px > mx + factor && px < mx + factor + 2.0 * factor) {
            return 0;
        }
        if (px < mx - factor && px > mx - factor - 2.0 * factor) {
            return 1;
        }
        if (pz < mz + factor && pz > mz + factor + 2.0 * factor) {
            return 2;
        }
        if (pz > mz - factor && pz < mz - factor - 2.0 * factor) {
            return 3;
        }
        return -1;
    }

    public boolean isPlayerWithinMapData(MapData map, EntityPlayer player, int zoomLevel) {
        if (map == null || player == null) {
            return false;
        }
        double px = player.field_70165_t;
        double pz = player.field_70161_v;
        double mx = map.field_76201_a;
        double mz = map.field_76199_b;
        byte scale = map.field_76197_d;
        if (scale != zoomLevel) {
            return false;
        }
        double factor = 64.0 * Math.pow(2.0, scale);
        return px < mx + factor && px > mx - factor && pz < mz + factor && pz > mz - factor;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean inhand) {
        if (!world.field_72995_K) {
            MapData mapdata = Items.field_151098_aY.func_77873_a(stack, world);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                mapdata.func_76191_a(entityplayer, stack);
                if (inhand) {
                    NBTTagCompound tags = stack.func_77978_p();
                    if (tags == null) {
                        return;
                    }
                    boolean autoCenter = tags.func_74767_n("autoCenter");
                    boolean autoCreate = tags.func_74767_n("autoCreate");
                    int zoomLevel = tags.func_74762_e("zoomLevel");
                    int selectedSlot = tags.func_74762_e("mapSlot");
                    if (this.getMapSlot(stack) == -1) {
                        this.getAtlasInventory(stack, world, entityplayer, autoCreate, autoCenter, zoomLevel, selectedSlot);
                    }
                    if (autoCenter && !this.isPlayerWithinMapData(mapdata, entityplayer, zoomLevel)) {
                        this.getAtlasInventory(stack, world, entityplayer, autoCreate, autoCenter, zoomLevel, selectedSlot);
                    }
                    this.func_77872_a(world, entity, mapdata);
                }
            }
        }
    }

    private int getMapSlot(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            return tags.func_74762_e("mapSlot");
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("bibliocraft:atlas");
    }
}

