/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import jds.bibliocraft.FileUtil;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.tileentities.TileEntityClock;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import jds.bibliocraft.tileentities.TileEntityMarkerPole;
import jds.bibliocraft.tileentities.TileEntityPaintPress;
import jds.bibliocraft.tileentities.TileEntityPainting;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import jds.bibliocraft.tileentities.TileEntityWritingDesk;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ServerPacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        FMLProxyPacket packet = event.packet;
        if (packet != null) {
            if (packet.channel().equals("BiblioType")) {
                this.handleBookNameUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioTypeFlag")) {
                this.handleBookFlagUpdate(packet.payload());
            }
            if (packet.channel().equals("BiblioTypeDelete")) {
                this.handleBookDeletion(packet.payload());
            }
            if (packet.channel().equals("BiblioTypeUpdate")) {
                this.handleTypsetUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioMCBEdit")) {
                this.handleBookEdit(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMCBPage")) {
                this.handleBookPageUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioClipboard")) {
                this.handleInventoryStackUpdate(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMeasure")) {
                this.handleMarkerPoles(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioMapPin")) {
                this.handleMapWaypoints(packet.payload(), player);
            }
            if (packet.channel().equals("BiblioRBook")) {
                this.handleRecipeBook(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioRBookLoad")) {
                this.handleRecipeLoad(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioSign")) {
                this.handleFancySignUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioClock")) {
                this.handleClockUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPaintPress")) {
                this.handlePaintPressUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioPainting")) {
                this.handlePaintingUpdate(packet.payload(), player.field_70170_p);
            }
            if (packet.channel().equals("BiblioAtlas")) {
                this.handleAtlasUpdate(packet.payload(), player);
            }
        }
    }

    private void handleAtlasUpdate(ByteBuf packet, EntityPlayerMP player) {
        NBTTagCompound tags;
        boolean autoCenter = packet.readBoolean();
        boolean autoCreate = packet.readBoolean();
        int zoomLevel = packet.readInt();
        int slot = packet.readInt();
        ItemStack atlas = player.func_70694_bm();
        if (atlas != null && atlas.func_77973_b() instanceof ItemAtlas && (tags = atlas.func_77978_p()) != null) {
            int oldSlot = tags.func_74762_e("mapSlot");
            tags.func_74757_a("autoCenter", autoCenter);
            tags.func_74757_a("autoCreate", autoCreate);
            tags.func_74768_a("zoomLevel", zoomLevel);
            tags.func_74768_a("mapSlot", slot);
            atlas.func_77982_d(tags);
            if (oldSlot != slot) {
                atlas.func_77964_b(this.setAtlasDamage(atlas, slot));
            }
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
        }
    }

    private int setAtlasDamage(ItemStack atlas, int newslot) {
        NBTTagCompound tags = atlas.func_77978_p();
        InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 48);
        NBTTagList tagList = tags.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
            ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            atlasInventory.func_70299_a((int)slot, invStack);
        }
        ItemStack newmap = atlasInventory.func_70301_a(newslot);
        if (newmap != null && newmap.func_77973_b() instanceof ItemMap) {
            return newmap.func_77960_j();
        }
        return -1;
    }

    private void handlePaintingUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int corner = packet.readInt();
        int scale = packet.readInt();
        int res = packet.readInt();
        int aspect = packet.readInt();
        int rotation = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPainting) {
            TileEntityPainting painting = (TileEntityPainting)tile;
            painting.setPacketUpdate(corner, scale, res, aspect, rotation);
        }
    }

    private void handlePaintPressUpdate(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int artType = packet.readInt();
        String artName = ByteBufUtils.readUTF8String((ByteBuf)packet);
        boolean applyToCanvas = packet.readBoolean();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityPaintPress) {
            TileEntityPaintPress press = (TileEntityPaintPress)tile;
            press.setSelectedPainting(artType, artName);
            if (applyToCanvas) {
                press.setCycle(true);
            }
        }
    }

    private void handleClockUpdate(ByteBuf packet, World world) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)packet);
        if (tags != null) {
            int k;
            int j;
            int[] chimes = tags.func_74759_k("chimes");
            int[] redstone = tags.func_74759_k("redstone");
            boolean tick = packet.readBoolean();
            boolean chime = packet.readBoolean();
            boolean rsout = packet.readBoolean();
            int i = packet.readInt();
            TileEntity tile = world.func_147438_o(i, j = packet.readInt(), k = packet.readInt());
            if (tile != null && tile instanceof TileEntityClock) {
                TileEntityClock clock = (TileEntityClock)tile;
                clock.setSettingFromGui(chimes, redstone, tick, chime, rsout);
            }
        }
    }

    private void handleFancySignUpdate(ByteBuf packet, World world) {
        int z;
        int y;
        String[] text = new String[15];
        int[] textScales = new int[15];
        for (int n = 0; n < 15; ++n) {
            text[n] = ByteBufUtils.readUTF8String((ByteBuf)packet);
            textScales[n] = packet.readInt();
        }
        int numOfLines = packet.readInt();
        int s1Scale = packet.readInt();
        int s1Rot = packet.readInt();
        int s2Scale = packet.readInt();
        int s2Rot = packet.readInt();
        int s1x = packet.readInt();
        int s1y = packet.readInt();
        int s2x = packet.readInt();
        int s2y = packet.readInt();
        int x = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y = packet.readInt(), z = packet.readInt());
        if (tile != null && tile instanceof TileEntityFancySign) {
            TileEntityFancySign sign = (TileEntityFancySign)tile;
            sign.updateFromPacket(text, textScales, numOfLines, s1Scale, s1Rot, s1x, s1y, s2Scale, s2Rot, s2x, s2y);
        }
    }

    private void handleRecipeLoad(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int id = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            bench.loadInvToGridForRecipe(id);
        }
    }

    private void handleRecipeBook(ByteBuf packet, World world) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int id = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            bench.setBookGrid(id);
        }
    }

    private void handleTypsetUpdate(ByteBuf packet, World world) {
        int z;
        int y;
        int x = packet.readInt();
        TileEntity tile = world.func_147438_o(x, y = packet.readInt(), z = packet.readInt());
        if (tile != null && tile instanceof TileEntityTypeMachine) {
            TileEntityTypeMachine typeTile = (TileEntityTypeMachine)tile;
            typeTile.booklistset();
        }
    }

    private void handleBookNameUpdate(ByteBuf packet, EntityPlayerMP player) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        this.updateTypeMachine(x, y, z, bookname, player);
    }

    private void updateTypeMachine(int x, int y, int z, String book, EntityPlayerMP player) {
        World world = player.field_70170_p;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            TileEntityTypeMachine typetile = (TileEntityTypeMachine)tile;
            typetile.setBookname(book);
        }
    }

    private void handleBookFlagUpdate(ByteBuf packet) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        boolean newFlag = packet.readBoolean();
        FileUtil util = new FileUtil();
        boolean isServer = packet.readBoolean();
        if (util.updatePublicFlag(!isServer, bookname, newFlag)) {
            String fl = "private";
            if (newFlag) {
                fl = "public";
            }
        } else {
            FMLLog.warning((String)("Updating book flag for " + bookname + " failed"), (Object[])new Object[0]);
        }
    }

    private void handleBookDeletion(ByteBuf packet) {
        String bookname = ByteBufUtils.readUTF8String((ByteBuf)packet);
        FileUtil util = new FileUtil();
        boolean isServer = packet.readBoolean();
        if (util.deleteBook(!isServer, bookname)) {
            FMLLog.info((String)(bookname + " has been deleted Forever!"), (Object[])new Object[0]);
        } else {
            FMLLog.warning((String)("Deletion of " + bookname + " failed"), (Object[])new Object[0]);
        }
    }

    private void handleBookEdit(ByteBuf packet, EntityPlayerMP player) {
        TileEntityWritingDesk deskTile;
        ItemStack book = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int currentPage = packet.readInt();
        if (book != null && (deskTile = (TileEntityWritingDesk)player.field_70170_p.func_147438_o(x, y, z)) != null) {
            deskTile.overwriteWrittenBook(book);
            deskTile.setCurrentPage(currentPage);
        }
    }

    private void handleBookPageUpdate(ByteBuf packet, EntityPlayerMP player) {
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        int currentPage = packet.readInt();
        TileEntityWritingDesk deskTile = (TileEntityWritingDesk)player.field_70170_p.func_147438_o(x, y, z);
        if (deskTile != null) {
            deskTile.setCurrentPage(currentPage);
        }
    }

    private void handleInventoryStackUpdate(ByteBuf packet, EntityPlayerMP player) {
        ItemStack stackostuff = ByteBufUtils.readItemStack((ByteBuf)packet);
        if (stackostuff != null) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = stackostuff;
        }
    }

    private void handleMarkerPoles(ByteBuf packet, EntityPlayerMP player) {
        int i = packet.readInt();
        int j = packet.readInt();
        int k = packet.readInt();
        boolean newTest = packet.readBoolean();
        int direction = packet.readInt();
        World world = player.field_70170_p;
        int iadj = 0;
        int jadj = 0;
        int kadj = 0;
        switch (direction) {
            case 0: {
                jadj = -1;
                break;
            }
            case 1: {
                jadj = 1;
                break;
            }
            case 2: {
                kadj = -1;
                break;
            }
            case 3: {
                kadj = 1;
                break;
            }
            case 4: {
                iadj = -1;
                break;
            }
            case 5: {
                iadj = 1;
                break;
            }
            default: {
                iadj = 1;
            }
        }
        if (newTest) {
            if (world.func_147437_c(i + iadj, j + jadj, k + kadj)) {
                world.func_147465_d(i + iadj, j + jadj, k + kadj, BlockLoader.stuffBlock, 1, 2);
                TileEntityMarkerPole poleTile = (TileEntityMarkerPole)world.func_147438_o(i + iadj, j + jadj, k + kadj);
                if (poleTile != null) {
                    poleTile.setDirection(direction);
                }
            }
        } else if (world.func_147439_a(i + iadj, j + jadj, k + kadj) == BlockLoader.stuffBlock && world.func_72805_g(i + iadj, j + jadj, k + kadj) == 1) {
            world.func_147480_a(i + iadj, j + jadj, k + kadj, false);
        }
    }

    private void handleMapWaypoints(ByteBuf packet, EntityPlayerMP player) {
        World world = player.field_70170_p;
        int i = packet.readInt();
        int j = packet.readInt();
        int k = packet.readInt();
        float xPin = packet.readFloat();
        float yPin = packet.readFloat();
        String name = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int color = packet.readInt();
        int pinNum = packet.readInt();
        boolean remove = packet.readBoolean();
        boolean edit = packet.readBoolean();
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityMapFrame) {
            TileEntityMapFrame mapFrame = (TileEntityMapFrame)tile;
            if (!remove) {
                if (!edit) {
                    mapFrame.addPinCoords(xPin, yPin, name, color);
                } else {
                    mapFrame.editPinData(name, color, pinNum);
                }
            } else {
                mapFrame.removePin(pinNum);
            }
        }
    }
}

