/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelBookcaseBooks;
import jds.bibliocraft.models.ModelBookcaseEmpty;
import jds.bibliocraft.models.OBJBookcase;
import jds.bibliocraft.tileentities.TileEntityBookcase;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityBookcaseRenderer
extends TileEntitySpecialRenderer {
    private ModelBookcaseEmpty modelEmpty = new ModelBookcaseEmpty();
    private ModelBookcaseBooks modelBooks = new ModelBookcaseBooks();
    private OBJBookcase objModel = new OBJBookcase();
    private int bookcaseAngle;
    private int degreeAngle;
    private int[] bookcheck;
    private boolean shifted;
    private float ishift = 0.0f;
    private float kshift = 0.0f;
    private static boolean useTextureSheet;

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        Block bookcaseBlock = tileEntity.func_145838_q();
        TileEntityBookcase bookTile = (TileEntityBookcase)tileEntity;
        this.bookcaseAngle = bookTile.getAngle();
        this.bookcheck = bookTile.getCheckedBooks();
        this.shifted = bookTile.getShift();
        useTextureSheet = this.usesTextureSheet();
        this.ishift = 0.0f;
        this.kshift = 0.0f;
        switch (this.bookcaseAngle) {
            case 0: {
                this.degreeAngle = 270;
                if (!this.shifted) break;
                this.ishift = -0.5f;
                this.kshift = 0.0f;
                break;
            }
            case 1: {
                this.degreeAngle = 180;
                if (!this.shifted) break;
                this.ishift = 0.0f;
                this.kshift = -0.5f;
                break;
            }
            case 2: {
                this.degreeAngle = 90;
                if (!this.shifted) break;
                this.ishift = 0.5f;
                this.kshift = 0.0f;
                break;
            }
            case 3: {
                this.degreeAngle = 0;
                if (!this.shifted) break;
                this.ishift = 0.0f;
                this.kshift = 0.5f;
                break;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(i + 0.5 + (double)this.ishift), (double)(j + 0.5), (double)(k + 0.5 + (double)this.kshift));
        GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)2.0f, (float)0.0f);
        int texNum = tileEntity.func_145832_p();
        if (useTextureSheet) {
            this.func_147499_a(this.getModelTexture(texNum));
            this.modelEmpty.renderShelf();
        } else {
            this.func_147499_a(this.getVanillaWoodTexture(texNum));
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.objModel.render();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.func_147499_a(CommonProxy.BOOKCASE_BOOKS_PNG);
        for (int r = 0; r < this.bookcheck.length; ++r) {
            if (this.bookcheck[r] != 1) continue;
            this.modelBooks.renderBook(r + 1);
        }
        GL11.glEnable((int)2896);
        int booknum = bookTile.getShowText();
        if (booknum >= 0 && booknum < 16) {
            ItemStack bookstack = bookTile.getBook(booknum);
            if (bookstack != null) {
                NBTTagList var5;
                String bookname = "";
                bookname = bookstack.field_77994_a > 1 ? bookstack.field_77994_a + " " + bookstack.func_82833_r() : bookstack.func_82833_r();
                Item booktest = bookstack.func_77973_b();
                if (booktest instanceof ItemEnchantedBook && (var5 = this.func_92056_g(bookstack)) != null) {
                    short var7 = var5.func_150305_b(0).func_74765_d("id");
                    short var8 = var5.func_150305_b(0).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[var7] != null) {
                        bookname = Enchantment.field_77331_b[var7].func_77316_c((int)var8);
                    }
                }
                this.renderText(bookname, 0.0, 0.0, 0.0);
            }
            bookTile.setShowText(-1);
        }
        GL11.glPopMatrix();
    }

    public void renderText(String text, double xadjust, double yadjust, double zadjust) {
        FontRenderer fontRender = this.func_147498_b();
        GL11.glDepthMask((boolean)false);
        GL11.glScalef((float)0.006f, (float)0.006f, (float)0.006f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)(0.0 + xadjust), (double)(-8.0 + yadjust), (double)(-1.0 + zadjust));
        int adjust = fontRender.func_78256_a(text) / 2;
        fontRender.func_85187_a(text, -adjust, 0, Config.color, Config.textshadow);
        GL11.glDepthMask((boolean)true);
    }

    public NBTTagList func_92056_g(ItemStack par1ItemStack) {
        return par1ItemStack.field_77990_d != null && par1ItemStack.field_77990_d.func_74764_b("StoredEnchantments") ? (NBTTagList)par1ItemStack.field_77990_d.func_74781_a("StoredEnchantments") : new NBTTagList();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.BOOKCASE_EMPTY0_PNG;
            }
            case 1: {
                return CommonProxy.BOOKCASE_EMPTY1_PNG;
            }
            case 2: {
                return CommonProxy.BOOKCASE_EMPTY2_PNG;
            }
            case 3: {
                return CommonProxy.BOOKCASE_EMPTY3_PNG;
            }
            case 4: {
                return CommonProxy.BOOKCASE_EMPTY4_PNG;
            }
            case 5: {
                return CommonProxy.BOOKCASE_EMPTY5_PNG;
            }
        }
        return CommonProxy.BOOKCASE_EMPTY0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

