/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelPotionShelf;
import jds.bibliocraft.models.OBJPotionShelf;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemPotionShelfRenderer
implements IItemRenderer {
    private ModelPotionShelf potionshelfModel;
    private OBJPotionShelf objModel = new OBJPotionShelf();
    private static boolean useTextureSheet;

    public ItemPotionShelfRenderer() {
        this.potionshelfModel = new ModelPotionShelf();
        useTextureSheet = this.usesTextureSheet();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metaTest = item.func_77960_j();
        switch (type) {
            case ENTITY: {
                this.renderPotionShelf(0.3f, -0.05f, 0.0f, metaTest, true);
                break;
            }
            case EQUIPPED: {
                this.renderPotionShelf(0.6f, 0.8f, 0.8f, metaTest, false);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderPotionShelf(0.6f, 0.8f, 0.8f, metaTest, false);
                break;
            }
            case INVENTORY: {
                this.renderPotionShelf(0.8f, 0.65f, 1.0f, metaTest, false);
                break;
            }
        }
    }

    private void renderPotionShelf(float i, float j, float k, int metaData, boolean entity) {
        float scale = 0.03125f;
        Tessellator tesselator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)i, (float)j, (float)k);
        if (entity) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (useTextureSheet) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
            this.potionshelfModel.renderShelf(scale);
        } else {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getVanillaWoodTexture(metaData));
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.031);
            this.objModel.render();
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.031);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.POTIONSHELF0_PNG;
            }
            case 1: {
                return CommonProxy.POTIONSHELF1_PNG;
            }
            case 2: {
                return CommonProxy.POTIONSHELF2_PNG;
            }
            case 3: {
                return CommonProxy.POTIONSHELF3_PNG;
            }
            case 4: {
                return CommonProxy.POTIONSHELF4_PNG;
            }
            case 5: {
                return CommonProxy.POTIONSHELF5_PNG;
            }
        }
        return CommonProxy.POTIONSHELF0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

