/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelTypeset;
import jds.bibliocraft.models.ModelTypesetBase;
import jds.bibliocraft.models.ModelTypesetBook;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityTypeSetRenderer
extends TileEntitySpecialRenderer {
    private ModelTypeset typeModel = new ModelTypeset();
    private ModelTypesetBook bookModel = new ModelTypesetBook();
    private ModelTypesetBase baseModel = new ModelTypesetBase();
    private TileEntityTypeMachine typeTile;
    private int typeAngle;
    private int degreeAngle;
    private float iadjust;
    private float kadjust;
    private int chaseNum;
    private boolean hasBook;
    private boolean bookSaved;
    private boolean hasNewPlate;
    private boolean hasOldPlate;
    private boolean hasBottomLeftChase;
    private String bookname;
    private boolean hasEnchantedBook;
    private boolean hasEnchantedPlate;

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        this.typeTile = (TileEntityTypeMachine)tileEntity;
        this.typeAngle = tileEntity.func_145832_p();
        this.chaseNum = this.typeTile.getChaseNum();
        this.hasBook = this.typeTile.signedBookCheck();
        this.bookSaved = this.typeTile.hasSavedBook();
        this.hasNewPlate = this.typeTile.hasNewPlate();
        this.hasOldPlate = this.typeTile.hasOldPlate();
        this.hasBottomLeftChase = this.typeTile.hasLowerChase();
        this.bookname = this.typeTile.getBookname();
        this.hasEnchantedBook = this.typeTile.enchantedBookCheck();
        this.hasEnchantedPlate = this.typeTile.hasEnchantedPlate();
        switch (this.typeAngle) {
            case 0: {
                this.degreeAngle = 270;
                this.iadjust = -0.04f;
                this.kadjust = 0.0f;
                break;
            }
            case 1: {
                this.degreeAngle = 180;
                this.iadjust = -0.02f;
                this.kadjust = -0.02f;
                break;
            }
            case 2: {
                this.degreeAngle = 90;
                this.iadjust = 0.0f;
                this.kadjust = 0.0f;
                break;
            }
            case 3: {
                this.degreeAngle = 0;
                this.iadjust = -0.02f;
                this.kadjust = 0.02f;
                break;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(i + (double)0.52f + (double)this.iadjust), (double)(j + (double)0.62f + (double)0.3f), (double)(k + 0.5 + (double)this.kadjust));
        GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.func_147499_a(CommonProxy.TYPESET_TOP);
        this.typeModel.renderTop();
        if (this.chaseNum > 0) {
            this.typeModel.renderChaseStack(this.chaseNum);
        }
        if (this.hasNewPlate) {
            this.typeModel.renderlowerRightPlate();
        }
        if (this.hasOldPlate) {
            this.typeModel.renderlowerLeftPlate();
        }
        if (this.hasBottomLeftChase) {
            this.typeModel.renderLeftChase();
        }
        if (this.hasEnchantedPlate) {
            // empty if block
        }
        this.func_147499_a(CommonProxy.TYPESET_BASE);
        this.baseModel.renderBase();
        if (this.hasBook) {
            if (this.bookSaved) {
                this.func_147499_a(CommonProxy.TYPESET_BOOK2);
            } else {
                this.func_147499_a(CommonProxy.TYPESET_BOOK1);
            }
            this.bookModel.renderBook();
        }
        if (this.hasEnchantedBook) {
            this.func_147499_a(CommonProxy.TYPESET_BOOK3);
            this.bookModel.renderBook();
        }
        if (this.hasEnchantedBook || this.hasEnchantedPlate) {
            float tickModifier = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 48.0f;
            this.func_147499_a(CommonProxy.GLINT_PNG);
            GL11.glEnable((int)3042);
            float var20 = 0.5f;
            GL11.glColor4f((float)var20, (float)var20, (float)var20, (float)1.0f);
            GL11.glDepthFunc((int)514);
            GL11.glDepthMask((boolean)false);
            for (int var21 = 0; var21 < 2; ++var21) {
                GL11.glDisable((int)2896);
                float var22 = 0.76f;
                GL11.glColor4f((float)(0.5f * var22), (float)(0.25f * var22), (float)(0.8f * var22), (float)1.0f);
                GL11.glBlendFunc((int)768, (int)1);
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                float var23 = tickModifier * (0.001f + (float)var21 * 0.003f) * 20.0f;
                float var24 = 0.33333334f;
                GL11.glScalef((float)var24, (float)var24, (float)var24);
                GL11.glRotatef((float)(30.0f - (float)var21 * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)var23, (float)0.0f);
                GL11.glMatrixMode((int)5888);
                if (this.hasEnchantedBook) {
                    this.bookModel.renderBook();
                }
                if (!this.hasEnchantedPlate) continue;
                this.typeModel.renderlowerRightPlate();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glDepthMask((boolean)true);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glDepthFunc((int)515);
        }
        GL11.glEnable((int)2896);
        if (this.typeTile.getShowLevels()) {
            this.renderText(StatCollector.func_74838_a((String)"typesetting.requires") + " " + this.typeTile.getLevels() + " " + StatCollector.func_74838_a((String)"typesetting.levels"), 0.0, 0.0, 0.0, Config.color2);
            if (this.hasEnchantedBook) {
                short var18;
                short var17;
                String ench1 = "";
                String ench2 = "";
                String ench3 = "";
                String ench4 = "";
                NBTTagList taglist = this.getEnchantmentTagList(this.typeTile.getEntchantedBook());
                int tagscount = 0;
                if (taglist != null) {
                    tagscount = taglist.func_74745_c();
                }
                if (tagscount > 0) {
                    short var7 = taglist.func_150305_b(0).func_74765_d("id");
                    short var8 = taglist.func_150305_b(0).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[var7] != null) {
                        ench1 = Enchantment.field_77331_b[var7].func_77316_c((int)var8);
                    }
                }
                if (tagscount > 1) {
                    var17 = taglist.func_150305_b(1).func_74765_d("id");
                    var18 = taglist.func_150305_b(1).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[var17] != null) {
                        ench2 = Enchantment.field_77331_b[var17].func_77316_c((int)var18);
                    }
                }
                if (tagscount > 2) {
                    var17 = taglist.func_150305_b(2).func_74765_d("id");
                    var18 = taglist.func_150305_b(2).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[var17] != null) {
                        ench3 = Enchantment.field_77331_b[var17].func_77316_c((int)var18);
                    }
                }
                if (tagscount > 3) {
                    var17 = taglist.func_150305_b(3).func_74765_d("id");
                    var18 = taglist.func_150305_b(3).func_74765_d("lvl");
                    if (Enchantment.field_77331_b[var17] != null) {
                        ench4 = Enchantment.field_77331_b[var17].func_77316_c((int)var18);
                    }
                }
                this.renderText(ench1, ench2, ench3, ench4, tagscount, 0.0, 0.0);
            }
            this.typeTile.setShowLevels(false);
        }
        if (this.typeTile.getShowBookname()) {
            this.renderText(this.bookname, 0.0, 0.0, 0.0, Config.color);
            this.typeTile.setShowBookname(false);
        }
        if (this.typeTile.getShowChaseText() && this.chaseNum > 0) {
            int chasesize = this.typeTile.func_70301_a((int)1).field_77994_a;
            String chaseText = chasesize + " " + StatCollector.func_74838_a((String)"typesetting.chase");
            this.renderText(chaseText, 0.0, 0.0, 32.0, Config.color);
            this.typeTile.setChaseText(false);
        }
        GL11.glPopMatrix();
    }

    public void renderText(String text, double xadjust, double yadjust, double zadjust, int color) {
        FontRenderer fontRender = this.func_147498_b();
        GL11.glDepthMask((boolean)false);
        GL11.glScalef((float)0.005f, (float)0.005f, (float)0.005f);
        GL11.glTranslated((double)(0.0 + xadjust), (double)(0.0 + yadjust), (double)(-5.0 + zadjust));
        int adjust = fontRender.func_78256_a(text) / 2;
        fontRender.func_85187_a(text, -adjust, -8, color, Config.textshadow);
        GL11.glDepthMask((boolean)true);
    }

    public void renderText(String text, String text2, String text3, String text4, int numlines, double xadjust, double yadjust) {
        FontRenderer fontRender = this.func_147498_b();
        GL11.glDepthMask((boolean)false);
        GL11.glTranslated((double)(-44.0 + xadjust), (double)(-2.0 + yadjust), (double)-94.0);
        int adjust = fontRender.func_78256_a(text) / 2;
        fontRender.func_85187_a(text, -adjust, 0, Config.color2, Config.textshadow);
        if (numlines > 1) {
            int adjust2 = fontRender.func_78256_a(text2) / 2;
            fontRender.func_85187_a(text2, -adjust2, 10, Config.color2, Config.textshadow);
        }
        if (numlines > 2) {
            int adjust3 = fontRender.func_78256_a(text3) / 2;
            fontRender.func_85187_a(text3, -adjust3, 20, Config.color2, Config.textshadow);
        }
        if (numlines > 3) {
            int adjust4 = fontRender.func_78256_a(text4) / 2;
            fontRender.func_85187_a(text4, -adjust4, 30, Config.color2, Config.textshadow);
        }
        GL11.glDepthMask((boolean)true);
    }

    public NBTTagList getEnchantmentTagList(ItemStack stack) {
        return stack.field_77990_d != null && stack.field_77990_d.func_74764_b("StoredEnchantments") ? (NBTTagList)stack.field_77990_d.func_74781_a("StoredEnchantments") : new NBTTagList();
    }
}

