/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jds.bibliocraft.blocks.BlockLoader;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityClock
extends TileEntity {
    private int angle;
    private int clockType = 0;
    public int secondCount = 0;
    public int hourCount = 0;
    public float pendulumCount = 0.0f;
    public int activityCount = 0;
    public boolean chimePerformed = false;
    public int chimeLastPerformed = -1;
    public boolean redstonePerformed = false;
    public int redstoneLastPerformed = -1;
    public boolean redstoneActive = false;
    public int redstoneCount = 0;
    public boolean tickSound = true;
    public boolean chimes = false;
    public boolean redstone = false;
    public int[] chimeSettings = new int[48];
    public int[] redstoneSettings = new int[48];
    public boolean islocked = false;
    public String lockee = "";

    public void setAngle(int ang) {
        this.angle = ang;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setClockType(int type) {
        this.clockType = type;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getAngle() {
        return this.angle;
    }

    public int getClockType() {
        return this.clockType;
    }

    public boolean isLocked() {
        return this.islocked;
    }

    public void setLocked(boolean locked, boolean firstPass) {
        this.islocked = locked;
        if (firstPass) {
            TileEntity tile;
            if (this.clockType == 1) {
                TileEntity tile2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                if (tile2 != null && tile2 instanceof TileEntityClock) {
                    TileEntityClock lowerClock = (TileEntityClock)tile2;
                    lowerClock.setLocked(locked, false);
                }
            } else if (this.clockType == 2 && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && tile instanceof TileEntityClock) {
                TileEntityClock upperClock = (TileEntityClock)tile;
                upperClock.setLocked(locked, false);
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String getLockee() {
        return this.lockee;
    }

    public void setLockee(String lockeeperson, boolean firstPass) {
        if (firstPass) {
            TileEntity tile;
            if (this.clockType == 1) {
                TileEntity tile2 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                if (tile2 != null && tile2 instanceof TileEntityClock) {
                    TileEntityClock lowerClock = (TileEntityClock)tile2;
                    lowerClock.setLockee(lockeeperson, false);
                }
            } else if (this.clockType == 2 && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && tile instanceof TileEntityClock) {
                TileEntityClock upperClock = (TileEntityClock)tile;
                upperClock.setLockee(lockeeperson, false);
            }
        }
        this.lockee = lockeeperson;
    }

    public void setSettingFromGui(int[] dings, int[] powers, boolean tickToggle, boolean chimeToggle, boolean redstoneToggle) {
        this.chimeSettings = dings;
        this.redstoneSettings = powers;
        this.tickSound = tickToggle;
        this.chimes = chimeToggle;
        this.redstone = redstoneToggle;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.angle = nbt.func_74762_e("angle");
        this.clockType = nbt.func_74762_e("clockType");
        this.chimeSettings = nbt.func_74759_k("chimeSettings");
        this.redstoneSettings = nbt.func_74759_k("redstoneSettings");
        this.tickSound = nbt.func_74767_n("tickSound");
        this.chimes = nbt.func_74767_n("chimeSound");
        this.redstone = nbt.func_74767_n("toggleRedstone");
        this.islocked = nbt.func_74767_n("locked");
        this.lockee = nbt.func_74779_i("lockee");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("angle", this.angle);
        nbt.func_74768_a("clockType", this.clockType);
        nbt.func_74783_a("chimeSettings", this.chimeSettings);
        nbt.func_74783_a("redstoneSettings", this.redstoneSettings);
        nbt.func_74757_a("tickSound", this.tickSound);
        nbt.func_74757_a("chimeSound", this.chimes);
        nbt.func_74757_a("toggleRedstone", this.redstone);
        nbt.func_74757_a("locked", this.islocked);
        nbt.func_74778_a("lockee", this.lockee);
    }

    public Packet func_145844_m() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74768_a("angle", this.angle);
        dataTag.func_74768_a("clockType", this.clockType);
        dataTag.func_74783_a("chimeSettings", this.chimeSettings);
        dataTag.func_74783_a("redstoneSettings", this.redstoneSettings);
        dataTag.func_74757_a("tickSound", this.tickSound);
        dataTag.func_74757_a("chimeSound", this.chimes);
        dataTag.func_74757_a("toggleRedstone", this.redstone);
        dataTag.func_74757_a("locked", this.islocked);
        dataTag.func_74778_a("lockee", this.lockee);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, dataTag);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.angle = nbtData.func_74762_e("angle");
        this.clockType = nbtData.func_74762_e("clockType");
        this.chimeSettings = nbtData.func_74759_k("chimeSettings");
        this.redstoneSettings = nbtData.func_74759_k("redstoneSettings");
        this.tickSound = nbtData.func_74767_n("tickSound");
        this.chimes = nbtData.func_74767_n("chimeSound");
        this.redstone = nbtData.func_74767_n("toggleRedstone");
        this.islocked = nbtData.func_74767_n("locked");
        this.lockee = nbtData.func_74779_i("lockee");
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.clockType != 2) {
            long time = this.field_145850_b.func_72820_D();
            this.activityCount = (int)(time % 24000L / 500L) + 24;
            if (this.activityCount >= 48) {
                this.activityCount -= 48;
            }
            if (this.field_145850_b.field_72995_K) {
                this.hourCount = (int)(time % 24000L / 1000L) * 15;
                this.secondCount = (int)((double)(time % 24000L) / 16.667) * 6;
                double coscount = Math.PI * 2 * ((double)(time % 40L) / 40.0);
                if (this.clockType == 0) {
                    this.pendulumCount = (float)(0.17453292519943295 * Math.cos(coscount) * 114.59155902616465);
                }
                if (this.clockType == 1) {
                    this.pendulumCount = (float)(0.04363323129985824 * Math.cos(coscount) * 114.59155902616465);
                }
                if (this.tickSound) {
                    if (time % 40L == 37L) {
                        this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "bibliocraft:tock", 0.4f, 1.0f, false);
                    } else if (time % 40L == 17L) {
                        this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "bibliocraft:tick", 0.4f, 1.0f, false);
                    }
                }
                if (this.chimes) {
                    if (this.chimePerformed && this.chimeLastPerformed != this.activityCount) {
                        this.chimePerformed = false;
                        this.chimeLastPerformed = -1;
                    }
                    if (!this.chimePerformed && this.chimeSettings[this.activityCount] == 1) {
                        this.chimePerformed = true;
                        this.chimeLastPerformed = this.activityCount;
                        this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "bibliocraft:woundchime", 0.9f, 1.0f, false);
                    }
                }
            } else if (this.redstone) {
                this.redstoneAlgo();
            }
        }
    }

    public void redstoneAlgo() {
        TileEntityClock bottomClock;
        TileEntity tile;
        if (this.redstonePerformed && this.redstoneLastPerformed != this.activityCount) {
            this.redstonePerformed = false;
            this.redstoneLastPerformed = -1;
        }
        if (!this.redstonePerformed && this.redstoneSettings[this.activityCount] == 1) {
            this.redstonePerformed = true;
            this.redstoneLastPerformed = this.activityCount;
            this.setActivateRedstone(true);
            if (this.clockType == 1 && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null && tile instanceof TileEntityClock) {
                bottomClock = (TileEntityClock)tile;
                bottomClock.setActivateRedstone(true);
            }
        }
        if (this.redstoneActive) {
            if (this.redstonePerformed && this.redstoneCount < 40) {
                ++this.redstoneCount;
            } else if (this.redstonePerformed) {
                this.redstoneCount = 0;
                this.setActivateRedstone(false);
                if (this.clockType == 1 && (tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null && tile instanceof TileEntityClock) {
                    bottomClock = (TileEntityClock)tile;
                    bottomClock.setActivateRedstone(false);
                }
            }
        }
    }

    public void setActivateRedstone(boolean toggle) {
        this.redstoneActive = toggle;
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, BlockLoader.fancyclock);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        return bb;
    }
}

