/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.forge;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.lwjgl.input.Keyboard;
import org.millenaire.client.MillClientUtilities;
import org.millenaire.client.ModelFemaleAsymmetrical;
import org.millenaire.client.ModelFemaleSymmetrical;
import org.millenaire.client.RenderMillVillager;
import org.millenaire.client.RenderWallDecoration;
import org.millenaire.client.forge.ClientGuiHandler;
import org.millenaire.client.forge.ClientTickHandler;
import org.millenaire.client.network.ClientReceiver;
import org.millenaire.client.network.ClientSender;
import org.millenaire.client.texture.TextureAmuletAlchemist;
import org.millenaire.client.texture.TextureAmuletVishnu;
import org.millenaire.client.texture.TextureAmuletYddrasil;
import org.millenaire.common.EntityMillDecoration;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.TileEntityMillChest;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.UserProfile;
import org.millenaire.common.forge.CommonProxy;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;

public class ClientProxy
extends CommonProxy {
    @Override
    public void checkTextureSize() {
        MillClientUtilities.checkTextSize();
    }

    @Override
    public void testTextureSize() {
        MillClientUtilities.checkTextSize();
    }

    @Override
    public IGuiHandler createGuiHandler() {
        return new ClientGuiHandler();
    }

    @Override
    public File getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = new File(new File(Minecraft.func_71410_x().field_71412_D, "mods"), "millenaire");
        }
        return this.baseDir;
    }

    @Override
    public UserProfile getClientProfile() {
        if (Mill.clientWorld.profiles.containsKey(Mill.proxy.getTheSinglePlayer().getDisplayName())) {
            return Mill.clientWorld.profiles.get(Mill.proxy.getTheSinglePlayer().getDisplayName());
        }
        UserProfile profile = new UserProfile(Mill.clientWorld, Mill.proxy.getTheSinglePlayer().getDisplayName(), Mill.proxy.getTheSinglePlayer().getDisplayName());
        Mill.clientWorld.profiles.put(profile.key, profile);
        return profile;
    }

    @Override
    public File getConfigFile() {
        return new File(this.getBaseDir(), "config.txt");
    }

    @Override
    public File getCustomConfigFile() {
        return new File(this.getCustomDir(), "config-custom.txt");
    }

    @Override
    public File getCustomDir() {
        if (this.customDir == null) {
            this.customDir = new File(new File(Minecraft.func_71410_x().field_71412_D, "mods"), "millenaire-custom");
        }
        return this.customDir;
    }

    @Override
    public String getItemName(Item item, int meta) {
        if (item == null) {
            try {
                throw new MLN.MillenaireException("Trying to get the name of a null item.");
            }
            catch (Exception e) {
                MLN.printException(e);
                return null;
            }
        }
        if (meta == -1) {
            meta = 0;
        }
        return new ItemStack(item, 1, meta).func_82833_r();
    }

    @Override
    public String getInvItemName(MillVillager.InvItem iv) {
        if (iv.block != null) {
            return this.getBlockName(iv.block, iv.meta);
        }
        return this.getItemName(iv.item, iv.meta);
    }

    @Override
    public String getBlockName(Block block, int meta) {
        if (block == null) {
            try {
                throw new MLN.MillenaireException("Trying to get the name of a null block.");
            }
            catch (Exception e) {
                MLN.printException(e);
                return null;
            }
        }
        if (meta == -1) {
            meta = 0;
        }
        return new ItemStack(block, 1, meta).func_82833_r();
    }

    @Override
    public File getLogFile() {
        return new File(this.getBaseDir(), "millenaire.log");
    }

    @Override
    public String getQuestKeyName() {
        return Keyboard.getKeyName((int)MLN.keyInfoPanelList);
    }

    @Override
    public EntityPlayer getTheSinglePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public String getSinglePlayerName() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            return Minecraft.func_71410_x().field_71439_g.getDisplayName();
        }
        return "NULL_PLAYER";
    }

    @Override
    public void handleClientGameUpdate() {
        MillClientUtilities.handleKeyPress(Mill.clientWorld.world);
        if (Mill.clientWorld.world.func_72820_D() % 20L == 0L) {
            Mill.clientWorld.clearPanelQueue();
        }
        this.loadLanguages();
    }

    @Override
    public void handleClientLogin() {
        ClientSender.sendVersionInfo();
        ClientSender.sendAvailableContent();
    }

    @Override
    public boolean isTrueServer() {
        return false;
    }

    @Override
    public void loadKeyDefaultSettings() {
        MLN.keyVillageList = 47;
        MLN.keyInfoPanelList = 50;
        MLN.keyAggressiveEscorts = 34;
    }

    @Override
    public int loadKeySetting(String value) {
        return Keyboard.getKeyIndex((String)value.toUpperCase());
    }

    @Override
    public String getKeyString(int value) {
        return Keyboard.getKeyName((int)value);
    }

    @Override
    public void loadLanguages() {
        Minecraft minecraft = Minecraft.func_71410_x();
        MLN.loadLanguages(minecraft.field_71474_y.field_74363_ab);
    }

    @Override
    public void localTranslatedSentence(EntityPlayer player, char colour, String code, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = MLN.unknownString(values[i]);
        }
        this.sendLocalChat(player, colour, MLN.string(code, values));
    }

    @Override
    public String logPrefix() {
        return "CLIENT ";
    }

    @Override
    public void preloadTextures() {
    }

    @Override
    public void registerForgeClientClasses() {
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
        FMLCommonHandler.instance().bus().register((Object)new ClientReceiver());
    }

    @Override
    public void registerGraphics() {
        RenderingRegistry.registerEntityRenderingHandler(MillVillager.MLEntityGenericMale.class, (Render)new RenderMillVillager(new ModelBiped(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(MillVillager.MLEntityGenericAsymmFemale.class, (Render)new RenderMillVillager(new ModelFemaleAsymmetrical(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(MillVillager.MLEntityGenericSymmFemale.class, (Render)new RenderMillVillager(new ModelFemaleSymmetrical(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(MillVillager.MLEntityGenericZombie.class, (Render)new RenderBiped((ModelBiped)new ModelZombie(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityMillDecoration.class, (Render)new RenderWallDecoration());
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityMillChest.class, (String)"ml_TileEntityBuilding");
        GameRegistry.registerTileEntity(TileEntityPanel.class, (String)"ml_TileEntityPanel");
    }

    @Override
    public void sendChatAdmin(String s) {
        s = s.trim();
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
    }

    @Override
    public void sendChatAdmin(String s, EnumChatFormatting colour) {
        s = s.trim();
        ChatComponentText cc = new ChatComponentText(s);
        cc.func_150256_b().func_150238_a(colour);
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)cc);
    }

    @Override
    public void sendLocalChat(EntityPlayer player, char colour, String s) {
        s = s.trim();
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("\u00a7" + colour + s));
    }

    @Override
    public void setTextureIds() {
        Mill.normanArmourId = RenderingRegistry.addNewArmourRendererPrefix((String)"ML_norman");
        Mill.japaneseWarriorBlueArmourId = RenderingRegistry.addNewArmourRendererPrefix((String)"ML_japanese_warrior_blue");
        Mill.japaneseWarriorRedArmourId = RenderingRegistry.addNewArmourRendererPrefix((String)"ML_japanese_warrior_red");
        Mill.japaneseGuardArmourId = RenderingRegistry.addNewArmourRendererPrefix((String)"ML_japanese_guard");
        Mill.byzantineArmourId = RenderingRegistry.addNewArmourRendererPrefix((String)"ML_byzantine");
        Mill.mayanQuestArmourId = RenderingRegistry.addNewArmourRendererPrefix((String)"ML_mayan_quest");
    }

    @Override
    public void updateBowIcon(Goods.ItemMillenaireBow bow, EntityPlayer entityplayer) {
        MillClientUtilities.updateBowIcon(bow, entityplayer);
    }

    @Override
    public void declareAmuletTextures(IIconRegister iconRegister) {
        TextureMap textureMap = (TextureMap)iconRegister;
        textureMap.setTextureEntry("millenaire:amulet_alchemist" + MLN.getTextSuffix(), (TextureAtlasSprite)new TextureAmuletAlchemist("millenaire:amulet_alchemist" + MLN.getTextSuffix()));
        textureMap.setTextureEntry("millenaire:amulet_vishnu" + MLN.getTextSuffix(), (TextureAtlasSprite)new TextureAmuletVishnu("millenaire:amulet_vishnu" + MLN.getTextSuffix()));
        textureMap.setTextureEntry("millenaire:amulet_yggdrasil" + MLN.getTextSuffix(), (TextureAtlasSprite)new TextureAmuletYddrasil("millenaire:amulet_yggdrasil" + MLN.getTextSuffix()));
    }

    @Override
    public void initNetwork() {
        Mill.millChannel.register((Object)new ClientReceiver());
    }

    @Override
    public void refreshClientResources() {
        Minecraft.func_71410_x().func_110436_a();
    }
}

