/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import java.util.Vector;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.millenaire.common.Building;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.Point;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.forge.Mill;

public class BuildingLocation
implements Cloneable {
    public String key;
    public String shop;
    public Vector<String> maleResident;
    public Vector<String> femaleResident;
    public int priorityMoveIn = 10;
    public int minx;
    public int maxx;
    public int minz;
    public int maxz;
    public int minxMargin;
    public int maxxMargin;
    public int minzMargin;
    public int maxzMargin;
    public int orientation;
    public int length;
    public int width;
    public int areaToClear;
    public int level;
    public int reputation;
    public int price;
    private int variation;
    public Point pos;
    public Point chestPos = null;
    public Point sleepingPos = null;
    public Point sellingPos = null;
    public Point craftingPos = null;
    public Point shelterPos = null;
    public Point defendingPos = null;
    public Culture culture;
    public Vector<String> tags;
    public Vector<String> subBuildings;
    public boolean showTownHallSigns;
    public boolean upgradesAllowed = true;
    public boolean bedrocklevel = false;

    public static BuildingLocation read(NBTTagCompound nbttagcompound, String label, String debug) {
        NBTTagCompound nbttagcompound1;
        int i;
        String value;
        NBTTagCompound nbttagcompound12;
        int i2;
        NBTTagCompound nbttagcompound13;
        int i3;
        NBTTagCompound nbttagcompound14;
        int i4;
        Culture culture;
        if (!nbttagcompound.func_74764_b(label + "_key")) {
            return null;
        }
        BuildingLocation bl = new BuildingLocation();
        bl.pos = Point.read(nbttagcompound, label + "_pos");
        bl.culture = culture = Culture.getCultureByName(nbttagcompound.func_74779_i(label + "_culture"));
        bl.orientation = nbttagcompound.func_74762_e(label + "_orientation");
        bl.length = nbttagcompound.func_74762_e(label + "_length");
        bl.width = nbttagcompound.func_74762_e(label + "_width");
        bl.areaToClear = nbttagcompound.func_74762_e(label + "_areaToClear");
        bl.level = nbttagcompound.func_74762_e(label + "_level");
        bl.key = nbttagcompound.func_74779_i(label + "_key");
        bl.shop = nbttagcompound.func_74779_i(label + "_shop");
        if (Culture.oldShopConversion.containsKey(bl.shop)) {
            bl.shop = Culture.oldShopConversion.get(bl.shop);
        }
        bl.setVariation(nbttagcompound.func_74762_e(label + "_variation"));
        bl.reputation = nbttagcompound.func_74762_e(label + "_reputation");
        bl.priorityMoveIn = nbttagcompound.func_74762_e(label + "_priorityMoveIn");
        bl.price = nbttagcompound.func_74762_e(label + "_price");
        if (bl.pos == null) {
            MLN.error(null, "Null point loaded for: " + label + "_pos");
        }
        bl.sleepingPos = Point.read(nbttagcompound, label + "_standingPos");
        bl.sellingPos = Point.read(nbttagcompound, label + "_sellingPos");
        bl.craftingPos = Point.read(nbttagcompound, label + "_craftingPos");
        bl.shelterPos = Point.read(nbttagcompound, label + "_shelterPos");
        bl.defendingPos = Point.read(nbttagcompound, label + "_defendingPos");
        bl.chestPos = Point.read(nbttagcompound, label + "_chestPos");
        Vector<String> maleResident = new Vector<String>();
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("maleResidentList", 10);
        for (i4 = 0; i4 < nbttaglist.func_74745_c(); ++i4) {
            nbttagcompound14 = nbttaglist.func_150305_b(i4);
            maleResident.add(nbttagcompound14.func_74779_i("value"));
        }
        nbttaglist = nbttagcompound.func_150295_c(label + "_maleResidentList", 10);
        for (i4 = 0; i4 < nbttaglist.func_74745_c(); ++i4) {
            nbttagcompound14 = nbttaglist.func_150305_b(i4);
            maleResident.add(nbttagcompound14.func_74779_i("value"));
        }
        String s = nbttagcompound.func_74779_i(label + "_maleResident");
        if (s != null && s.length() > 0) {
            maleResident.add(s);
        }
        bl.maleResident = maleResident;
        Vector<String> femaleResident = new Vector<String>();
        nbttaglist = nbttagcompound.func_150295_c("femaleResidentList", 10);
        for (i3 = 0; i3 < nbttaglist.func_74745_c(); ++i3) {
            nbttagcompound13 = nbttaglist.func_150305_b(i3);
            femaleResident.add(nbttagcompound13.func_74779_i("value"));
        }
        nbttaglist = nbttagcompound.func_150295_c(label + "_femaleResidentList", 10);
        for (i3 = 0; i3 < nbttaglist.func_74745_c(); ++i3) {
            nbttagcompound13 = nbttaglist.func_150305_b(i3);
            femaleResident.add(nbttagcompound13.func_74779_i("value"));
        }
        s = nbttagcompound.func_74779_i(label + "_femaleResident");
        if (s != null && s.length() > 0) {
            femaleResident.add(s);
        }
        bl.femaleResident = femaleResident;
        Vector<String> tags = new Vector<String>();
        nbttaglist = nbttagcompound.func_150295_c("tags", 10);
        for (i2 = 0; i2 < nbttaglist.func_74745_c(); ++i2) {
            nbttagcompound12 = nbttaglist.func_150305_b(i2);
            value = nbttagcompound12.func_74779_i("value").toLowerCase();
            if (value.equals("market1") || value.equals("market2") || value.equals("market3")) {
                tags.add("market");
                continue;
            }
            tags.add(value);
        }
        nbttaglist = nbttagcompound.func_150295_c(label + "_tags", 10);
        for (i2 = 0; i2 < nbttaglist.func_74745_c(); ++i2) {
            nbttagcompound12 = nbttaglist.func_150305_b(i2);
            value = nbttagcompound12.func_74779_i("value");
            tags.add(value);
        }
        bl.tags = tags;
        Vector<String> subb = new Vector<String>();
        nbttaglist = nbttagcompound.func_150295_c("subBuildings", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            subb.add(nbttagcompound1.func_74779_i("value"));
        }
        nbttaglist = nbttagcompound.func_150295_c(label + "_subBuildings", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = nbttaglist.func_150305_b(i);
            subb.add(nbttagcompound1.func_74779_i("value"));
        }
        bl.subBuildings = subb;
        bl.showTownHallSigns = nbttagcompound.func_74767_n(label + "_showTownHallSigns");
        if (nbttagcompound.func_74764_b(label + "_upgradesAllowed")) {
            bl.upgradesAllowed = nbttagcompound.func_74767_n(label + "_upgradesAllowed");
        }
        if (bl.getPlan() == null) {
            MLN.error(bl, "Unknown building type. Cancelling load.");
            return null;
        }
        bl.initialise();
        return bl;
    }

    public BuildingLocation() {
    }

    public BuildingLocation(BuildingPlan plan, Point ppos, int porientation) {
        this.pos = ppos;
        if (this.pos == null) {
            MLN.error(this, "Attempting to create a location with a null position.");
        }
        this.orientation = porientation;
        this.length = plan.length;
        this.width = plan.width;
        this.key = plan.buildingKey;
        this.level = plan.level;
        this.tags = plan.tags;
        this.subBuildings = plan.subBuildings;
        this.setVariation(plan.variation);
        this.maleResident = plan.maleResident;
        this.femaleResident = plan.femaleResident;
        this.shop = plan.shop;
        this.reputation = plan.reputation;
        this.price = plan.price;
        this.showTownHallSigns = plan.showTownHallSigns;
        this.culture = plan.culture;
        this.priorityMoveIn = plan.priorityMoveIn;
        this.initialise();
    }

    public BuildingLocation clone() {
        try {
            BuildingLocation bl = (BuildingLocation)super.clone();
            return bl;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BuildingLocation createLocationForLevel(int plevel) {
        BuildingPlan plan = this.culture.getBuildingPlanSet((String)this.key).plans.get(this.getVariation())[plevel];
        BuildingLocation bl = this.clone();
        bl.level = plevel;
        bl.tags = plan.tags;
        bl.subBuildings = plan.subBuildings;
        return bl;
    }

    public BuildingLocation createLocationForStartingSubBuilding(String subkey) {
        BuildingLocation bl = this.createLocationForSubBuilding(subkey);
        bl.level = 0;
        return bl;
    }

    public BuildingLocation createLocationForSubBuilding(String subkey) {
        BuildingPlan plan = this.culture.getBuildingPlanSet(subkey).getRandomStartingPlan();
        BuildingLocation bl = this.clone();
        bl.key = subkey;
        bl.level = -1;
        bl.tags = plan.tags;
        bl.subBuildings = plan.subBuildings;
        bl.maleResident = plan.maleResident;
        bl.femaleResident = plan.femaleResident;
        bl.shop = plan.shop;
        bl.reputation = plan.reputation;
        bl.price = plan.price;
        bl.showTownHallSigns = plan.showTownHallSigns;
        return bl;
    }

    public Building getBuilding(World world) {
        return Mill.getMillWorld(world).getBuilding(this.chestPos);
    }

    public Vector<String> getBuildingEffects(World world) {
        BuildingPlan plan;
        Vector<String> effects = new Vector<String>();
        Building building = this.getBuilding(world);
        if (building != null && building.isTownhall) {
            effects.add(MLN.string("effect.towncentre"));
        }
        if (this.shop != null && this.shop.length() > 0) {
            effects.add(MLN.string("effect.shop", this.culture.getCultureString("shop." + this.shop)));
        }
        if (this.tags.contains("pujas")) {
            effects.add(MLN.string("effect.pujalocation"));
        }
        if (this.tags.contains("sacrifices")) {
            effects.add(MLN.string("effect.sacrificeslocation"));
        }
        if ((plan = this.getPlan()) != null && plan.irrigation > 0) {
            effects.add(MLN.string("effect.irrigation", "" + plan.irrigation));
        }
        if (building != null && building.healingspots.size() > 0) {
            effects.add(MLN.string("effect.healing"));
        }
        return effects;
    }

    public Point[] getCorners() {
        Point[] corners = new Point[]{new Point(this.minxMargin, this.pos.getiY(), this.minzMargin), new Point(this.maxxMargin, this.pos.getiY(), this.minzMargin), new Point(this.minxMargin, this.pos.getiY(), this.maxzMargin), new Point(this.maxxMargin, this.pos.getiY(), this.maxzMargin)};
        return corners;
    }

    public BuildingPlan getPlan() {
        if (this.culture == null) {
            MLN.error(this, "null culture");
            return null;
        }
        if (this.culture.getBuildingPlanSet(this.key) != null && this.culture.getBuildingPlanSet((String)this.key).plans.size() > this.getVariation()) {
            if (this.level < 0) {
                return this.culture.getBuildingPlanSet((String)this.key).plans.get(this.getVariation())[0];
            }
            if (this.culture.getBuildingPlanSet((String)this.key).plans.get(this.getVariation()).length > this.level) {
                return this.culture.getBuildingPlanSet((String)this.key).plans.get(this.getVariation())[this.level];
            }
            return null;
        }
        return null;
    }

    public Point getSellingPos() {
        if (this.sellingPos != null) {
            return this.sellingPos;
        }
        return this.sleepingPos;
    }

    public int getVariation() {
        return this.variation;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void initialise() {
        Point op1 = BuildingPlan.adjustForOrientation(this.pos.getiX(), this.pos.getiY(), this.pos.getiZ(), this.length / 2, this.width / 2, this.orientation);
        Point op2 = BuildingPlan.adjustForOrientation(this.pos.getiX(), this.pos.getiY(), this.pos.getiZ(), -this.length / 2, -this.width / 2, this.orientation);
        if (op1.getiX() > op2.getiX()) {
            this.minx = op2.getiX();
            this.maxx = op1.getiX();
        } else {
            this.minx = op1.getiX();
            this.maxx = op2.getiX();
        }
        if (op1.getiZ() > op2.getiZ()) {
            this.minz = op2.getiZ();
            this.maxz = op1.getiZ();
        } else {
            this.minz = op1.getiZ();
            this.maxz = op2.getiZ();
        }
        this.minxMargin = this.minx - (this.areaToClear + MLN.minDistanceBetweenBuildings);
        this.minzMargin = this.minz - (this.areaToClear + MLN.minDistanceBetweenBuildings);
        this.maxxMargin = this.maxx + this.areaToClear + MLN.minDistanceBetweenBuildings;
        this.maxzMargin = this.maxz + this.areaToClear + MLN.minDistanceBetweenBuildings;
    }

    public boolean intersectWith(BuildingLocation b) {
        return this.minxMargin <= b.maxxMargin && this.maxxMargin >= b.minxMargin && this.minzMargin <= b.maxzMargin && this.maxzMargin >= b.minzMargin;
    }

    public boolean isInside(Point p) {
        return this.minx < p.getiX() && p.getiX() <= this.maxx && this.minz < p.getiZ() && p.getiZ() <= this.maxz;
    }

    public boolean isInsideZone(Point p) {
        return this.minxMargin <= p.getiX() && p.getiX() <= this.maxxMargin && this.minzMargin <= p.getiZ() && p.getiZ() <= this.maxzMargin;
    }

    public boolean isLocationSamePlace(BuildingLocation l) {
        if (l == null) {
            return false;
        }
        return this.pos.equals(l.pos) && this.orientation == l.orientation && this.getVariation() == l.getVariation();
    }

    public boolean isSameLocation(BuildingLocation l) {
        if (l == null) {
            return false;
        }
        return this.pos.equals(l.pos) && this.key.equals(l.key) && this.orientation == l.orientation && this.getVariation() == l.getVariation();
    }

    public int oldHashCode() {
        return super.hashCode();
    }

    public void setVariation(int var) {
        this.variation = var;
    }

    public String toString() {
        return this.key + "_" + this.level + " at " + this.pos + "/" + this.orientation + "/" + this.getVariation();
    }

    public void write(NBTTagCompound nbttagcompound, String label, String debug) {
        NBTTagCompound nbttagcompound1;
        this.pos.write(nbttagcompound, label + "_pos");
        nbttagcompound.func_74778_a(label + "_culture", this.culture.key);
        nbttagcompound.func_74768_a(label + "_orientation", this.orientation);
        nbttagcompound.func_74768_a(label + "_length", this.length);
        nbttagcompound.func_74768_a(label + "_width", this.width);
        nbttagcompound.func_74768_a(label + "_areaToClear", this.areaToClear);
        nbttagcompound.func_74768_a(label + "_level", this.level);
        nbttagcompound.func_74778_a(label + "_key", this.key);
        nbttagcompound.func_74768_a(label + "_variation", this.getVariation());
        nbttagcompound.func_74768_a(label + "_reputation", this.reputation);
        nbttagcompound.func_74768_a(label + "_price", this.price);
        nbttagcompound.func_74768_a(label + "_priorityMoveIn", this.priorityMoveIn);
        if (this.shop != null && this.shop.length() > 0) {
            nbttagcompound.func_74778_a(label + "_shop", this.shop);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (String tag : this.maleResident) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("value", tag);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a(label + "_maleResidentList", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (String tag : this.femaleResident) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("value", tag);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a(label + "_femaleResidentList", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (String tag : this.tags) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("value", tag);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a(label + "_tags", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (String subb : this.subBuildings) {
            nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("value", subb);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a(label + "_subBuildings", (NBTBase)nbttaglist);
        if (this.sleepingPos != null) {
            this.sleepingPos.write(nbttagcompound, label + "_standingPos");
        }
        if (this.sellingPos != null) {
            this.sellingPos.write(nbttagcompound, label + "_sellingPos");
        }
        if (this.craftingPos != null) {
            this.craftingPos.write(nbttagcompound, label + "_craftingPos");
        }
        if (this.defendingPos != null) {
            this.defendingPos.write(nbttagcompound, label + "_defendingPos");
        }
        if (this.shelterPos != null) {
            this.shelterPos.write(nbttagcompound, label + "_shelterPos");
        }
        if (this.chestPos != null) {
            this.chestPos.write(nbttagcompound, label + "_chestPos");
        }
        nbttagcompound.func_74757_a(label + "_showTownHallSigns", this.showTownHallSigns);
        nbttagcompound.func_74757_a(label + "_upgradesAllowed", this.upgradesAllowed);
    }
}

