/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.MathHelper;
import org.millenaire.client.MillClientUtilities;
import org.millenaire.common.Building;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.VillageType;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.network.StreamReadWrite;

public class TileEntityPanel
extends TileEntitySign {
    public static final int VILLAGE_MAP = 1;
    public static final int etatCivil = 1;
    public static final int constructions = 2;
    public static final int projects = 3;
    public static final int controlledProjects = 4;
    public static final int house = 5;
    public static final int resources = 6;
    public static final int archives = 7;
    public static final int villageMap = 8;
    public static final int military = 9;
    public static final int tradeGoods = 10;
    public static final int innVisitors = 11;
    public static final int marketMerchants = 12;
    public static final int controlledMilitary = 13;
    public Point buildingPos = null;
    public long villager_id = 0L;
    public int panelType = 0;

    private static void addProjectToList(EntityPlayer player, BuildingProject project, Building townHall, Vector<String> page) {
        if (project.location == null || project.location.level < 0) {
            BuildingPlan plan = project.planSet.getRandomStartingPlan();
            page.add(plan.getNativeDisplayName(player) + ": " + MLN.string("panels.notyetbuilt") + ".");
        } else if (project.location.level + 1 < project.getLevelsNumber(project.location.getVariation())) {
            BuildingPlan plan = project.getPlan(project.location.getVariation(), project.location.level + 1);
            BuildingLocation l = project.location;
            page.add(plan.getNativeDisplayName(player) + " (" + MathHelper.func_76128_c((double)l.pos.distanceTo(townHall.getPos())) + "m " + townHall.getPos().directionToShort(l.pos) + "): " + MLN.string("panels.nbupgradesleft", "" + (project.getLevelsNumber(project.location.getVariation()) - project.location.level - 1)));
        } else {
            BuildingPlan plan = project.getPlan(project.location.getVariation(), project.location.level);
            BuildingLocation l = project.location;
            page.add(plan.getNativeDisplayName(player) + " (" + MathHelper.func_76128_c((double)l.pos.distanceTo(townHall.getPos())) + "m " + townHall.getPos().directionToShort(l.pos) + "): " + MLN.string("panels.finished") + ".");
        }
    }

    public static Vector<Vector<String>> generateArchives(EntityPlayer player, Building townHall, long villager_id) {
        if (townHall == null) {
            return null;
        }
        VillagerRecord vr = townHall.getVillagerRecordById(villager_id);
        if (vr == null) {
            return null;
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add(vr.getName());
        page.add(vr.getGameOccupation(player.getDisplayName()));
        page.add("");
        if (vr.mothersName != null && vr.mothersName.length() > 0) {
            page.add(MLN.string("panels.mother") + ": " + vr.mothersName);
        }
        if (vr.fathersName != null && vr.fathersName.length() > 0) {
            page.add(MLN.string("panels.father") + ": " + vr.fathersName);
        }
        if (vr.spousesName != null && vr.spousesName.length() > 0) {
            page.add(MLN.string("panels.spouse") + ": " + vr.spousesName);
        }
        page.add("");
        MillVillager villager = null;
        for (MillVillager v : townHall.villagers) {
            if (v.villager_id != vr.id) continue;
            villager = v;
        }
        page.add("");
        if (villager == null) {
            if (vr.killed) {
                page.add(MLN.string("panels.dead"));
            } else if (vr.awayraiding) {
                page.add(MLN.string("panels.awayraiding"));
            } else if (vr.awayraiding) {
                page.add(MLN.string("panels.awayhired"));
            } else if (vr.raidingVillage && townHall.worldObj.func_72820_D() < vr.raiderSpawn + 500L) {
                page.add(MLN.string("panels.invaderincoming"));
            } else {
                page.add(MLN.string("panels.missing"));
            }
        } else {
            String occupation = "";
            if (villager.goalKey != null && Goal.goals.containsKey(villager.goalKey)) {
                occupation = Goal.goals.get(villager.goalKey).gameName(villager);
            }
            page.add(MLN.string("panels.currentoccupation") + ": " + occupation);
        }
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateConstructions(EntityPlayer player, Building townHall) {
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.constructions") + " : " + townHall.getVillageQualifiedName());
        page.add("");
        for (Vector<BuildingProject> projectsLevel : townHall.buildingProjects) {
            for (BuildingProject project : projectsLevel) {
                if (project.location == null) continue;
                String level = null;
                if (project.location.level < 0) {
                    level = MLN.string("ui.notyetbuilt");
                }
                if (project.location.level > 0) {
                    level = MLN.string("panels.upgrade") + " " + project.location.level;
                }
                Vector<String> effects = project.location.getBuildingEffects(townHall.worldObj);
                String effect = null;
                if (effects.size() > 0) {
                    effect = "";
                    for (String s : effects) {
                        if (effect.length() > 0) {
                            effect = effect + ", ";
                        }
                        effect = effect + s;
                    }
                }
                page.add(project.location.getPlan().getNativeDisplayName(player) + ": " + MathHelper.func_76128_c((double)project.location.pos.distanceTo(townHall.getPos())) + "m " + townHall.getPos().directionToShort(project.location.pos));
                if (level != null) {
                    page.add(level);
                }
                if (effect != null) {
                    page.add(effect);
                }
                page.add("");
            }
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateEtatCivil(EntityPlayer player, Building townHall) {
        if (townHall == null) {
            return null;
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        Vector<String> visitorsPage = new Vector<String>();
        page.add(MLN.string("ui.population") + " " + townHall.getVillageQualifiedName());
        page.add("");
        visitorsPage.add(MLN.string("panels.visitors") + ":");
        visitorsPage.add("");
        for (VillagerRecord vr : townHall.vrecords) {
            int nbFound = 0;
            boolean belongsToVillage = true;
            for (MillVillager villager : townHall.villagers) {
                if (villager.villager_id != vr.id) continue;
                ++nbFound;
                belongsToVillage = !villager.isVisitor();
            }
            String error = "";
            if (nbFound == 0) {
                Building thServer;
                error = vr.killed ? " (" + MLN.string("panels.dead").toLowerCase() + ")" : (vr.awayraiding ? " (" + MLN.string("panels.awayraiding").toLowerCase() + ")" : (vr.awayhired ? " (" + MLN.string("panels.awayhired").toLowerCase() + ")" : (vr.raidingVillage && townHall.worldObj.func_72820_D() < vr.raiderSpawn + 500L ? " (" + MLN.string("panels.invaderincoming").toLowerCase() + ")" : (vr.raidingVillage ? " (" + MLN.string("panels.raider").toLowerCase() + ")" : " (" + MLN.string("panels.missing").toLowerCase() + ")"))));
                if (MLN.DEV && Mill.serverWorlds.size() > 0 && (thServer = Mill.serverWorlds.get(0).getBuilding(townHall.getPos())) != null) {
                    int nbOnServer = 0;
                    for (MillVillager villager : thServer.villagers) {
                        if (villager.villager_id != vr.id) continue;
                        ++nbOnServer;
                    }
                    error = error + " nbOnServer:" + nbOnServer;
                }
            } else if (nbFound > 1) {
                error = " (" + MLN.string("panels.multiple", "" + nbFound).toLowerCase() + ")";
            }
            if (belongsToVillage) {
                page.add(vr.getName() + ", " + vr.getGameOccupation(player.getDisplayName()).toLowerCase() + error);
                continue;
            }
            visitorsPage.add(vr.getName() + ", " + vr.getGameOccupation(player.getDisplayName()).toLowerCase() + error);
        }
        if (MLN.DEV && Mill.serverWorlds.size() > 0) {
            int nbClient = MillCommonUtilities.getEntitiesWithinAABB(townHall.worldObj, MillVillager.class, townHall.getPos(), 64, 16).size();
            Building thServer = Mill.serverWorlds.get(0).getBuilding(townHall.getPos());
            int nbServer = MillCommonUtilities.getEntitiesWithinAABB(thServer.worldObj, MillVillager.class, townHall.getPos(), 64, 16).size();
            page.add("Client: " + nbClient + ", server: " + nbServer);
        }
        text.add(page);
        text.add(visitorsPage);
        return text;
    }

    public static Vector<Vector<String>> generateHouse(EntityPlayer player, Building house) {
        Vector<String> page = new Vector<String>();
        page.add("House : " + house.getNativeBuildingName());
        page.add("");
        VillagerRecord wife = null;
        VillagerRecord husband = null;
        for (VillagerRecord vr : house.vrecords) {
            if (vr.gender == 2 && !vr.getType().isChild) {
                wife = vr;
            }
            if (vr.gender != 1 || vr.getType().isChild) continue;
            husband = vr;
        }
        if (wife == null && husband == null) {
            page.add(MLN.string("panels.houseunoccupied"));
        } else if (wife == null) {
            page.add(MLN.string("panels.man") + ": " + husband.getName() + ", " + husband.getGameOccupation(player.getDisplayName()));
            page.add("");
            if (house.location.femaleResident.size() == 0) {
                page.add(MLN.string("panels.nofemaleresident"));
            } else {
                page.add(MLN.string("panels.bachelor"));
            }
        } else if (husband == null) {
            page.add(MLN.string("panels.woman") + ": " + wife.getName() + ", " + wife.getGameOccupation(player.getDisplayName()));
            page.add("");
            if (house.location.maleResident == null || house.location.maleResident.size() == 0) {
                page.add(MLN.string("panels.nomaleresident"));
            } else {
                page.add(MLN.string("panels.spinster"));
            }
        } else {
            page.add(MLN.string("panels.woman") + ": " + wife.getName() + ", " + wife.getGameOccupation(player.getDisplayName()).toLowerCase());
            page.add(MLN.string("panels.man") + ": " + husband.getName() + ", " + husband.getGameOccupation(player.getDisplayName()).toLowerCase());
            if (house.vrecords.size() > 2) {
                page.add("");
                page.add(MLN.string("panels.children") + ":");
                page.add("");
                for (VillagerRecord vr : house.vrecords) {
                    if (!vr.getType().isChild) continue;
                    page.add(vr.getName() + ", " + vr.getGameOccupation(player.getDisplayName()).toLowerCase());
                }
            }
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateInnVisitors(Building house) {
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.innvisitors", house.getNativeBuildingName()) + ":");
        page.add("");
        for (int i = house.visitorsList.size() - 1; i > -1; --i) {
            String s = house.visitorsList.get(i);
            if (s.split(";").length > 1) {
                MillVillager.InvItem iv;
                int j;
                String taken;
                String[] v;
                if (s.startsWith("storedexports;")) {
                    v = s.split(";");
                    taken = "";
                    for (j = 2; j < v.length; ++j) {
                        iv = new MillVillager.InvItem(v[j]);
                        if (taken.length() > 0) {
                            taken = taken + ", ";
                        }
                        taken = taken + iv.getName() + ": " + v[j].split("/")[2];
                    }
                    page.add(MLN.string("panels.storedexports", v[1], taken));
                } else if (s.startsWith("broughtimport;")) {
                    v = s.split(";");
                    taken = "";
                    for (j = 2; j < v.length; ++j) {
                        iv = new MillVillager.InvItem(v[j]);
                        if (taken.length() > 0) {
                            taken = taken + ", ";
                        }
                        taken = taken + iv.getName() + ": " + v[j].split("/")[2];
                    }
                    page.add(MLN.string("panels.broughtimport", v[1], taken));
                } else {
                    page.add(MLN.string(s.split(";")));
                }
            } else {
                page.add(s);
            }
            page.add("");
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateMarketGoods(Building house) {
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.goodstraded") + ":");
        page.add("");
        page.add(MLN.string("panels.goodsimported") + ":");
        page.add("");
        for (MillVillager.InvItem good : house.imported.keySet()) {
            page.add(good.getName() + ": " + house.imported.get(good));
        }
        page.add("");
        page.add(MLN.string("panels.goodsexported") + ":");
        page.add("");
        for (MillVillager.InvItem good : house.exported.keySet()) {
            page.add(good.getName() + ": " + house.exported.get(good));
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateMarketMerchants(Building market) {
        if (market == null) {
            return null;
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.merchantlist") + ": ");
        page.add("(" + MLN.string("panels.capacity") + ": " + market.stalls.size() + ")");
        page.add("");
        for (VillagerRecord vr : market.vrecords) {
            MillVillager v = null;
            for (MillVillager av : market.villagers) {
                if (!vr.matches(av)) continue;
                v = av;
            }
            page.add(vr.getName());
            if (v == null) {
                if (vr.killed) {
                    page.add(MLN.string("panels.dead"));
                    continue;
                }
                page.add(MLN.string("panels.missing"));
                continue;
            }
            page.add(v.getNativeOccupationName());
            page.add(MLN.string("panels.nbnightsin", "" + v.foreignMerchantNbNights));
            page.add("");
        }
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateMilitary(EntityPlayer player, Building townHall) {
        MillVillager.InvItem iv;
        String taken;
        String[] v;
        String s;
        Item bestMelee;
        String weapon;
        String status;
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.military") + " : " + townHall.getVillageQualifiedName());
        page.add("");
        int nbAttackers = 0;
        Point attackingVillagePos = null;
        if (townHall.raidTarget != null) {
            Building target = Mill.clientWorld.getBuilding(townHall.raidTarget);
            if (target != null) {
                if (townHall.raidStart > 0L) {
                    page.add(MLN.string("panels.raidinprogresslong", target.getVillageQualifiedName(), "" + Math.round((townHall.worldObj.func_72820_D() - townHall.raidStart) / 1000L)));
                } else {
                    page.add(MLN.string("panels.planningraidlong", target.getVillageQualifiedName(), "" + Math.round((townHall.worldObj.func_72820_D() - townHall.raidPlanningStart) / 1000L)));
                }
                page.add("");
            }
        } else {
            for (VillagerRecord vr : townHall.vrecords) {
                if (!vr.raidingVillage) continue;
                ++nbAttackers;
                attackingVillagePos = vr.originalVillagePos;
            }
            if (nbAttackers > 0) {
                Building attackingVillage = Mill.clientWorld.getBuilding(attackingVillagePos);
                String attackedBy = attackingVillage != null ? attackingVillage.getVillageQualifiedName() : MLN.string("panels.unknownattacker");
                page.add(MLN.string("panels.underattacklong", "" + nbAttackers, "" + townHall.getVillageAttackerStrength(), attackedBy));
                page.add("");
            }
        }
        page.add(MLN.string("panels.offenselong", "" + townHall.getVillageRaidingStrength()));
        page.add(MLN.string("panels.defenselong", "" + townHall.getVillageDefendingStrength()));
        text.add(page);
        page = new Vector();
        page.add(MLN.string("panels.villagefighters"));
        page.add("");
        for (VillagerRecord vr : townHall.vrecords) {
            if (!vr.getType().isRaider && !vr.getType().helpInAttacks || vr.raidingVillage) continue;
            status = "";
            if (vr.getType().helpInAttacks) {
                status = status + MLN.string("panels.defender");
            }
            if (vr.getType().isRaider) {
                if (status.length() > 0) {
                    status = status + ", ";
                }
                status = status + MLN.string("panels.raider");
            }
            if (vr.awayraiding) {
                status = status + ", " + MLN.string("panels.awayraiding");
            } else if (vr.awayhired) {
                status = status + ", " + MLN.string("panels.awayhired");
            } else if (vr.raidingVillage && townHall.worldObj.func_72820_D() < vr.raiderSpawn + 500L) {
                status = status + ", " + MLN.string("panels.invaderincoming");
            } else if (vr.killed) {
                status = status + ", " + MLN.string("panels.dead");
            }
            weapon = "";
            bestMelee = vr.getBestMeleeWeapon();
            if (bestMelee != null) {
                weapon = Mill.proxy.getItemName(bestMelee, 0);
            }
            if (vr.getType().isArcher && vr.countInv((Item)Items.field_151031_f) > 0) {
                if (weapon.length() > 0) {
                    weapon = weapon + ", ";
                }
                weapon = weapon + Mill.proxy.getItemName((Item)Items.field_151031_f, 0);
            }
            page.add(vr.getName() + ", " + vr.getGameOccupation(player.getDisplayName()));
            page.add(status);
            page.add(MLN.string("panels.health") + ": " + vr.getMaxHealth() + ", " + MLN.string("panels.armour") + ": " + vr.getTotalArmorValue() + ", " + MLN.string("panels.weapons") + ": " + weapon + ", " + MLN.string("panels.militarystrength") + ": " + vr.getMilitaryStrength());
            page.add("");
        }
        text.add(page);
        if (nbAttackers > 0) {
            page = new Vector();
            page.add(MLN.string("panels.attackers"));
            page.add("");
            for (VillagerRecord vr : townHall.vrecords) {
                if (!vr.raidingVillage) continue;
                status = "";
                if (vr.killed) {
                    status = MLN.string("panels.dead");
                }
                weapon = "";
                bestMelee = vr.getBestMeleeWeapon();
                if (bestMelee != null) {
                    weapon = Mill.proxy.getItemName(bestMelee, 0);
                }
                if (vr.getType().isArcher && vr.countInv((Item)Items.field_151031_f) > 0) {
                    if (weapon.length() > 0) {
                        weapon = weapon + ", ";
                    }
                    weapon = weapon + Mill.proxy.getItemName((Item)Items.field_151031_f, 0);
                }
                page.add(vr.getName() + ", " + vr.getGameOccupation(player.getDisplayName()));
                page.add(status);
                page.add(MLN.string("panels.health") + ": " + vr.getMaxHealth() + ", " + MLN.string("panels.armour") + ": " + vr.getTotalArmorValue() + ", " + MLN.string("panels.weapons") + ": " + weapon + ", " + MLN.string("panels.militarystrength") + ": " + vr.getMilitaryStrength());
                page.add("");
            }
            text.add(page);
        }
        if (townHall.raidsPerformed.size() > 0) {
            page = new Vector();
            page.add(MLN.string("panels.raidsperformed"));
            page.add("");
            for (int i = townHall.raidsPerformed.size() - 1; i >= 0; --i) {
                s = townHall.raidsPerformed.get(i);
                if (s.split(";").length > 1) {
                    if (s.split(";")[0].equals("failure")) {
                        page.add(MLN.string("raid.historyfailure", s.split(";")[1]));
                    } else {
                        v = s.split(";");
                        taken = "";
                        for (int j = 2; j < v.length; ++j) {
                            iv = new MillVillager.InvItem(v[j]);
                            if (taken.length() > 0) {
                                taken = taken + ", ";
                            }
                            taken = taken + iv.getName() + ": " + v[j].split("/")[2];
                        }
                        if (taken.length() == 0) {
                            taken = MLN.string("raid.nothing");
                        }
                        page.add(MLN.string("raid.historysuccess", s.split(";")[1], taken));
                    }
                } else {
                    page.add(townHall.raidsPerformed.get(i));
                }
                page.add("");
            }
            text.add(page);
        }
        if (townHall.raidsSuffered.size() > 0) {
            page = new Vector();
            page.add(MLN.string("panels.raidssuffered"));
            page.add("");
            for (int i = townHall.raidsSuffered.size() - 1; i >= 0; --i) {
                s = townHall.raidsSuffered.get(i);
                if (s.split(";").length > 1) {
                    if (s.split(";")[0].equals("failure")) {
                        page.add(MLN.string("raid.historydefended", s.split(";")[1]));
                    } else {
                        v = s.split(";");
                        taken = "";
                        for (int j = 2; j < v.length; ++j) {
                            iv = new MillVillager.InvItem(v[j]);
                            if (taken.length() > 0) {
                                taken = taken + ", ";
                            }
                            taken = taken + iv.getName() + ": " + v[j].split("/")[2];
                        }
                        if (taken.length() == 0) {
                            taken = MLN.string("raid.nothing");
                        }
                        page.add(MLN.string("raid.historyraided", s.split(";")[1], taken));
                    }
                } else {
                    page.add(townHall.raidsSuffered.get(i));
                }
                page.add("");
            }
            text.add(page);
        }
        return text;
    }

    public static Vector<Vector<String>> generateProjects(EntityPlayer player, Building townHall) {
        if (townHall.villageType == null) {
            return null;
        }
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("panels.buildingprojects") + " : " + townHall.getVillageQualifiedName());
        page.add("");
        for (int i = 0; i < townHall.buildingProjects.size(); ++i) {
            if (townHall.villageType.playerControlled && i != 0 && i != 1 && i != 3) continue;
            Vector<BuildingProject> projectsLevel = townHall.buildingProjects.get(i);
            page.add(VillageType.levelNames[i] + ":");
            page.add("");
            for (BuildingProject project : projectsLevel) {
                if (!townHall.isDisplayableProject(project)) continue;
                TileEntityPanel.addProjectToList(player, project, townHall, page);
            }
            page.add("");
        }
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateSummary(EntityPlayer player, Building townHall) {
        String status;
        Vector<String> page = new Vector<String>();
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        page.add(MLN.string("panels.villagesummary") + ": " + townHall.getVillageQualifiedName());
        page.add("");
        int nbMen = 0;
        int nbFemale = 0;
        int nbGrownBoy = 0;
        int nbGrownGirl = 0;
        int nbBoy = 0;
        int nbGirl = 0;
        for (VillagerRecord vr : townHall.vrecords) {
            boolean belongsToVillage = vr.getType() != null && !vr.getType().visitor && !vr.raidingVillage;
            if (!belongsToVillage) continue;
            if (!vr.getType().isChild) {
                if (vr.gender == 1) {
                    ++nbMen;
                    continue;
                }
                ++nbFemale;
                continue;
            }
            if (vr.villagerSize == 20) {
                if (vr.gender == 1) {
                    ++nbGrownBoy;
                    continue;
                }
                ++nbGrownGirl;
                continue;
            }
            if (vr.gender == 1) {
                ++nbBoy;
                continue;
            }
            ++nbGirl;
        }
        page.add(MLN.string("ui.populationnumber", "" + (nbMen + nbFemale + nbGrownBoy + nbGrownGirl + nbBoy + nbGirl)));
        page.add(MLN.string("ui.adults", "" + (nbMen + nbFemale), "" + nbMen, "" + nbFemale));
        page.add(MLN.string("ui.teens", "" + (nbGrownBoy + nbGrownGirl), "" + nbGrownBoy, "" + nbGrownGirl));
        page.add(MLN.string("ui.children", "" + (nbBoy + nbGirl), "" + nbBoy, "" + nbGirl));
        page.add("");
        if (townHall.buildingGoal == null) {
            page.add(MLN.string("ui.goalscompleted1") + " " + MLN.string("ui.goalscompleted2"));
        } else {
            BuildingPlan goal = townHall.getCurrentGoalBuildingPlan();
            status = townHall.buildingLocationIP != null && townHall.buildingLocationIP.key.equals(townHall.buildingGoal) ? (townHall.buildingLocationIP.level == 0 ? MLN.string("ui.inconstruction") : MLN.string("ui.upgrading", "" + townHall.buildingLocationIP.level)) : MLN.string(townHall.buildingGoalIssue);
            page.add(MLN.string("panels.buildingproject") + " " + goal.nativeName + " " + goal.getGameName() + ": " + status);
            Vector<MillVillager.InvItem> res = new Vector<MillVillager.InvItem>();
            HashMap<MillVillager.InvItem, Integer> resCost = new HashMap<MillVillager.InvItem, Integer>();
            HashMap<MillVillager.InvItem, Integer> resHas = new HashMap<MillVillager.InvItem, Integer>();
            for (MillVillager.InvItem key : goal.resCost.keySet()) {
                res.add(key);
                resCost.put(key, goal.resCost.get(key));
                int has = townHall.countGoods(key.getItem(), key.meta);
                if (townHall.builder != null && townHall.buildingLocationIP != null && townHall.buildingLocationIP.key.equals(townHall.buildingGoal)) {
                    has += townHall.builder.countInv(key.getItem(), key.meta);
                }
                if (has > goal.resCost.get(key)) {
                    has = goal.resCost.get(key);
                }
                resHas.put(key, has);
            }
            page.add("");
            page.add(MLN.string("panels.resourcesneeded") + ":");
            page.add("");
            Collections.sort(res, new MillVillager.InvItemAlphabeticalComparator());
            for (int i = 0; i < res.size(); ++i) {
                page.add(((MillVillager.InvItem)res.get(i)).getName() + ": " + resHas.get(res.get(i)) + "/" + resCost.get(res.get(i)));
            }
        }
        page.add("");
        page.add(MLN.string("panels.currentconstruction"));
        if (townHall.buildingLocationIP == null) {
            page.add(MLN.string("ui.noconstruction1") + " " + MLN.string("ui.noconstruction2"));
        } else {
            String loc;
            String planName = townHall.culture.getBuildingPlanSet(townHall.buildingLocationIP.key).getNativeName();
            status = townHall.buildingLocationIP.level == 0 ? MLN.string("ui.inconstruction") : MLN.string("ui.upgrading", "" + townHall.buildingLocationIP.level);
            if (townHall.buildingLocationIP != null) {
                int distance = MathHelper.func_76128_c((double)townHall.getPos().distanceTo(townHall.buildingLocationIP.pos));
                String direction = MLN.string(townHall.getPos().directionTo(townHall.buildingLocationIP.pos));
                loc = MLN.string("other.shortdistancedirection", "" + distance, "" + direction);
            } else {
                loc = "";
            }
            page.add(planName + ": " + status + " - " + loc);
        }
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateResources(EntityPlayer player, Building house) {
        Vector<String> page = new Vector<String>();
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        page.add(MLN.string("panels.resources") + ": " + house.getNativeBuildingName());
        page.add("");
        BuildingPlan goalPlan = house.getCurrentGoalBuildingPlan();
        Vector<MillVillager.InvItem> res = new Vector<MillVillager.InvItem>();
        HashMap<MillVillager.InvItem, Integer> resCost = new HashMap<MillVillager.InvItem, Integer>();
        HashMap<MillVillager.InvItem, Integer> resHas = new HashMap<MillVillager.InvItem, Integer>();
        if (goalPlan != null) {
            String name;
            for (MillVillager.InvItem key : goalPlan.resCost.keySet()) {
                res.add(key);
                resCost.put(key, goalPlan.resCost.get(key));
                int has = house.countGoods(key.getItem(), key.meta);
                if (house.builder != null && house.buildingLocationIP != null && house.buildingLocationIP.key.equals(house.buildingGoal)) {
                    has += house.builder.countInv(key.getItem(), key.meta);
                }
                if (has > goalPlan.resCost.get(key)) {
                    has = goalPlan.resCost.get(key);
                }
                resHas.put(key, has);
            }
            page.add(MLN.string("panels.resourcesneeded") + ":");
            String gameName = goalPlan.getGameName();
            if (goalPlan.nativeName != null && goalPlan.nativeName.length() > 0) {
                name = goalPlan.nativeName;
            } else if (goalPlan.getGameName() != null && goalPlan.getGameName().length() > 0) {
                name = goalPlan.getGameName();
                gameName = "";
            } else {
                name = "";
            }
            if (gameName != null && gameName.length() > 0) {
                name = name + " (" + gameName + ")";
            }
            String status = "";
            status = house.buildingLocationIP != null && house.buildingLocationIP.key.equals(house.buildingGoal) ? (house.buildingLocationIP.level == 0 ? MLN.string("ui.inconstruction") : MLN.string("ui.upgrading") + " (" + house.buildingLocationIP.level + ")") : MLN.string(house.buildingGoalIssue);
            page.add(name + " - " + status);
            page.add("");
            Collections.sort(res, new MillVillager.InvItemAlphabeticalComparator());
            for (int i = 0; i < res.size(); ++i) {
                page.add(((MillVillager.InvItem)res.get(i)).getName() + ": " + resHas.get(res.get(i)) + "/" + resCost.get(res.get(i)));
            }
            text.add(page);
            page = new Vector();
        }
        page.add(MLN.string("panels.resourcesavailable") + ":");
        page.add("");
        HashMap<MillVillager.InvItem, Integer> contents = house.getChestsContent();
        Vector<MillVillager.InvItem> keys = new Vector<MillVillager.InvItem>(contents.keySet());
        Collections.sort(keys, new MillVillager.InvItemAlphabeticalComparator());
        for (MillVillager.InvItem key : keys) {
            page.add(key.getName() + ": " + contents.get(key));
        }
        text.add(page);
        return text;
    }

    public static Vector<Vector<String>> generateVillageMap(Building house) {
        Vector<Vector<String>> text = new Vector<Vector<String>>();
        Vector<String> page = new Vector<String>();
        page.add(MLN.string("ui.villagemap") + ": " + house.getNativeBuildingName());
        text.add(page);
        page = new Vector();
        page.add(MLN.string("panels.mappurple"));
        page.add(MLN.string("panels.mapblue"));
        page.add(MLN.string("panels.mapgreen"));
        page.add(MLN.string("panels.maplightgreen"));
        page.add(MLN.string("panels.mapred"));
        page.add(MLN.string("panels.mapyellow"));
        page.add(MLN.string("panels.maporange"));
        page.add(MLN.string("panels.maplightblue"));
        page.add(MLN.string("panels.mapbrown"));
        text.add(page);
        return text;
    }

    public static void readPacket(ByteBufInputStream ds) {
        try {
            Point pos = StreamReadWrite.readNullablePoint((DataInput)ds);
            int panelType = ds.read();
            Point buildingPos = StreamReadWrite.readNullablePoint((DataInput)ds);
            long villager_id = ds.readLong();
            String[][] lines = StreamReadWrite.readStringStringArray((DataInput)ds);
            MillClientUtilities.updatePanel(pos, lines, panelType, buildingPos, villager_id);
            if (MLN.LogNetwork >= 3) {
                MLN.debug(null, "Receiving panel packet.");
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public Vector<Vector<String>> getFullText(EntityPlayer player) {
        if (this.panelType == 0 || this.buildingPos == null) {
            return null;
        }
        Building building = Mill.clientWorld.getBuilding(this.buildingPos);
        if (this.panelType == 1) {
            return TileEntityPanel.generateEtatCivil(player, building);
        }
        if (this.panelType == 2) {
            return TileEntityPanel.generateConstructions(player, building);
        }
        if (this.panelType == 3) {
            return TileEntityPanel.generateProjects(player, building);
        }
        if (this.panelType == 5) {
            return TileEntityPanel.generateHouse(player, building);
        }
        if (this.panelType == 7) {
            return TileEntityPanel.generateArchives(player, building, this.villager_id);
        }
        if (this.panelType == 6) {
            return TileEntityPanel.generateResources(player, building);
        }
        if (this.panelType == 8) {
            return TileEntityPanel.generateVillageMap(building);
        }
        if (this.panelType == 9) {
            return TileEntityPanel.generateMilitary(player, building);
        }
        if (this.panelType == 10) {
            return TileEntityPanel.generateMarketGoods(building);
        }
        if (this.panelType == 11) {
            return TileEntityPanel.generateInnVisitors(building);
        }
        if (this.panelType == 12) {
            return TileEntityPanel.generateMarketMerchants(building);
        }
        return null;
    }

    public int getMapType() {
        if (this.panelType == 8) {
            return 1;
        }
        return 0;
    }

    public boolean func_145914_a() {
        return false;
    }

    public static class PanelPacketInfo {
        Point pos;
        Point buildingPos;
        String[][] lines;
        long villager_id;
        int panelType;

        public PanelPacketInfo(Point pos, String[][] lines, Point buildingPos, int panelType, long village_id) {
            this.pos = pos;
            this.lines = lines;
            this.buildingPos = buildingPos;
            this.panelType = panelType;
            this.villager_id = village_id;
        }
    }
}

