/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.millenaire.common.Building;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;

public class GoalIndianGatherBrick
extends Goal {
    public GoalIndianGatherBrick() {
        this.maxSimultaneousInBuilding = 2;
        this.townhallLimit.put(new MillVillager.InvItem(Mill.stone_decoration, 1), 4096);
    }

    @Override
    public int actionDuration(MillVillager villager) {
        return 1000;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        Vector<Point> vp = new Vector<Point>();
        Vector<Point> buildingp = new Vector<Point>();
        for (Building kiln : villager.getTownHall().getBuildingsWithTag("brickkiln")) {
            Point p = kiln.getFullBrickLocation();
            if (p == null) continue;
            vp.add(p);
            buildingp.add(kiln.getPos());
        }
        if (vp.isEmpty()) {
            return null;
        }
        Point p = (Point)vp.firstElement();
        Point buildingP = (Point)buildingp.firstElement();
        for (int i = 1; i < vp.size(); ++i) {
            if (!(((Point)vp.get(i)).horizontalDistanceToSquared((Entity)villager) < p.horizontalDistanceToSquared((Entity)villager))) continue;
            p = (Point)vp.get(i);
            buildingP = (Point)buildingp.get(i);
        }
        return this.packDest(p, buildingP);
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        return villager.getBestPickaxeStack();
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        boolean delayOver = !villager.lastGoalTime.containsKey(this) ? true : villager.field_70170_p.func_72820_D() > villager.lastGoalTime.get(this) + 2000L;
        for (Building kiln : villager.getTownHall().getBuildingsWithTag("brickkiln")) {
            int nb = kiln.getNbFullBrickLocation();
            if (nb > 0 && delayOver) {
                return true;
            }
            if (nb <= 4) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        if (MillCommonUtilities.getBlock(villager.field_70170_p, villager.getGoalDestPoint()) == Mill.stone_decoration && MillCommonUtilities.getBlockMeta(villager.field_70170_p, villager.getGoalDestPoint()) == 1) {
            villager.addToInv(Mill.stone_decoration, MillCommonUtilities.getBlockMeta(villager.field_70170_p, villager.getGoalDestPoint()), 1);
            villager.setBlockAndMetadata(villager.getGoalDestPoint(), Blocks.field_150350_a, 0);
            villager.func_71038_i();
            return false;
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        int p = 100 - villager.getTownHall().nbGoodAvailable(Mill.stone_decoration, 1, false, false) * 2;
        for (MillVillager v : villager.getTownHall().villagers) {
            if (!this.key.equals(v.goalKey)) continue;
            p /= 2;
        }
        return p;
    }

    @Override
    public boolean unreachableDestination(MillVillager villager) {
        return false;
    }
}

