/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client;

import java.util.Vector;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.millenaire.client.ModelFemaleAsymmetrical;
import org.millenaire.client.ModelFemaleSymmetrical;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.Quest;
import org.millenaire.common.UserProfile;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AS_PathEntity;

public class RenderMillVillager
extends RenderBiped {
    private static final float SCALE = 0.01666667f;
    private static final float LINE_HEIGHT = 0.2f;
    private static final int LINE_SIZE = 60;
    private final ModelBiped modelCloth;

    public RenderMillVillager(ModelBiped modelbiped, float f) {
        super(modelbiped, f);
        this.field_77071_a = (ModelBiped)this.field_77045_g;
        this.modelCloth = modelbiped instanceof ModelFemaleAsymmetrical ? new ModelFemaleAsymmetrical(0.1f) : (modelbiped instanceof ModelFemaleSymmetrical ? new ModelFemaleSymmetrical(0.1f) : new ModelBiped(0.1f));
    }

    private void displayText(String text, float scale, int colour, float x, float y, float z) {
        FontRenderer fontrenderer = this.func_76983_a();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int textWidth = fontrenderer.func_78256_a(text) / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.8f);
        tessellator.func_78377_a((double)(-textWidth - 1), -1.0, 0.0);
        tessellator.func_78377_a((double)(-textWidth - 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(textWidth + 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(textWidth + 1), -1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        fontrenderer.func_78276_b(text, -fontrenderer.func_78256_a(text) / 2, 0, colour);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
        MillVillager villager = (MillVillager)entity;
        if (villager.isUsingBow) {
            this.field_77071_a.field_78118_o = true;
            this.modelCloth.field_78118_o = true;
        }
        super.func_76986_a(entity, d, d1, d2, f, f1);
        this.field_77071_a.field_78118_o = false;
        this.modelCloth.field_78118_o = false;
        this.doRenderVillagerName(villager, d, d1, d2);
    }

    public void doRenderVillagerName(MillVillager villager, double x, double y, double z) {
        float villagerSize = villager.scale * 2.0f;
        if (villager.shouldLieDown) {
            double height = villager.field_70121_D.field_72337_e - villager.field_70121_D.field_72338_b;
            float angle = villager.getBedOrientationInDegrees();
            double dx = 0.0;
            double dz = 0.0;
            if (angle == 0.0f) {
                dx = -height * 0.9;
            } else if (angle == 90.0f) {
                dz = -height * 0.9;
            } else if (angle == 180.0f) {
                dx = height * 0.9;
            } else if (angle == 270.0f) {
                dz = height * 0.9;
            }
            x = villager.field_70142_S - RenderManager.field_78725_b + dx;
            z = villager.field_70136_U - RenderManager.field_78723_d + dz;
            villagerSize = 0.5f;
        }
        UserProfile profile = Mill.clientWorld.getProfile(Mill.proxy.getTheSinglePlayer().getDisplayName());
        float f4 = villager.func_70032_d((Entity)this.field_76990_c.field_78734_h);
        if (f4 < (float)MLN.VillagersNamesDistance) {
            String gameSpeech = villager.getGameSpeech(Mill.proxy.getTheSinglePlayer().getDisplayName());
            String nativeSpeech = villager.getNativeSpeech(Mill.proxy.getTheSinglePlayer().getDisplayName());
            float height = 0.2f;
            if (MLN.DEV && Mill.serverWorlds.size() > 0 && Mill.serverWorlds.firstElement().villagers.containsKey(villager.villager_id) && !MLN.DEV) {
                MillVillager dv = Mill.serverWorlds.firstElement().villagers.get(villager.villager_id);
                AS_PathEntity pe = dv.pathEntity;
                if (pe != null && pe.pointsCopy != null) {
                    PathPoint[] pp = pe.pointsCopy;
                    if (pp != null && pp.length > 0) {
                        String s = "";
                        for (int i = pe.func_75873_e(); i < pp.length && i < pe.func_75873_e() + 5; ++i) {
                            s = s + "(" + pp[i] + ") ";
                        }
                        this.displayText(s, 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
                        height += 0.2f;
                    }
                    if (pe != null) {
                        if (pe.func_75874_d() > 0) {
                            this.displayText("Path: " + pe.func_75874_d() + " end: " + pe.getCurrentTargetPathPoint() + " dist: " + Math.round(villager.getPos().horizontalDistanceTo(pe.func_75870_c()) * 10.0) / 10L + " index: " + pe.func_75873_e() + " " + dv.func_70781_l() + " PF: " + dv.pathfailure + ", stuck: " + dv.longDistanceStuck, 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
                        } else {
                            this.displayText("Empty path PF: " + dv.pathfailure + ", stuck: " + dv.longDistanceStuck, 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
                        }
                        height += 0.2f;
                    }
                } else {
                    this.displayText("Null path entity, PF: " + dv.pathfailure + ", stuck: " + dv.longDistanceStuck, 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
                    height += 0.2f;
                }
                if (dv.func_70777_m() == null) {
                    this.displayText("Pos: " + dv.getPos() + " Path dest: " + dv.getPathDestPoint() + " Goal dest: " + dv.getGoalDestPoint() + " dist: " + Math.round(dv.getPos().horizontalDistanceTo(dv.getPathDestPoint()) * 10.0) / 10L + " sm: " + dv.stopMoving + " jps busy: " + dv.jpsPathPlanner.isBusy(), 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
                } else {
                    this.displayText("Pos: " + dv.getPos() + " Entity: " + dv.func_70777_m() + " dest: " + new Point(dv.func_70777_m()) + " dist: " + Math.round(dv.getPos().horizontalDistanceTo(new Point(dv.func_70777_m())) * 10.0) / 10L + " sm: " + dv.stopMoving + " jps busy: " + dv.jpsPathPlanner.isBusy(), 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
                }
                height += 0.2f;
            }
            if (villager.hiredBy == null) {
                String subLine;
                String line;
                if (gameSpeech != null) {
                    Vector<String> lines = new Vector<String>();
                    line = gameSpeech;
                    while (line.length() > 60) {
                        subLine = line.substring(0, line.lastIndexOf(32, 60));
                        line = line.substring(subLine.length()).trim();
                        lines.add(subLine);
                    }
                    lines.add(line);
                    for (int i = lines.size() - 1; i >= 0; --i) {
                        this.displayText((String)lines.get(i), 0.01666667f, -1596166533, (float)x, (float)y + villagerSize + height, (float)z);
                        height += 0.2f;
                    }
                }
                if (nativeSpeech != null) {
                    Vector<String> lines = new Vector<String>();
                    line = nativeSpeech;
                    while (line.length() > 60) {
                        subLine = line.substring(0, line.lastIndexOf(32, 60));
                        line = line.substring(subLine.length()).trim();
                        lines.add(subLine);
                    }
                    lines.add(line);
                    for (int i = lines.size() - 1; i >= 0; --i) {
                        this.displayText((String)lines.get(i), 0.01666667f, -1603244324, (float)x, (float)y + villagerSize + height, (float)z);
                        height += 0.2f;
                    }
                }
                if (MLN.displayNames && Goal.goals.containsKey(villager.goalKey)) {
                    this.displayText(Goal.goals.get(villager.goalKey).gameName(villager), 0.01666667f, -1596142994, (float)x, (float)y + villagerSize + height, (float)z);
                    height += 0.2f;
                }
                if (profile.villagersInQuests.containsKey(villager.villager_id)) {
                    Quest.QuestInstance qi = profile.villagersInQuests.get(villager.villager_id);
                    if (qi.getCurrentVillager().id == villager.villager_id) {
                        this.displayText("[" + qi.getLabel(profile) + "]", 0.01666667f, -1596072483, (float)x, (float)y + villagerSize + height, (float)z);
                        height += 0.2f;
                    }
                }
                if (villager.isRaider) {
                    this.displayText(MLN.string("ui.raider"), 0.01666667f, -1593872773, (float)x, (float)y + villagerSize + height, (float)z);
                    height += 0.2f;
                }
                if (villager.vtype.showHealth) {
                    this.displayText(MLN.string("hire.health") + ": " + (double)villager.func_110143_aJ() * 0.5 + "/" + (double)villager.func_110138_aP() * 0.5, 0.01666667f, -1596072483, (float)x, (float)y + villagerSize + height, (float)z);
                    height += 0.2f;
                }
            } else if (villager.hiredBy.equals(profile.playerName)) {
                String s = MLN.string("hire.health") + ": " + (double)villager.func_110143_aJ() * 0.5 + "/" + (double)villager.func_110138_aP() * 0.5;
                s = villager.aggressiveStance ? s + " - " + MLN.string("hire.aggressive") : s + " - " + MLN.string("hire.passive");
                this.displayText(s, 0.01666667f, -1596142994, (float)x, (float)y + villagerSize + height, (float)z);
                s = MLN.string("hire.timeleft", "" + Math.round((villager.hiredUntil - villager.field_70170_p.func_72820_D()) / 1000L));
                this.displayText(s, 0.01666667f, -1596072483, (float)x, (float)y + villagerSize + (height += 0.2f), (float)z);
                height += 0.2f;
            } else {
                String s = MLN.string("hire.hiredby", villager.hiredBy);
                this.displayText(s, 0.01666667f, -1596072483, (float)x, (float)y + villagerSize + height, (float)z);
                height += 0.2f;
            }
            if (MLN.displayNames && !villager.vtype.hideName) {
                this.displayText(villager.getName() + ", " + villager.getNativeOccupationName(), 0.01666667f, -1593835521, (float)x, (float)y + villagerSize + height, (float)z);
            }
        }
    }

    protected void func_77041_b(EntityLivingBase entityliving, float f) {
        this.preRenderScale((MillVillager)entityliving, f);
    }

    protected void preRenderScale(MillVillager villager, float f) {
        GL11.glScalef((float)villager.scale, (float)villager.scale, (float)villager.scale);
    }

    protected void func_77043_a(EntityLivingBase par1EntityLiving, float par2, float par3, float par4) {
        MillVillager v = (MillVillager)par1EntityLiving;
        if (v.func_70089_S() && v.isVillagerSleeping()) {
            float orientation = -v.getBedOrientationInDegrees();
            GL11.glRotatef((float)orientation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.func_77037_a((EntityLivingBase)v), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.func_77043_a((EntityLivingBase)v, par2, par3, par4);
        }
    }

    protected int setClothModel(MillVillager villager, int clothPartID, float f) {
        try {
            ResourceLocation clothTexture = villager.getClothTexturePath();
            if (clothTexture == null) {
                this.modelCloth.field_78116_c.field_78806_j = false;
                this.modelCloth.field_78114_d.field_78806_j = false;
                this.modelCloth.field_78115_e.field_78806_j = false;
                this.modelCloth.field_78112_f.field_78806_j = false;
                this.modelCloth.field_78113_g.field_78806_j = false;
                this.modelCloth.field_78123_h.field_78806_j = false;
                this.modelCloth.field_78124_i.field_78806_j = false;
                return -1;
            }
            this.func_110776_a(clothTexture);
            this.modelCloth.field_78116_c.field_78806_j = true;
            this.modelCloth.field_78114_d.field_78806_j = true;
            this.modelCloth.field_78115_e.field_78806_j = true;
            this.modelCloth.field_78112_f.field_78806_j = true;
            this.modelCloth.field_78113_g.field_78806_j = true;
            this.modelCloth.field_78123_h.field_78806_j = true;
            this.modelCloth.field_78124_i.field_78806_j = true;
            this.func_77042_a((ModelBase)this.modelCloth);
            this.modelCloth.field_78095_p = this.field_77045_g.field_78095_p;
            this.modelCloth.field_78093_q = this.field_77045_g.field_78093_q;
            this.modelCloth.field_78091_s = this.field_77045_g.field_78091_s;
            float f1 = 1.0f;
            GL11.glColor3f((float)f1, (float)f1, (float)f1);
            return 1;
        }
        catch (Exception e) {
            MLN.printException("Error when loading cloth: ", e);
            return -1;
        }
    }

    protected int func_77032_a(EntityLivingBase entityliving, int i, float f) {
        int armourRes = this.func_77032_a((EntityLiving)entityliving, i, f);
        int clothRes = -1;
        if (i == 0) {
            clothRes = this.setClothModel((MillVillager)entityliving, i, f);
        }
        if (armourRes > 0) {
            return armourRes;
        }
        return clothRes;
    }

    protected ResourceLocation func_110775_a(EntityLiving par1EntityLiving) {
        MillVillager villager = (MillVillager)par1EntityLiving;
        return villager.texture;
    }
}

