/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import org.millenaire.client.MillClientUtilities;
import org.millenaire.client.gui.DisplayActions;
import org.millenaire.common.Building;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.TileEntityMillChest;
import org.millenaire.common.TileEntityPanel;
import org.millenaire.common.UserProfile;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.StreamReadWrite;

public class ClientReceiver {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (FMLCommonHandler.instance().getSide().isServer() && MLN.LogNetwork >= 1) {
            MLN.major(this, "Received a packet despite being server.");
            return;
        }
        if (event.packet == null) {
            MLN.error(this, "Received a null packet!");
            return;
        }
        if (event.packet.payload() == null) {
            MLN.error(this, "Received a packet with null data on channel: " + event.packet.channel());
            return;
        }
        if (Mill.clientWorld == null) {
            MLN.error(this, "Received a packet despite null clientWorld.");
            return;
        }
        ByteBufInputStream data = new ByteBufInputStream(event.packet.payload());
        try {
            int packettype = data.read();
            Mill.clientWorld.millenaireEnabled = true;
            if (MLN.LogNetwork >= 3) {
                MLN.debug(this, "Received client packet type: " + packettype);
            }
            UserProfile profile = Mill.proxy.getClientProfile();
            if (packettype == 2) {
                Building.readBuildingPacket(Mill.clientWorld, data);
            } else if (packettype == 11) {
                Building.readShopPacket(Mill.clientWorld, data);
            } else if (packettype == 3) {
                MillVillager.readVillagerPacket(data);
            } else if (packettype == 100) {
                this.readTranslatedChatPackage(data);
            } else if (packettype == 108) {
                this.readVillagerSentencePackage(data);
            } else if (packettype == 5) {
                TileEntityMillChest.readUpdatePacket(data, Mill.clientWorld.world);
            } else if (packettype == 101) {
                profile.receiveProfilePacket(data);
            } else if (packettype == 102) {
                profile.receiveQuestInstancePacket(data);
            } else if (packettype == 103) {
                profile.receiveQuestInstanceDeletePacket(data);
            } else if (packettype == 104) {
                this.readGUIPacket(data);
            } else if (packettype == 7) {
                MillWorldInfo.MillMapInfo.readPacket(data);
            } else if (packettype == 106) {
                TileEntityPanel.readPacket(data);
            } else if (packettype == 9) {
                Mill.clientWorld.receiveVillageListPacket(data);
            } else if (packettype == 10) {
                this.readServerContentPacket(data);
            } else if (packettype == 107) {
                this.readAnimalBreedPacket(data);
            } else {
                MLN.error(null, "Received packet with unknown type: " + packettype);
            }
        }
        catch (Exception e) {
            MLN.printException("Error in ClientReceiver.onPacketData:", e);
        }
    }

    private void readAnimalBreedPacket(ByteBufInputStream data) {
        try {
            Point p = StreamReadWrite.readNullablePoint((DataInput)data);
            int endId = data.readInt();
            List<Entity> animals = MillCommonUtilities.getEntitiesWithinAABB(Mill.clientWorld.world, EntityAnimal.class, p, 5, 5);
            for (Entity ent : animals) {
                EntityAnimal animal = (EntityAnimal)ent;
                if (animal.func_145782_y() != endId) continue;
                ReflectionHelper.setPrivateValue(EntityAnimal.class, (Object)animal, (Object)600, (int)0);
                MillCommonUtilities.generateHearts((Entity)animal);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void readGUIPacket(ByteBufInputStream data) {
        try {
            int guiId = data.read();
            if (guiId == 3) {
                MillVillager v = Mill.clientWorld.villagers.get(data.readLong());
                if (v != null) {
                    DisplayActions.displayQuestGUI(Mill.proxy.getTheSinglePlayer(), v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiId);
                }
            } else if (guiId == 12) {
                MillVillager v = Mill.clientWorld.villagers.get(data.readLong());
                if (v != null) {
                    DisplayActions.displayHireGUI(Mill.proxy.getTheSinglePlayer(), v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiId);
                }
            } else if (guiId == 4) {
                MillVillager v = Mill.clientWorld.villagers.get(data.readLong());
                if (v != null) {
                    DisplayActions.displayVillageChiefGUI(Mill.proxy.getTheSinglePlayer(), v);
                } else {
                    MLN.error(this, "Unknown villager id in readGUIPacket: " + guiId);
                }
            } else if (guiId == 5) {
                Point p = StreamReadWrite.readNullablePoint((DataInput)data);
                if (p != null) {
                    DisplayActions.displayVillageBookGUI(Mill.proxy.getTheSinglePlayer(), p);
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 9) {
                Point p = StreamReadWrite.readNullablePoint((DataInput)data);
                if (p != null) {
                    Building building = Mill.clientWorld.getBuilding(p);
                    if (building != null) {
                        DisplayActions.displayNegationWandGUI(Mill.proxy.getTheSinglePlayer(), building);
                    }
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 10) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                if (thPos != null && pos != null) {
                    Building building = Mill.clientWorld.getBuilding(thPos);
                    if (building != null) {
                        DisplayActions.displayNewBuildingProjectGUI(Mill.proxy.getTheSinglePlayer(), building, pos);
                    }
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 13) {
                Point pos = StreamReadWrite.readNullablePoint((DataInput)data);
                if (pos != null) {
                    DisplayActions.displayNewVillageGUI(Mill.proxy.getTheSinglePlayer(), pos);
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 11) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                if (thPos != null) {
                    Building building = Mill.clientWorld.getBuilding(thPos);
                    if (building != null) {
                        DisplayActions.displayControlledProjectGUI(Mill.proxy.getTheSinglePlayer(), building);
                    }
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 14) {
                Point thPos = StreamReadWrite.readNullablePoint((DataInput)data);
                if (thPos != null) {
                    Building building = Mill.clientWorld.getBuilding(thPos);
                    if (building != null) {
                        DisplayActions.displayControlledMilitaryGUI(Mill.proxy.getTheSinglePlayer(), building);
                    }
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 7) {
                Point p = StreamReadWrite.readNullablePoint((DataInput)data);
                if (p != null) {
                    MillClientUtilities.displayPanel(Mill.clientWorld.world, Mill.proxy.getTheSinglePlayer(), p);
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 2) {
                Point p = StreamReadWrite.readNullablePoint((DataInput)data);
                if (p != null) {
                    Mill.proxy.getTheSinglePlayer().openGui((Object)Mill.instance, 2, Mill.clientWorld.world, p.getiX(), p.getiY(), p.getiZ());
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else if (guiId == 8) {
                int id1 = data.readInt();
                int id2 = data.readInt();
                Mill.proxy.getTheSinglePlayer().openGui((Object)Mill.instance, 8, Mill.clientWorld.world, id1, id2, 0);
            } else if (guiId == 1) {
                Point p = StreamReadWrite.readNullablePoint((DataInput)data);
                if (p != null) {
                    TileEntityMillChest chest = p.getMillChest(Mill.clientWorld.world);
                    if (chest != null && chest.loaded) {
                        Mill.proxy.getTheSinglePlayer().openGui((Object)Mill.instance, 1, Mill.clientWorld.world, p.getiX(), p.getiY(), p.getiZ());
                    }
                } else {
                    MLN.error(this, "Unknown point in readGUIPacket: " + guiId);
                }
            } else {
                MLN.error(null, "Unknown GUI: " + guiId);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void readServerContentPacket(ByteBufInputStream data) {
        try {
            int nbCultures = data.readShort();
            for (int i = 0; i < nbCultures; ++i) {
                Culture.readCultureMissingContentPacket(data);
            }
            Culture.refreshVectors();
        }
        catch (IOException e) {
            MLN.printException("Error in readServerContentPacket:", e);
        }
    }

    private void readTranslatedChatPackage(ByteBufInputStream data) {
        try {
            char colour = data.readChar();
            String s = data.readUTF();
            String[] values = new String[data.read()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = MLN.unknownString(StreamReadWrite.readNullableString((DataInput)data));
            }
            s = MLN.string(s, values);
            Mill.proxy.sendLocalChat(Mill.proxy.getTheSinglePlayer(), colour, s);
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void readVillagerSentencePackage(ByteBufInputStream data) {
        try {
            MillVillager v = Mill.clientWorld.villagers.get(data.readLong());
            if (v != null) {
                MillClientUtilities.putVillagerSentenceInChat(v);
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }
}

