/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalConstructionStepByStep
extends Goal {
    @Override
    public int actionDuration(MillVillager villager) {
        BuildingPlan.BuildingBlock bblock = villager.getTownHall().getCurrentBlock();
        if (bblock == null) {
            return 0;
        }
        int toolEfficiency = (int)villager.getBestShovel().getDigSpeed(new ItemStack((Item)villager.getBestShovel(), 1), Blocks.field_150346_d, 0);
        if (bblock.block == Blocks.field_150350_a || bblock.block == Blocks.field_150346_d) {
            return 100 - toolEfficiency * 5;
        }
        return 500 - toolEfficiency * 20;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        BuildingPlan.BuildingBlock bblock = villager.getTownHall().getCurrentBlock();
        if (bblock == null) {
            return null;
        }
        return this.packDest(bblock.p);
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) {
        BuildingPlan.BuildingBlock bblock = villager.getTownHall().getCurrentBlock();
        if (bblock != null) {
            if (bblock.block == Blocks.field_150350_a || Item.func_150898_a((Block)bblock.block) == null) {
                return villager.getBestShovelStack();
            }
            return new ItemStack[]{new ItemStack(bblock.block, 1, (int)bblock.meta)};
        }
        return villager.getBestShovelStack();
    }

    @Override
    public AStarConfig getPathingConfig() {
        return JPS_CONFIG_BUILDING;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.getTownHall().builder != null || villager.getTownHall().buildingLocationIP == null || villager.getTownHall().getBblocks() == null) {
            return false;
        }
        for (MillVillager v : villager.getTownHall().villagers) {
            if (!Goal.getResourcesForBuild.key.equals(v.goalKey) && !Goal.construction.key.equals(v.goalKey)) continue;
            return false;
        }
        for (MillVillager.InvItem key : villager.getTownHall().getCurrentBuildingPlan().resCost.keySet()) {
            if (villager.countInv(key) >= villager.getTownHall().getCurrentBuildingPlan().resCost.get(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStillValidSpecific(MillVillager villager) throws Exception {
        return villager.getTownHall().builder == null || villager.getTownHall().builder == villager;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public void onAccept(MillVillager villager) {
        villager.getTownHall().builder = villager;
    }

    @Override
    public boolean performAction(MillVillager villager) throws MLN.MillenaireException {
        BuildingPlan.BuildingBlock bblock = villager.getTownHall().getCurrentBlock();
        if (bblock == null) {
            return true;
        }
        if (MLN.LogWifeAI >= 2) {
            MLN.minor(villager, "Setting block at " + bblock.p + " type: " + bblock.block + " replacing: " + villager.getBlock(bblock.p) + " distance: " + bblock.p.distanceTo((Entity)villager));
        }
        if (bblock.p.horizontalDistanceTo((Entity)villager) < 1.0 && (double)bblock.p.getiY() > villager.field_70163_u && (double)bblock.p.getiY() < villager.field_70163_u + 2.0) {
            boolean jumped = false;
            World world = villager.field_70170_p;
            if (!MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX() + 1, villager.getPos().getiY() + 1, villager.getPos().getiZ()) && !MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX() + 1, villager.getPos().getiY() + 2, villager.getPos().getiZ())) {
                villager.func_70107_b(villager.getPos().getiX() + 1, villager.getPos().getiY() + 1, villager.getPos().getiZ());
                jumped = true;
            }
            if (!(jumped || MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX() - 1, villager.getPos().getiY() + 1, villager.getPos().getiZ()) || MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX() - 1, villager.getPos().getiY() + 2, villager.getPos().getiZ()))) {
                villager.func_70107_b(villager.getPos().getiX() - 1, villager.getPos().getiY() + 1, villager.getPos().getiZ());
                jumped = true;
            }
            if (!(jumped || MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX(), villager.getPos().getiY(), villager.getPos().getiZ() + 1) || MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX(), villager.getPos().getiY() + 2, villager.getPos().getiZ() + 1))) {
                villager.func_70107_b(villager.getPos().getiX(), villager.getPos().getiY() + 1, villager.getPos().getiZ() + 1);
                jumped = true;
            }
            if (!(jumped || MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX(), villager.getPos().getiY() + 1, villager.getPos().getiZ() - 1) || MillCommonUtilities.isBlockOpaqueCube(world, villager.getPos().getiX(), villager.getPos().getiY() + 2, villager.getPos().getiZ() - 1))) {
                villager.func_70107_b(villager.getPos().getiX(), villager.getPos().getiY() + 1, villager.getPos().getiZ() - 1);
                jumped = true;
            }
            if (!jumped && MLN.LogWifeAI >= 1) {
                MLN.major(villager, "Tried jumping in construction but couldn't");
            }
        }
        bblock.build(villager.field_70170_p, false, false);
        villager.func_71038_i();
        boolean foundNextBlock = false;
        while (!foundNextBlock && villager.getTownHall().areBlocksLeft()) {
            villager.getTownHall().incrementBblockPos();
            BuildingPlan.BuildingBlock bb = villager.getTownHall().getCurrentBlock();
            if (bb == null || bb.alreadyDone(villager.field_70170_p)) continue;
            villager.setGoalDestPoint(bb.p);
            foundNextBlock = true;
        }
        if (!villager.getTownHall().areBlocksLeft()) {
            if (MLN.LogBuildingPlan >= 1) {
                MLN.major(this, "Villager " + villager + " laid last block in " + villager.getTownHall().buildingLocationIP.key + " at " + bblock.p);
            }
            villager.getTownHall().setBblocks(null);
            BuildingPlan plan = villager.getTownHall().getCurrentBuildingPlan();
            for (MillVillager.InvItem key : plan.resCost.keySet()) {
                villager.takeFromInv(key.getItem(), key.meta, (int)plan.resCost.get(key));
            }
            if (villager.getTownHall().buildingLocationIP != null && villager.getTownHall().buildingLocationIP.level == 0) {
                villager.getTownHall().initialiseCurrentConstruction(bblock.p);
            }
        }
        if (!foundNextBlock) {
            villager.setGoalDestPoint(null);
        }
        if (MLN.LogWifeAI >= 2 && villager.extraLog) {
            MLN.minor(villager, "Reseting actionStart after " + (System.currentTimeMillis() - villager.actionStart));
        }
        villager.actionStart = 0L;
        return !villager.getTownHall().areBlocksLeft();
    }

    @Override
    public int priority(MillVillager villager) {
        return 150;
    }

    @Override
    public int range(MillVillager villager) {
        return ACTIVATION_RANGE + 2;
    }

    @Override
    public boolean stopMovingWhileWorking() {
        return false;
    }

    @Override
    public boolean stuckAction(MillVillager villager) throws MLN.MillenaireException {
        if (villager.getGoalDestPoint().distanceTo((Entity)villager) < 30.0) {
            if (MLN.LogWifeAI >= 2) {
                MLN.major(villager, "Putting block at a distance: " + villager.getGoalDestPoint().distanceTo((Entity)villager));
            }
            this.performAction(villager);
            return true;
        }
        return false;
    }

    @Override
    public boolean unreachableDestination(MillVillager villager) throws Exception {
        this.performAction(villager);
        return true;
    }
}

