/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.generic;

import java.io.BufferedReader;
import java.io.File;
import java.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.goal.generic.GoalGeneric;
import org.millenaire.common.goal.generic.GoalGenericPlantCrop;
import org.millenaire.common.item.Goods;

public class GoalGenericHarvestCrop
extends GoalGeneric {
    public String soilName = null;
    public String cropType = null;
    public Vector<MillVillager.InvItem> harvestItems = new Vector();
    public Vector<Integer> harvestItemsChance = new Vector();
    public MillVillager.InvItem irrigationBonusCrop = null;

    public GoalGenericHarvestCrop() {
        this.duration = 100;
    }

    @Override
    public boolean isPossibleGenericGoal(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public int priority(MillVillager villager) {
        Goal.GoalInformation info = this.getDestination(villager);
        if (info == null || info.getDest() == null) {
            return -1;
        }
        return (int)(30.0 - villager.getPos().distanceTo(info.getDest()));
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        Point dest = null;
        Building destBuilding = null;
        Vector<Building> buildings = this.getBuildings(villager);
        for (Building buildingDest : buildings) {
            Vector<Point> soils;
            if (!this.isDestPossible(villager, buildingDest) || (soils = buildingDest.getSoilPoints(this.soilName)) == null) continue;
            for (Point p : soils) {
                if (!this.isValidHarvestSoil(villager.field_70170_p, p) || dest != null && !(p.distanceTo((Entity)villager) < dest.distanceTo((Entity)villager))) continue;
                dest = p;
                destBuilding = buildingDest;
            }
        }
        if (dest == null) {
            return null;
        }
        return this.packDest(dest, destBuilding);
    }

    private boolean isValidHarvestSoil(World world, Point p) {
        return p.getAbove().getBlock(world) == GoalGenericPlantCrop.getCropBlock(this.cropType) && p.getAbove().getMeta(world) == GoalGenericHarvestCrop.getCropBlockRipeMeta(this.cropType);
    }

    @Override
    public boolean performAction(MillVillager villager) {
        if (this.isValidHarvestSoil(villager.field_70170_p, villager.getGoalDestPoint())) {
            if (this.irrigationBonusCrop != null) {
                float irrigation = villager.getTownHall().getVillageIrrigation();
                double rand = Math.random();
                if (rand < (double)(irrigation / 100.0f)) {
                    villager.addToInv(this.irrigationBonusCrop, 1);
                }
            }
            for (int i = 0; i < this.harvestItems.size(); ++i) {
                if (MillCommonUtilities.randomInt(100) >= this.harvestItemsChance.get(i)) continue;
                villager.addToInv(this.harvestItems.get(i), 1);
            }
            villager.setBlockAndMetadata(villager.getGoalDestPoint().getAbove(), Blocks.field_150350_a, 0);
            villager.func_71038_i();
        }
        return true;
    }

    public static int getCropBlockRipeMeta(String cropType) {
        return 7;
    }

    public static GoalGenericHarvestCrop loadGenericHarvestCropGoal(File file) {
        GoalGenericHarvestCrop g = new GoalGenericHarvestCrop();
        g.key = file.getName().split("\\.")[0].toLowerCase();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                String value;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading generic harvest goal " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].trim().toLowerCase();
                if (GoalGeneric.readGenericGoalConfigLine(g, key, value = temp[1].trim(), file, line)) continue;
                if (key.equals("soilname")) {
                    g.soilName = value.trim().toLowerCase();
                    continue;
                }
                if (key.equals("croptype")) {
                    g.cropType = value.trim().toLowerCase();
                    continue;
                }
                if (key.equals("irrigationbonuscrop")) {
                    if (Goods.goodsName.containsKey(value = value.trim().toLowerCase())) {
                        g.irrigationBonusCrop = Goods.goodsName.get(value);
                        continue;
                    }
                    MLN.error(null, "Unknown irrigationbonuscrop in generic harvest goal " + file.getName() + ": " + line);
                    continue;
                }
                if (key.equals("harvestitem")) {
                    String[] temp2 = value.split(",");
                    if (temp2.length != 2) {
                        MLN.error(null, "harvestitem must take the form of harvestitem=goodname,chanceon100 (ex: wheat,50) in generic harbest goal " + file.getName() + ": " + line);
                        continue;
                    }
                    if (Goods.goodsName.containsKey(temp2[0])) {
                        g.harvestItems.add(Goods.goodsName.get(temp2[0]));
                        g.harvestItemsChance.add(Integer.parseInt(temp2[1]));
                        continue;
                    }
                    MLN.error(null, "Unknown harvestitem item in generic harvest goal " + file.getName() + ": " + line);
                    continue;
                }
                MLN.error(null, "Unknown line in generic harvest goal " + file.getName() + ": " + line);
            }
            if (g.soilName == null) {
                MLN.error(null, "The soilname is mandatory in custom harvest goals " + file.getName());
                return null;
            }
            if (g.cropType == null) {
                MLN.error(null, "The croptype is mandatory in custom harvest goals " + file.getName());
                return null;
            }
            reader.close();
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
        return g;
    }

    @Override
    public boolean isDestPossibleSpecific(MillVillager villager, Building b) {
        return true;
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        if (this.heldItems != null) {
            return this.heldItems;
        }
        return villager.getBestHoeStack();
    }
}

