/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.orders;

import CoroUtil.bt.IBTAgent;
import CoroUtil.bt.OrdersData;
import CoroUtil.bt.actions.Delay;
import CoroUtil.bt.nodes.TargetEnemy;
import CoroUtil.bt.selector.SelectorMoveToCoords;
import CoroUtil.util.CoroUtilNBT;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public class OrdersGuardPosition
extends OrdersData {
    public IBTAgent entInt;
    public EntityLiving ent;
    public final ChunkCoordinates coordsGuard;
    public float guardRadius = 8.0f;

    public OrdersGuardPosition(IBTAgent parEnt, ChunkCoordinates parCoords, float parRadius) {
        this.entInt = parEnt;
        this.ent = (EntityLiving)parEnt;
        this.guardRadius = parRadius;
        this.coordsGuard = parCoords;
        this.activeOrdersName = "guard_position";
    }

    public static OrdersGuardPosition newFromNBT(IBTAgent parEnt, NBTTagCompound nbt) {
        try {
            OrdersGuardPosition orders = new OrdersGuardPosition(parEnt, CoroUtilNBT.readCoords("coordsGuard", nbt), nbt.func_74760_g("guardRadius"));
            return orders;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound parentCompound) {
        parentCompound.func_74776_a("guardRadius", this.guardRadius);
        if (this.coordsGuard != null) {
            CoroUtilNBT.writeCoords("coordsGuard", this.coordsGuard, parentCompound);
        }
        return super.writeToNBT(parentCompound);
    }

    @Override
    public void initBehaviors() {
        this.activeOrdersAI = new TargetEnemy(null, this.entInt, this.guardRadius, this.coordsGuard, -1, 20);
        SelectorMoveToCoords move = new SelectorMoveToCoords(null, this.entInt, new ChunkCoordinates[]{this.coordsGuard}, (int)this.guardRadius, false, false);
        this.activeOrdersAI.add(move);
        move.add(new Delay(this.activeOrdersAI, 1, 0));
        move.add(new Delay(this.activeOrdersAI, 1, 0));
    }
}

