/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI.jobSystem;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.AIAgent;
import CoroUtil.componentAI.AITamable;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.componentAI.jobSystem.JobHunt;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumActState;
import CoroUtil.entity.EnumJobState;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilInventory;
import CoroUtil.util.CoroUtilItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class JobBase {
    public JobManager jm = null;
    public AIAgent ai = null;
    public EntityLiving ent = null;
    public ICoroAI entInt = null;
    public EnumJobState state;
    public int hitAndRunDelay = 0;
    public int tradeTimeout = 0;
    public int walkingTimeout;
    public int fleeDelay = 0;
    public boolean dontStrayFromHome = false;
    public boolean dontStrayFromOwner = true;
    public double targPrevPosX;
    public double targPrevPosY;
    public double targPrevPosZ;
    public int ticksBeforeCloseCombatRetry = 0;
    public int ticksBeforeFormationRetry = 0;
    public long itemLookDelay;
    public int itemSearchRange = 10;
    public AITamable tamable;

    public JobBase(JobManager parJm) {
        this.jm = parJm;
        this.ai = this.jm.ai;
        this.ent = this.jm.ai.ent;
        this.entInt = this.jm.ai.entInt;
        this.tamable = new AITamable(this);
        this.setJobState(EnumJobState.IDLE);
    }

    public void cleanup() {
        this.tamable.cleanup();
        this.tamable = null;
        this.entInt = null;
        this.ent = null;
        this.ai = null;
        this.jm = null;
    }

    public void setJobState(EnumJobState ekos) {
        this.state = ekos;
    }

    public void tick() {
        if (this.hitAndRunDelay > 0) {
            --this.hitAndRunDelay;
        }
        if (this.tradeTimeout > 0) {
            --this.tradeTimeout;
        }
        this.tamable.tick();
    }

    public boolean shouldExecute() {
        return true;
    }

    public boolean shouldContinue() {
        return true;
    }

    public void onTickChestScan() {
        if (this.ai.scanForHomeChest && this.ent.field_70170_p.func_72820_D() % 100L == 0L && !CoroUtilInventory.isChest(this.ent.field_70170_p.func_147439_a(this.ai.homeX, this.ai.homeY, this.ai.homeZ))) {
            ChunkCoordinates tryCoords = this.getChestNearby();
            if (tryCoords != null) {
                this.ai.homeX = tryCoords.field_71574_a;
                this.ai.homeY = tryCoords.field_71572_b;
                this.ai.homeZ = tryCoords.field_71573_c;
            } else {
                int range = 30;
                List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)range, (double)(range / 2), (double)range));
                for (int j = 0; j < list.size(); ++j) {
                    Entity entity1 = (Entity)list.get(j);
                    if (!(entity1 instanceof ICoroAI) || !CoroUtilInventory.isChest(this.ent.field_70170_p.func_147439_a(((ICoroAI)entity1).getAIAgent().homeX, ((ICoroAI)entity1).getAIAgent().homeY, ((ICoroAI)entity1).getAIAgent().homeZ))) continue;
                    this.ai.homeX = ((ICoroAI)entity1).getAIAgent().homeX;
                    this.ai.homeY = ((ICoroAI)entity1).getAIAgent().homeY;
                    this.ai.homeZ = ((ICoroAI)entity1).getAIAgent().homeZ;
                    return;
                }
            }
        }
    }

    public ChunkCoordinates getChestNearby() {
        int range = 30;
        int xx = (int)Math.floor(this.ent.field_70165_t - (double)(range / 2));
        while ((double)xx < this.ent.field_70165_t + (double)(range / 2)) {
            int yy = (int)Math.max(1.0, Math.floor(this.ent.field_70163_u - 2.0));
            while ((double)yy < this.ent.field_70163_u + 2.0) {
                int zz = (int)Math.floor(this.ent.field_70161_v - (double)(range / 2));
                while ((double)zz < this.ent.field_70161_v + (double)(range / 2)) {
                    Block id = this.ent.field_70170_p.func_147439_a(xx, yy, zz);
                    if (CoroUtilInventory.isChest(id)) {
                        return new ChunkCoordinates(xx, yy, zz);
                    }
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
        return null;
    }

    public void onLowHealth() {
        PathEntity pe;
        if (this.hitAndRunDelay > 0) {
            --this.hitAndRunDelay;
        }
        if ((pe = this.ent.func_70661_as().func_75505_d()) != null && !pe.func_75879_b() && this.ent.field_70170_p.func_72933_a(pe.func_75878_a((Entity)this.ent), Vec3.func_72443_a((double)this.ent.field_70165_t, (double)(this.ent.field_70163_u + (double)this.ent.func_70047_e()), (double)this.ent.field_70161_v)) == null && pe.func_75878_a((Entity)this.ent).func_72438_d(Vec3.func_72443_a((double)this.ent.field_70165_t, (double)(this.ent.field_70163_u + (double)this.ent.func_70047_e()), (double)this.ent.field_70161_v)) < 3.0) {
            pe.func_75875_a();
        }
        if (this.ent.field_70122_E && this.ent.field_70123_F && !this.entInt.isBreaking()) {
            OldUtil.jump((EntityLivingBase)this.ent);
        }
    }

    public void onIdleTick() {
        if (this.tamable.isTame()) {
            this.tamable.onIdleTick();
        } else {
            this.onIdleTickAct();
        }
    }

    public void onIdleTickAct() {
        if (this.isInFormation() && this.ai.activeFormation.leader != this.entInt) {
            return;
        }
        if (this.ent.func_70661_as().func_75500_f() && this.ai.rand.nextInt(120) == 0) {
            if (!this.dontStrayFromHome) {
                this.ai.updateWanderPath();
            } else if (this.ent.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ) < this.ai.maxDistanceFromHome) {
                if (this.ai.rand.nextInt(5) == 0) {
                    int randsize = 32;
                    this.ai.walkTo((Entity)this.ent, this.ai.homeX + this.ai.rand.nextInt(randsize) - randsize / 2, this.ai.homeY + 1, this.ai.homeZ + this.ai.rand.nextInt(randsize) - randsize / 2, this.ai.maxPFRange, 600);
                } else {
                    this.ai.updateWanderPath();
                }
            } else {
                int randsize = 32;
                this.ai.walkTo((Entity)this.ent, this.ai.homeX + this.ai.rand.nextInt(randsize) - randsize / 2, this.ai.homeY + 1, this.ai.homeZ + this.ai.rand.nextInt(randsize) - randsize / 2, this.ai.maxPFRange, 600);
            }
        } else if (this.ent.func_70661_as().func_75500_f()) {
            // empty if block
        }
    }

    public void lookForItems() {
        this.itemSearchRange = 10;
        if (this.itemLookDelay < System.currentTimeMillis()) {
            this.itemLookDelay = System.currentTimeMillis() + 500L;
            List var3 = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)this.itemSearchRange * 1.0, (double)this.itemSearchRange * 1.0, (double)this.itemSearchRange * 1.0));
            if (var3 != null) {
                for (int var4 = 0; var4 < var3.size(); ++var4) {
                    Entity var5 = (Entity)var3.get(var4);
                    if (!var5.field_70128_L && var5 instanceof EntityItem) {
                        EntityItem entTemp = (EntityItem)var5;
                        continue;
                    }
                    if (!(var5 instanceof EntityXPOrb) || !this.ent.func_70685_l(var5) || var5.func_70055_a(Material.field_151586_h)) continue;
                    PFQueue.getPath((Entity)this.ent, var5, (float)this.itemSearchRange + 2.0f);
                }
            }
        }
    }

    public void onJobRemove() {
    }

    public void setJobItems() {
    }

    public boolean sanityCheck(Entity target) {
        return false;
    }

    public boolean sanityCheckHelp(Entity caller, Entity target) {
        return false;
    }

    public boolean hookHit(DamageSource ds, int damage) {
        return true;
    }

    public boolean hookInteract(EntityPlayer par1EntityPlayer) {
        return true;
    }

    public boolean checkHunger() {
        return false;
    }

    public boolean checkDangers() {
        return this.checkHealth();
    }

    public boolean checkHealth() {
        return (double)this.ent.func_110143_aJ() < (double)this.ent.func_110138_aP() * 0.75;
    }

    public boolean avoid(boolean actOnTrue) {
        Entity clEnt = null;
        float closest = 9999.0f;
        if (this.ai.lastFleeEnt != null && this.ai.lastFleeEnt.field_70128_L) {
            this.ai.lastFleeEnt = null;
        }
        if (this.fleeDelay > 0) {
            --this.fleeDelay;
        }
        float range = 15.0f;
        List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)range, (double)(range / 2.0f), (double)range));
        for (int j = 0; j < list.size(); ++j) {
            float dist;
            Entity entity1 = (Entity)list.get(j);
            if (entity1.field_70128_L || !this.isEnemy(entity1) || !((EntityLivingBase)entity1).func_70685_l((Entity)this.ent) || !((dist = this.ent.func_70032_d(entity1)) < closest)) continue;
            closest = dist;
            clEnt = entity1;
        }
        PathEntity path = this.ent.func_70661_as().func_75505_d();
        if (clEnt != null) {
            if (clEnt != this.ai.lastFleeEnt || this.ent.func_70661_as().func_75500_f()) {
                this.ai.lastFleeEnt = clEnt;
                if (actOnTrue && this.fleeDelay <= 0) {
                    this.fleeFrom(clEnt);
                }
            }
        } else if (this.ai.lastFleeEnt != null && actOnTrue && this.fleeDelay <= 0) {
            this.fleeFrom(this.ai.lastFleeEnt);
        }
        if (this.ai.lastFleeEnt != null) {
            if (this.ai.lastFleeEnt.field_70128_L) {
                this.ai.lastFleeEnt = null;
            }
            if (this.jm.priJob instanceof JobHunt) {
                this.setJobState(EnumJobState.W1);
            }
        }
        return clEnt != null;
    }

    public void fleeFrom(Entity fleeFrom) {
        this.fleeDelay = 10;
        double d = fleeFrom.field_70165_t - this.ent.field_70165_t;
        double d1 = fleeFrom.field_70161_v - this.ent.field_70161_v;
        while (d * d + d1 * d1 < 1.0E-4) {
            d = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        float f = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        float yaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - this.ent.field_70177_z;
        float look = this.ai.rand.nextInt(8) - 4;
        double dist = this.ai.rand.nextInt(8) + 8;
        int gatherX = (int)(this.ent.field_70165_t + -Math.sin((yaw + look) / 180.0f * (float)Math.PI) * Math.cos(this.ent.field_70125_A / 180.0f * (float)Math.PI) * dist);
        int gatherY = (int)(this.ent.field_70163_u - 0.5 + (double)(-MathHelper.func_76126_a((float)(this.ent.field_70125_A / 180.0f * (float)Math.PI))) * dist - 0.0);
        int gatherZ = (int)(this.ent.field_70161_v + Math.cos((yaw + look) / 180.0f * (float)Math.PI) * Math.cos(this.ent.field_70125_A / 180.0f * (float)Math.PI) * dist);
        gatherX = (int)(this.ent.field_70165_t - d / (double)f * dist);
        gatherZ = (int)(this.ent.field_70161_v - d1 / (double)f * dist);
        Block id = this.ent.field_70170_p.func_147439_a(gatherX, gatherY, gatherZ);
        int offset = -10;
        while (offset < 10 && !CoroUtilBlock.isAir(id)) {
            id = this.ent.field_70170_p.func_147439_a(gatherX, gatherY + offset++, gatherZ);
        }
        double homeDist = this.ent.func_70011_f((double)this.ai.homeX, (double)this.ai.homeY, (double)this.ai.homeZ);
        this.ai.walkTo((Entity)this.ent, gatherX, gatherY, gatherZ, this.ai.maxPFRange, 600, -1);
    }

    public boolean findWater() {
        int scanSize = this.ai.maxPFRange;
        int scanSizeY = 60;
        int tryY = (int)this.ent.field_70163_u - 1;
        int i = tryY + this.ai.rand.nextInt(scanSizeY) - scanSizeY / 2;
        for (int ii = 0; ii <= 5; ++ii) {
            int tryZ;
            int tryX = (int)this.ent.field_70165_t + this.ai.rand.nextInt(scanSize) - scanSize / 2;
            if (this.ent.field_70170_p.func_147439_a(tryX, i = tryY + this.ai.rand.nextInt(scanSizeY) - scanSizeY / 2, tryZ = (int)this.ent.field_70161_v + this.ai.rand.nextInt(scanSize) - scanSize / 2).func_149688_o() != Material.field_151586_h) continue;
            int newY = i;
            while (!CoroUtilBlock.isAir(this.ent.field_70170_p.func_147439_a(tryX, newY, tryZ))) {
                ++newY;
            }
            PFQueue.getPath((Entity)this.ent, tryX, newY - 1, tryZ, scanSize / 2 + 6);
            this.ai.setState(EnumActState.WALKING);
            this.walkingTimeout = 300;
            this.ai.targX = tryX;
            this.ai.targY = tryY;
            this.ai.targZ = tryZ;
            return true;
        }
        return false;
    }

    public boolean findLand() {
        int scanSize = 64;
        int tryX = (int)this.ent.field_70165_t + this.ai.rand.nextInt(scanSize) - scanSize / 2;
        int tryY = (int)this.ent.field_70163_u + 5;
        int tryZ = (int)this.ent.field_70161_v + this.ai.rand.nextInt(scanSize) - scanSize / 2;
        for (int i = tryY; i > tryY - 10; --i) {
            Block block = this.ent.field_70170_p.func_147439_a(tryX, i, tryZ);
            if (CoroUtilBlock.isAir(block) || block.func_149688_o() == Material.field_151586_h) continue;
            PFQueue.getPath((Entity)this.ent, tryX, tryY, tryZ, scanSize / 2 + 6);
            this.ai.setState(EnumActState.WALKING);
            this.walkingTimeout = 300;
            this.ai.targX = tryX;
            this.ai.targY = tryY;
            this.ai.targZ = tryZ;
            return true;
        }
        return false;
    }

    public EntityPlayer getClosestVulnerablePlayerToEntity(Entity par1Entity, double par2) {
        return this.getClosestPlayerToEntity(par1Entity, par2, true);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity par1Entity, double par2, boolean survivalOnly) {
        return this.getClosestPlayer(par1Entity.field_70170_p, par1Entity.field_70165_t, par1Entity.field_70163_u, par1Entity.field_70161_v, par2, survivalOnly);
    }

    public EntityPlayer getClosestPlayer(World world, double par1, double par3, double par5, double par7, boolean survivalOnly) {
        double var9 = -1.0;
        EntityPlayer var11 = null;
        for (int var12 = 0; var12 < world.field_73010_i.size(); ++var12) {
            EntityPlayer var13 = (EntityPlayer)world.field_73010_i.get(var12);
            if (var13.field_71075_bZ.field_75102_a && survivalOnly || !(var13.func_110143_aJ() > 0.0f)) continue;
            double var14 = var13.func_70092_e(par1, par3, par5);
            if (!(par7 < 0.0) && !(var14 < par7 * par7) || var9 != -1.0 && !(var14 < var9)) continue;
            var9 = var14;
            var11 = var13;
        }
        return var11;
    }

    public void transferItems(IInventory invFrom, IInventory invTo, String id, int transferCount, boolean foodOverride) {
        boolean count = false;
        block0: for (int j = 0; j < invFrom.func_70302_i_(); ++j) {
            ItemStack ourStack = invFrom.func_70301_a(j);
            if (ourStack == null || (!id.equals("-1") || foodOverride) && !CoroUtilItem.getNameByItem(ourStack.func_77973_b()).equals(id) && (!(ourStack.func_77973_b() instanceof ItemFood) || !foodOverride)) continue;
            for (int k = 0; k < invTo.func_70302_i_(); ++k) {
                int addCount;
                int space;
                ItemStack theirStack = invTo.func_70301_a(k);
                if (theirStack == null) {
                    space = 64;
                    addCount = ourStack.field_77994_a;
                    if (ourStack.field_77994_a < 0) {
                        System.out.println("!! ourStack.stackSize < 0");
                    }
                    if (transferCount < addCount && transferCount != -1) {
                        addCount = transferCount;
                    }
                    ourStack.field_77994_a -= addCount;
                    invTo.func_70299_a(k, new ItemStack(ourStack.func_77973_b(), addCount, ourStack.func_77960_j()));
                    if (transferCount != -1) {
                        transferCount -= addCount;
                    }
                    if (ourStack.field_77994_a == 0) {
                        invFrom.func_70299_a(j, null);
                        continue block0;
                    }
                    if (ourStack.field_77994_a < 0) {
                        // empty if block
                    }
                    if (transferCount != 0) continue;
                    return;
                }
                if (!CoroUtilItem.getNameByItem(ourStack.func_77973_b()).equals(CoroUtilItem.getNameByItem(theirStack.func_77973_b())) || theirStack.field_77994_a >= theirStack.func_77976_d()) continue;
                space = theirStack.func_77976_d() - theirStack.field_77994_a;
                addCount = ourStack.field_77994_a;
                if (space < ourStack.field_77994_a) {
                    addCount = space;
                }
                if (transferCount < addCount && transferCount != -1) {
                    addCount = transferCount;
                }
                ourStack.field_77994_a -= addCount;
                theirStack.field_77994_a += addCount;
                if (transferCount != -1) {
                    transferCount -= addCount;
                }
                if (ourStack.field_77994_a == 0) {
                    invFrom.func_70299_a(j, null);
                    continue block0;
                }
                if (transferCount != 0) continue;
                return;
            }
        }
    }

    public boolean shouldTickCloseCombat() {
        if (this.entInt.getAIAgent() == null) {
            return false;
        }
        Entity targ = this.entInt.getAIAgent().entityToAttack;
        if (targ == null) {
            return false;
        }
        if (this.ticksBeforeCloseCombatRetry > 0) {
            --this.ticksBeforeCloseCombatRetry;
            return false;
        }
        return this.ent.func_70685_l(targ) && this.ent.func_70032_d(targ) < 12.0f && this.ent.field_70121_D.field_72338_b - targ.field_70121_D.field_72338_b <= 2.5 && this.ent.field_70121_D.field_72338_b - targ.field_70121_D.field_72338_b > -2.5;
    }

    public boolean isInFormation() {
        return this.ai.activeFormation != null;
    }

    public boolean shouldTickFormation() {
        if (this.ai.entityToAttack != null) {
            return false;
        }
        if (this.ticksBeforeFormationRetry > 0) {
            --this.ticksBeforeFormationRetry;
            return false;
        }
        return this.ai.activeFormation != null;
    }

    public void onTickFormation() {
        if (this.ai.activeFormation.leader == this.entInt) {
            return;
        }
        Vec3 vec = this.ai.activeFormation.getPosition((Entity)this.ent);
        if (this.ent.field_70123_F && this.ent.field_70122_E) {
            OldUtil.jump((EntityLivingBase)this.ent);
        }
        if (this.ent.func_70090_H() && this.ent.func_70661_as().func_75500_f() && vec != null && Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y) < 0.1) {
            double waterSpeed = 0.1;
            this.ent.field_70159_w -= Math.cos(((double)(-this.ent.field_70177_z) + 90.0) * 0.01745329) * waterSpeed;
            this.ent.field_70179_y += Math.sin(((double)(-this.ent.field_70177_z) + 90.0) * 0.01745329) * waterSpeed;
        }
        float closeFactor = 1.0f;
        if (!this.ent.field_70122_E) {
            closeFactor = 0.1f;
        }
        float speed = OldUtil.getMoveSpeed((EntityLivingBase)this.ent) * this.ai.lungeFactor * closeFactor;
        if (this.isMovementSafe()) {
            if (vec != null && this.ent.func_70011_f(vec.field_72450_a, this.ent.field_70163_u, vec.field_72449_c) > 0.9) {
                this.ent.func_70605_aq().func_75642_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (double)speed);
            }
        } else {
            this.ticksBeforeFormationRetry = 60;
            if (vec != null) {
                this.ent.func_70661_as().func_75499_g();
                if (this.ent.func_70661_as().func_75500_f() || this.ent.field_70170_p.func_72820_D() % 10L == 0L) {
                    PFQueue.getPath((Entity)this.ent, (int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c, this.ai.maxPFRange);
                }
            }
        }
    }

    public float limitAngle(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void onTickCloseCombat() {
        if (this.entInt.isBreaking()) {
            return;
        }
        if (this.ent.field_70123_F && this.ent.field_70122_E) {
            OldUtil.jump((EntityLivingBase)this.ent);
        }
        float closeFactor = 1.0f;
        float leadFactor = 1.0f;
        float checkAheadFactor = 1.0f;
        if (this.ent.func_70032_d(this.ai.entityToAttack) > 3.0f) {
            leadFactor = this.ai.moveLeadFactorDist;
        }
        if (!this.ent.field_70122_E) {
            closeFactor = 0.1f;
        }
        float speed = OldUtil.getMoveSpeed((EntityLivingBase)this.ent) * this.ai.lungeFactor * closeFactor;
        double leadTicks = this.ai.moveLeadTicks;
        double vecX = (this.ai.entityToAttack.field_70165_t - this.targPrevPosX) * (leadTicks * (double)leadFactor);
        double vecZ = (this.ai.entityToAttack.field_70161_v - this.targPrevPosZ) * (leadTicks * (double)leadFactor);
        double dist = this.ent.func_70032_d(this.ai.entityToAttack);
        if (dist <= 3.0 || this.isMovementSafe()) {
            if (dist > 1.0) {
                this.ent.func_70605_aq().func_75642_a(this.ai.entityToAttack.field_70165_t + vecX, this.ai.entityToAttack.field_70163_u, this.ai.entityToAttack.field_70161_v + vecZ, (double)speed);
            }
        } else {
            this.ticksBeforeCloseCombatRetry = 60;
            this.ai.checkPathfindLock();
            this.ent.func_70661_as().func_75501_e();
            this.ai.tickMovementHelp();
        }
        this.targPrevPosX = this.ai.entityToAttack.field_70165_t;
        this.targPrevPosY = this.ai.entityToAttack.field_70163_u;
        this.targPrevPosZ = this.ai.entityToAttack.field_70161_v;
    }

    public boolean isMovementSafe() {
        double distStart = 0.5;
        double distEnd = 2.0;
        double distStep = 0.5;
        double lookStartStop = 90.0;
        double lookStep = 90.0;
        return this.isMovementSafe(true, true, true, distStart, distEnd, distStep, lookStartStop, lookStep);
    }

    public boolean isMovementSafe(boolean checkThreats, boolean checkDrops, boolean checkWalls, double distStart, double distEnd, double distStep, double lookStartStop, double lookStep) {
        boolean safe = true;
        EntityLiving center = this.ent;
        block0: for (double lookAheadDist = distStart; lookAheadDist <= distEnd; lookAheadDist += distStep) {
            for (double adjAngle = -lookStartStop - lookStep; adjAngle <= lookStartStop; adjAngle += lookStep) {
                int yy;
                double dist = lookAheadDist;
                double posX = center.field_70165_t - Math.sin(((double)(-center.field_70177_z) + adjAngle) * 0.01745329) * dist;
                double posY = center.field_70121_D.field_72338_b;
                double posZ = center.field_70161_v + Math.cos(((double)(-center.field_70177_z) + adjAngle) * 0.01745329) * dist;
                int xx = (int)posX;
                int groundAheadY = yy = (int)(posY - 0.5);
                int legsAheadY = yy + 1;
                int headAheadY = yy + 2;
                yy = (int)(posY - 0.5);
                int zz = (int)posZ;
                if (checkThreats) {
                    Block lookAheadIDDrop = this.ent.field_70170_p.func_147439_a(xx, yy, zz);
                    Block lookAheadIDCollide = this.ent.field_70170_p.func_147439_a(xx, legsAheadY, zz);
                    if (this.ent.field_70122_E && (lookAheadIDDrop.func_149688_o() == Material.field_151587_i || lookAheadIDDrop.func_149688_o() == Material.field_151570_A) || lookAheadIDCollide.func_149688_o() == Material.field_151587_i || lookAheadIDCollide.func_149688_o() == Material.field_151570_A) {
                        safe = false;
                        continue block0;
                    }
                    if (this.ent.field_70122_E && lookAheadIDCollide instanceof BlockFence) {
                        safe = false;
                        continue block0;
                    }
                }
                if (checkDrops) {
                    Block lookAheadIDDrop0 = this.ent.field_70170_p.func_147439_a(xx, yy, zz);
                    Block lookAheadIDDrop1 = this.ent.field_70170_p.func_147439_a(xx, yy - 1, zz);
                    if (CoroUtilBlock.isAir(lookAheadIDDrop0) && CoroUtilBlock.isAir(lookAheadIDDrop1)) {
                        safe = false;
                        continue block0;
                    }
                }
                if (!checkWalls) continue;
                Block lookAheadIDCollideTooHigh = this.ent.field_70170_p.func_147439_a(xx, headAheadY, zz);
                if (!this.ent.field_70122_E || !lookAheadIDCollideTooHigh.func_149688_o().func_76220_a()) continue;
                safe = false;
                continue block0;
            }
        }
        double posX = center.field_70165_t - Math.cos((double)(-center.field_70177_z) * 0.01745329) * 1.0;
        double posY = center.field_70121_D.field_72338_b;
        double posZ = center.field_70161_v + Math.sin((double)(-center.field_70177_z) * 0.01745329) * 1.0;
        return safe;
    }

    public boolean isFacingWater(double distStart, double distEnd, double distStep, double lookStartStop, double lookStep) {
        EntityLiving center = this.ent;
        for (double lookAheadDist = distStart; lookAheadDist <= distEnd; lookAheadDist += distStep) {
            for (double adjAngle = -lookStartStop - lookStep; adjAngle <= lookStartStop; adjAngle += lookStep) {
                int yy;
                double dist = lookAheadDist;
                double posX = center.field_70165_t - Math.sin(((double)(-center.field_70177_z) + adjAngle) * 0.01745329) * dist;
                double posY = center.field_70121_D.field_72338_b;
                double posZ = center.field_70161_v + Math.cos(((double)(-center.field_70177_z) + adjAngle) * 0.01745329) * dist;
                int xx = (int)posX;
                int groundAheadY = yy = (int)(posY - 0.5);
                int legsAheadY = yy + 1;
                int headAheadY = yy + 2;
                yy = (int)(posY - 0.5);
                int zz = (int)posZ;
                Block lookAheadIDDrop0 = this.ent.field_70170_p.func_147439_a(xx, yy, zz);
                if (lookAheadIDDrop0.func_149688_o() == Material.field_151586_h) {
                    return true;
                }
                if (!CoroUtilBlock.isAir(lookAheadIDDrop0)) continue;
                int scanDownY = yy - 1;
                for (int tries = 0; tries < 8; ++tries) {
                    Block tryID;
                    if (CoroUtilBlock.isAir(tryID = this.ent.field_70170_p.func_147439_a(xx, scanDownY--, zz))) continue;
                    return tryID.func_149688_o() == Material.field_151586_h;
                }
            }
        }
        return false;
    }

    public void setPathToEntity(PathEntity pathentity) {
        this.entInt.getAIAgent().setPathToEntityForce(pathentity);
    }

    public boolean isEnemy(Entity ent) {
        return this.tamable.isTame() ? this.tamable.isEnemy(ent) : this.entInt.isEnemy(ent);
    }

    public boolean canJoinFormations() {
        return this.ai.canJoinFormations;
    }

    public void tickCustomMovement() {
    }
}

