/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.formation;

import CoroUtil.componentAI.ICoroAI;
import CoroUtil.formation.PathNavigateFormation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class Formation {
    public double distMax = 96.0;
    public List<ICoroAI> listEntities = new ArrayList<ICoroAI>();
    public ICoroAI leader;
    public EntityLiving leaderEnt;
    public Vec3 targ = null;
    public Vec3 pos = null;
    public double yaw;
    public EntityLivingBase leaderTarget;
    public double smoothYaw;
    public double speedSlowest = 0.28;
    public PathNavigateFormation pathNav = null;
    public int sizeColumns = 10;
    public int sizeRows = 10;

    public static Formation newFormation(ICoroAI parLeader, ICoroAI secondEnt) {
        Formation fm = new Formation();
        fm.joinLeader(parLeader);
        if (secondEnt != null) {
            fm.join(secondEnt);
        }
        fm.pathNav = new PathNavigateFormation(fm.leaderEnt.field_70130_N, fm.leaderEnt.field_70131_O, fm.leaderEnt.field_70170_p, 256.0f);
        return fm;
    }

    public void cleanup() {
        this.listEntities.clear();
    }

    public void tickUpdate() {
        this.sizeColumns = 10;
        this.sizeRows = 10;
        if (this.leaderTarget != null && this.leaderTarget.field_70128_L) {
            this.leaderTarget = null;
        }
        if (this.leaderEnt != null && this.leaderEnt.field_70128_L) {
            this.listEntities.remove(this.leader);
            this.checkLeader(this.leader);
            this.leader = null;
            this.leaderEnt = null;
        }
        if (this.leaderEnt != null) {
            this.pos = this.getPosition((Entity)this.leaderEnt, 1.0f);
            this.yaw = this.leaderEnt.field_70177_z;
            if (this.leaderTarget == null) {
                this.leaderTarget = this.leaderEnt.func_70638_az();
            }
            float bestMove = MathHelper.func_76142_g((float)((float)(this.smoothYaw - this.yaw)));
            float camRotateSpeed = 0.6f;
            if (camRotateSpeed < 0.03f) {
                camRotateSpeed = 0.0f;
            }
            if (bestMove > camRotateSpeed * 1.0f) {
                this.smoothYaw = bestMove < camRotateSpeed * 2.0f ? this.yaw : (this.smoothYaw -= (double)camRotateSpeed);
            } else if (bestMove < camRotateSpeed * 1.0f) {
                this.smoothYaw = bestMove > camRotateSpeed * 2.0f ? this.yaw : (this.smoothYaw += (double)camRotateSpeed);
            }
            while (this.smoothYaw >= 180.0) {
                this.smoothYaw -= 360.0;
            }
            while (this.smoothYaw < -180.0) {
                this.smoothYaw += 360.0;
            }
            if (this.leaderEnt.field_70170_p.func_72820_D() % 40L == 0L) {
                for (int i = 0; i < this.listEntities.size(); ++i) {
                    ICoroAI ent = this.listEntities.get(i);
                    if (ent == null || !((EntityLivingBase)ent).field_70128_L && !(((EntityLivingBase)ent).func_70011_f(this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c) > this.distMax)) continue;
                    this.leave(ent);
                }
            }
        } else {
            this.checkLeader(null);
        }
    }

    public Vec3 getPosition(Entity ent, float par1) {
        if (par1 == 1.0f) {
            return ent.field_70170_p.func_82732_R().func_72345_a(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        }
        double d0 = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)par1;
        double d1 = ent.field_70167_r + (ent.field_70163_u - ent.field_70167_r) * (double)par1;
        double d2 = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)par1;
        return ent.field_70170_p.func_82732_R().func_72345_a(d0, d1, d2);
    }

    public void setDestination(ChunkCoordinates coords) {
        System.out.println("TODO");
    }

    public Vec3 getPosition(Entity ent) {
        if (this.listEntities.contains(ent)) {
            if (this.pos != null) {
                int squareSize;
                this.sizeColumns = squareSize = (int)Math.sqrt(this.listEntities.size());
                int index = this.listEntities.indexOf(ent);
                int row = index / this.sizeColumns;
                int col = index % this.sizeColumns;
                int rows = this.listEntities.size() / this.sizeColumns;
                double spacing = 1.5;
                double adjAngle = 0.0;
                double dist = spacing * (double)row - spacing * (double)rows / 2.0;
                double posX = Math.cos((-this.smoothYaw + (adjAngle -= 90.0)) * 0.01745329) * dist;
                double posZ = Math.sin((-this.smoothYaw + adjAngle) * 0.01745329) * dist;
                dist = spacing * (double)col - spacing * (double)(this.sizeColumns + 1) / 2.0;
                posX += Math.cos((-this.smoothYaw + (adjAngle += 90.0)) * 0.01745329) * dist;
                posZ += Math.sin((-this.smoothYaw + adjAngle) * 0.01745329) * dist;
                posX = this.pos.field_72450_a - posX;
                double posY = this.pos.field_72448_b;
                posZ = this.pos.field_72449_c + posZ;
                Vec3 tryPos = Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
                Block tryID = ent.field_70170_p.func_147439_a((int)tryPos.field_72450_a, (int)tryPos.field_72448_b + 1, (int)tryPos.field_72449_c);
                if (tryID.func_149688_o().func_76220_a()) {
                    Random rand = new Random();
                    double range = 3.0;
                    return this.pos.func_72441_c(rand.nextDouble() * range - rand.nextDouble() * range, 0.0, rand.nextDouble() * range - rand.nextDouble() * range);
                }
                tryPos = Vec3.func_72443_a((double)posX, (double)ent.field_70163_u, (double)posZ);
                return tryPos;
            }
            return null;
        }
        return null;
    }

    public void joinLeader(ICoroAI ent) {
        this.join(ent);
        this.leader = ent;
        this.leaderEnt = (EntityLiving)ent;
    }

    public void join(ICoroAI ent) {
        this.listEntities.add(ent);
        ent.getAIAgent().activeFormation = this;
    }

    public void leave(ICoroAI ent) {
        this.listEntities.remove(ent);
        if (ent.getAIAgent() != null) {
            ent.getAIAgent().activeFormation = null;
        }
        this.checkLeader(ent);
    }

    public void checkLeader(ICoroAI ent) {
        if (this.listEntities.size() > 0) {
            this.leader = this.listEntities.get(0);
            this.leaderEnt = (EntityLiving)this.leader;
        }
    }
}

