/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.entity.EntityLightningBolt;
import weather2.util.WeatherUtilConfig;
import weather2.volcano.VolcanoObject;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.wind.WindManager;

public class WeatherManagerServer
extends WeatherManagerBase {
    public int syncRange = 256;

    public WeatherManagerServer(int parDim) {
        super(parDim);
    }

    @Override
    public World getWorld() {
        return DimensionManager.getWorld((int)this.dim);
    }

    @Override
    public void tick() {
        super.tick();
        World world = this.getWorld();
        if (world != null) {
            StormObject so;
            int i;
            if (!ConfigMisc.overcastMode && ConfigMisc.lockServerWeatherMode != -1) {
                world.func_72912_H().func_76084_b(ConfigMisc.lockServerWeatherMode == 1);
                world.func_72912_H().func_76069_a(ConfigMisc.lockServerWeatherMode == 1);
            }
            if (ConfigMisc.preventServerThunderstorms) {
                world.func_72912_H().func_76069_a(false);
            }
            if (world.func_82737_E() % 400L == 0L) {
                this.isVanillaRainActiveOnServer = this.getWorld().func_72896_J();
                this.syncWeatherVanilla();
            }
            if (world.func_82737_E() % 400L == 0L) {
                // empty if block
            }
            for (i = 0; i < this.getStormObjects().size(); ++i) {
                so = this.getStormObjects().get(i);
                if (world.func_82737_E() % (long)(so.levelCurIntensityStage >= StormObject.STATE_HIGHWIND ? 2 : 40) != 0L) continue;
                this.syncStormUpdate(so);
            }
            if (world.func_82737_E() % 40L == 0L) {
                for (i = 0; i < this.getVolcanoObjects().size(); ++i) {
                    this.syncVolcanoUpdate(this.getVolcanoObjects().get(i));
                }
            }
            if (world.func_82737_E() % 60L == 0L) {
                this.syncWindUpdate(this.windMan);
            }
            this.getVolcanoObjects().clear();
            if (WeatherUtilConfig.listDimensionsClouds.contains(world.field_73011_w.field_76574_g) && world.func_82737_E() % 20L == 0L) {
                for (i = 0; i < this.getStormObjects().size(); ++i) {
                    so = this.getStormObjects().get(i);
                    EntityPlayer closestPlayer = world.func_72977_a(so.posGround.field_72450_a, so.posGround.field_72448_b, so.posGround.field_72449_c, (double)ConfigMisc.Misc_simBoxRadiusCutoff);
                    if (closestPlayer != null) continue;
                    this.removeStormObject(so.ID);
                    this.syncStormRemove(so);
                }
                Random rand = new Random();
                for (int i2 = 0; i2 < world.field_73010_i.size(); ++i2) {
                    EntityPlayer entP = (EntityPlayer)world.field_73010_i.get(i2);
                    if (this.getStormObjectsByLayer(0).size() < ConfigMisc.Storm_MaxPerPlayerPerLayer * world.field_73010_i.size() && rand.nextInt(5) == 0) {
                        this.trySpawnNearPlayerForLayer(entP, 0);
                    }
                    if (this.getStormObjectsByLayer(1).size() < ConfigMisc.Storm_MaxPerPlayerPerLayer * world.field_73010_i.size() && ConfigMisc.Cloud_Layer1_Enable && rand.nextInt(5) != 0) continue;
                }
            }
        }
    }

    public void trySpawnNearPlayerForLayer(EntityPlayer entP, int layer) {
        Random rand = new Random();
        int tryCountMax = 10;
        int tryCountCur = 0;
        int spawnX = -1;
        int spawnZ = -1;
        Vec3 tryPos = null;
        StormObject soClose = null;
        EntityPlayer playerClose = null;
        int closestToPlayer = 128;
        float windOffsetDist = Math.min(256, ConfigMisc.Misc_simBoxRadiusCutoff / 4 * 3);
        double angle = this.windMan.getWindAngleForClouds();
        double vecX = -Math.sin(Math.toRadians(angle)) * (double)windOffsetDist;
        double vecZ = Math.cos(Math.toRadians(angle)) * (double)windOffsetDist;
        while (tryCountCur++ == 0 || tryCountCur < tryCountMax && (soClose != null || playerClose != null)) {
            spawnX = (int)(entP.field_70165_t - vecX + (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn) - (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn));
            spawnZ = (int)(entP.field_70161_v - vecZ + (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn) - (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn));
            tryPos = Vec3.func_72443_a((double)spawnX, (double)StormObject.layers.get(layer).intValue(), (double)spawnZ);
            soClose = this.getClosestStormAny(tryPos, ConfigMisc.Cloud_Formation_MinDistBetweenSpawned);
            playerClose = entP.field_70170_p.func_72977_a((double)spawnX, 50.0, (double)spawnZ, (double)closestToPlayer);
        }
        if (soClose == null) {
            StormObject so = new StormObject(this);
            so.initFirstTime();
            so.pos = tryPos;
            so.layer = layer;
            so.userSpawnedFor = CoroUtilEntity.getName((Entity)entP);
            this.addStormObject(so);
            this.syncStormNew(so);
        } else {
            Weather.dbg("couldnt find space to spawn cloud formation");
        }
    }

    public void playerJoinedServerSyncFull(EntityPlayerMP entP) {
        World world = this.getWorld();
        if (world != null) {
            int i;
            for (i = 0; i < this.getStormObjects().size(); ++i) {
                this.syncStormNew(this.getStormObjects().get(i), entP);
            }
            for (i = 0; i < this.getVolcanoObjects().size(); ++i) {
                this.syncVolcanoNew(this.getVolcanoObjects().get(i), entP);
            }
        }
    }

    public void syncLightningNew(EntityLightningBolt parEnt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncLightningNew");
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("posX", MathHelper.func_76128_c((double)parEnt.field_70165_t));
        nbt.func_74768_a("posY", MathHelper.func_76128_c((double)parEnt.field_70163_u));
        nbt.func_74768_a("posZ", MathHelper.func_76128_c((double)parEnt.field_70161_v));
        nbt.func_74768_a("entityID", parEnt.func_145782_y());
        data.func_74782_a("data", (NBTBase)nbt);
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
    }

    public void syncWindUpdate(WindManager parManager) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncWindUpdate");
        data.func_74782_a("data", (NBTBase)parManager.nbtSyncForClient());
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
    }

    public void syncStormNew(StormObject parStorm) {
        this.syncStormNew(parStorm, null);
    }

    public void syncStormNew(StormObject parStorm, EntityPlayerMP entP) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncStormNew");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        if (entP == null) {
            Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
        } else {
            Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), entP);
        }
    }

    public void syncStormUpdate(StormObject parStorm) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncStormUpdate");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
    }

    public void syncStormRemove(StormObject parStorm) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncStormRemove");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        data.func_74775_l("data").func_74757_a("isDead", true);
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
    }

    public void syncVolcanoNew(VolcanoObject parStorm) {
        this.syncVolcanoNew(parStorm, null);
    }

    public void syncVolcanoNew(VolcanoObject parStorm, EntityPlayerMP entP) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncVolcanoNew");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        if (entP == null) {
            Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
        } else {
            Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), entP);
        }
    }

    public void syncVolcanoUpdate(VolcanoObject parStorm) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncVolcanoUpdate");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
    }

    public void syncVolcanoRemove(VolcanoObject parStorm) {
    }

    public void syncWeatherVanilla() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncWeatherUpdate");
        data.func_74757_a("isVanillaRainActiveOnServer", this.isVanillaRainActiveOnServer);
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.field_76574_g);
    }
}

