/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds;

import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilEntity;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.ai.invasion.WorldEvent;
import hostileworlds.entity.EntityMeteorite;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class EventHandlerPacket {
    @SideOnly(value=Side.CLIENT)
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound((ByteBuf)event.packet.payload());
            String packetCommand = nbt.func_74779_i("packetCommand");
            if (packetCommand.equals("Meteor")) {
                int state = nbt.func_74762_e("state");
                World world = this.getClientWorld();
                if (state == 0) {
                    EntityMeteorite ent = new EntityMeteorite(world);
                    ent.func_145769_d(nbt.func_74762_e("entityID"));
                    ent.func_70107_b(nbt.func_74760_g("x"), nbt.func_74760_g("y"), nbt.func_74760_g("z"));
                    ent.func_70016_h(nbt.func_74760_g("vecX"), nbt.func_74760_g("vecY"), nbt.func_74760_g("vecZ"));
                    System.out.println("spawning client meteor: " + ent.func_145782_y());
                    world.func_72942_c((Entity)ent);
                } else if (state == 1) {
                    int id = nbt.func_74762_e("entityID");
                    Entity ent = null;
                    for (int i = 0; i < world.field_73007_j.size(); ++i) {
                        Entity we = (Entity)world.field_73007_j.get(i);
                        if (we.func_145782_y() != id) continue;
                        ent = we;
                        break;
                    }
                    if (ent != null) {
                        ent.func_70107_b((double)nbt.func_74760_g("x"), (double)nbt.func_74760_g("y"), (double)nbt.func_74760_g("z"));
                        ent.func_70016_h((double)nbt.func_74760_g("vecX"), (double)nbt.func_74760_g("vecY"), (double)nbt.func_74760_g("vecZ"));
                    } else {
                        System.out.println("received meteor update packet for non existing id: " + id);
                    }
                } else if (state == 2) {
                    int id = nbt.func_74762_e("entityID");
                    Entity ent = null;
                    for (int i = 0; i < world.field_73007_j.size(); ++i) {
                        Entity we = (Entity)world.field_73007_j.get(i);
                        if (we.func_145782_y() != id) continue;
                        ent = we;
                        break;
                    }
                    if (ent != null) {
                        System.out.println("killing client meteor: " + ent.func_145782_y());
                        if (ent instanceof EntityMeteorite) {
                            ((EntityMeteorite)ent).func_70106_y();
                        }
                    } else {
                        System.out.println("received meteor kill packet for non existing id: " + id);
                    }
                }
            } else if (packetCommand.equals("InvasionData")) {
                WorldDirectorMultiDim.clientPlayersCooldown = nbt.func_74762_e("cooldown");
                WorldDirectorMultiDim.clientPlayerInvadeValue = nbt.func_74760_g("invadeValue");
                int dimID = nbt.func_74762_e("dimID");
                NBTTagCompound nbtData = nbt.func_74775_l("invasionListing");
                WorldDirectorMultiDim.clientCurInvasions = new HashMap();
                WorldDirectorMultiDim.clientCurInvasions.put(dimID, new ArrayList());
                WorldDirectorMultiDim.clientCurInvasions.get(dimID).clear();
                for (String tagName : nbtData.func_150296_c()) {
                    NBTTagCompound entry = nbtData.func_74775_l(tagName);
                    WorldEvent wEvent = WorldEvent.newInvasionFromNBT(entry);
                    WorldDirectorMultiDim.clientCurInvasions.get(dimID).add(wEvent);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            ByteBuf buffer = event.packet.payload();
            int commandID = buffer.readInt();
            int slotID = buffer.readInt();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getSelfUsername() {
        return CoroUtilEntity.getName((Entity)Minecraft.func_71410_x().field_71439_g);
    }
}

