/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.packet.PacketHelper;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFCallbackItem;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilFile;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.AreaScanner;
import hostileworlds.ai.CursedAreaCoordinates;
import hostileworlds.ai.invasion.InvasionCaves;
import hostileworlds.ai.invasion.InvasionPortalCatacombs;
import hostileworlds.ai.invasion.WorldEvent;
import hostileworlds.ai.jobs.JobGroupHorde;
import hostileworlds.config.ModConfigFields;
import hostileworlds.entity.EntityInvader;
import hostileworlds.entity.EntityMeteorite;
import hostileworlds.entity.monster.Zombie;
import hostileworlds.entity.monster.ZombieMiner;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class WorldDirectorMultiDim
implements IPFCallback {
    public int detectedIDCatacombs;
    public static HashMap<Integer, ArrayList<WorldEvent>> curInvasions = new HashMap();
    public static HashMap<Integer, ArrayList<CursedAreaCoordinates>> coordCurses = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordinates>> coordSurfaceCaves = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordinates>> coordCaves = new HashMap();
    public static HashMap<Integer, ArrayList<ChunkCoordinates>> coordInvasionSources = new HashMap();
    public static HashMap<Integer, ArrayList<WorldEvent>> clientCurInvasions = new HashMap();
    public static int clientPlayersCooldown;
    public static float clientPlayerInvadeValue;
    public HashMap<String, ChunkCoordinates> lastCursePlayerLocations;
    public HashMap<String, ChunkCoordinates> lastScanPlayerLocations;
    public static HashMap<String, NBTTagCompound> playerNBT;
    public AreaScanner areaScanner;
    public boolean scanning;
    public int maxActiveInvasionsPerPlayer = 1;
    public ArrayList<PFCallbackItem> queue = new ArrayList();
    public boolean waitingOnPF = false;

    public WorldDirectorMultiDim() {
        this.lastScanPlayerLocations = new HashMap();
    }

    public void onTick() {
        if (!ModConfigFields.debugTickMain) {
            return;
        }
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            WorldServer world = worlds[i];
            this.onTickWorld((World)world);
        }
    }

    public static void resetDimData() {
        WorldDirectorMultiDim.dbg("Resetting HW Data");
        curInvasions = new HashMap();
        coordCurses = new HashMap();
        coordSurfaceCaves = new HashMap();
        coordCaves = new HashMap();
        coordInvasionSources = new HashMap();
    }

    public static void initDimData(World world) {
        WorldDirectorMultiDim.initDimData(world.field_73011_w.field_76574_g);
    }

    public static void initDimData(int dimID) {
        WorldDirectorMultiDim.dbg("Initializing HW Data for dim: " + dimID);
        curInvasions.put(dimID, new ArrayList());
        coordCurses.put(dimID, new ArrayList());
        coordSurfaceCaves.put(dimID, new ArrayList());
        coordCaves.put(dimID, new ArrayList());
        coordInvasionSources.put(dimID, new ArrayList());
    }

    public static NBTTagCompound getPlayerNBT(String username) {
        if (!playerNBT.containsKey(username)) {
            WorldDirectorMultiDim.tryLoadPlayerNBT(username);
        }
        return playerNBT.get(username);
    }

    public static void tryLoadPlayerNBT(String username) {
        NBTTagCompound playerData = new NBTTagCompound();
        try {
            String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "HWPlayerData" + File.separator + username + ".dat";
            if (new File(fileURL).exists()) {
                playerData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            }
        }
        catch (Exception ex) {
            HostileWorlds.dbg("no saved data found for " + username);
        }
        playerNBT.put(username, playerData);
    }

    public static void writeAllPlayerNBT() {
        HostileWorlds.dbg("writing out all player nbt");
        String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "HWPlayerData";
        if (!new File(fileURL).exists()) {
            new File(fileURL).mkdir();
        }
        for (Map.Entry<String, NBTTagCompound> pairs : playerNBT.entrySet()) {
            HostileWorlds.dbg(pairs.getKey() + " = " + pairs.getValue());
            WorldDirectorMultiDim.writePlayerNBT(pairs.getKey(), pairs.getValue());
        }
    }

    public static void writePlayerNBT(String username, NBTTagCompound parData) {
        HostileWorlds.dbg("writing " + username);
        String fileURL = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + File.separator + "HWPlayerData" + File.separator + username + ".dat";
        try {
            FileOutputStream fos = new FileOutputStream(fileURL);
            CompressedStreamTools.func_74799_a((NBTTagCompound)parData, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HostileWorlds.dbg("Error writing HW player data for " + username);
        }
    }

    public void onTickWorld(World world) {
        int i;
        int dim = world.field_73011_w.field_76574_g;
        if (coordSurfaceCaves.get(dim) == null) {
            WorldDirectorMultiDim.initDimData(world);
        }
        for (i = 0; i < curInvasions.get(dim).size(); ++i) {
            WorldEvent invasion = curInvasions.get(dim).get(i);
            invasion.tick();
            if (!invasion.isComplete()) continue;
            curInvasions.get(dim).remove(i);
            WorldDirectorMultiDim.dbg("removing complete invasion: " + invasion + " - user: " + invasion.mainPlayerName);
        }
        if (world.func_72820_D() % 40L == 0L) {
            for (i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer entP = (EntityPlayer)world.field_73010_i.get(i);
                if (entP == null || entP.field_70128_L) continue;
                HostileWorlds.eventChannel.sendTo(WorldDirectorMultiDim.getInvasionDataPacketForPlayer(dim, CoroUtilEntity.getName((Entity)entP)), (EntityPlayerMP)entP);
            }
        }
        if (world.field_73011_w.field_76574_g == 0) {
            this.onTickOverworld(world);
        }
    }

    public static void dbg(Object obj) {
        HostileWorlds.dbg(obj);
    }

    public boolean isCoordAndNearAreaNaturalBlocks(World parWorld, int x, int y, int z, int range) {
        return this.isNaturalSurfaceBlock(parWorld.func_147439_a(x, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x + range, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x - range, y, z)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x, y, z + range)) && this.isNaturalSurfaceBlock(parWorld.func_147439_a(x, y, z - range));
    }

    public boolean isNaturalSurfaceBlock(Block id) {
        if (id == Blocks.field_150433_aE || id == Blocks.field_150349_c || id == Blocks.field_150346_d || id == Blocks.field_150354_m || id == Blocks.field_150348_b || id == Blocks.field_150351_n || id == Blocks.field_150329_H) {
            return true;
        }
        return this.isLogOrLeafBlock(id);
    }

    public boolean isLogOrLeafBlock(Block id) {
        if (id == null) {
            return false;
        }
        if (id.func_149688_o() == Material.field_151584_j) {
            return true;
        }
        if (id.func_149688_o() == Material.field_151585_k) {
            return true;
        }
        return id.func_149688_o() == Material.field_151575_d;
    }

    public int getInvasionCountForPlayer(EntityPlayer entP) {
        int count = 0;
        for (int i = 0; i < curInvasions.get(entP.field_71093_bK).size(); ++i) {
            WorldEvent invasion = curInvasions.get(entP.field_71093_bK).get(i);
            if (!invasion.mainPlayerName.equalsIgnoreCase(CoroUtilEntity.getName((Entity)entP))) continue;
            ++count;
        }
        return count;
    }

    public boolean isCursed(EntityPlayer entP) {
        return true;
    }

    public ArrayList<ChunkCoordinates> getUnusedInvasionSourcesInRange(ArrayList<ChunkCoordinates> collection, EntityPlayer entP, float range) {
        return this.getUnusedInvasionSourcesInRange(collection, new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v), entP.field_71093_bK, range);
    }

    public ArrayList<ChunkCoordinates> getUnusedInvasionSourcesInRange(ArrayList<ChunkCoordinates> collection, ChunkCoordinates parCoords, int dim, float range) {
        ArrayList<ChunkCoordinates> coordList = new ArrayList<ChunkCoordinates>();
        for (int i = 0; i < collection.size(); ++i) {
            ChunkCoordinates coords = collection.get(i);
            if (this.isValid(dim, coords)) {
                if (!(OldUtil.getDistanceXZ((ChunkCoordinates)parCoords, (ChunkCoordinates)coords) < (double)range) || !ModConfigFields.invasionManyPerPortal && this.isInUse(dim, coords)) continue;
                coordList.add(coords);
                continue;
            }
            collection.remove(coords);
        }
        return coordList;
    }

    public boolean isInUse(int dim, ChunkCoordinates coords) {
        for (int i = 0; i < curInvasions.get(dim).size(); ++i) {
            if (WorldDirectorMultiDim.curInvasions.get((Object)Integer.valueOf((int)dim)).get((int)i).coordSource != coords) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(int dim, ChunkCoordinates coords) {
        return this.getSourceType(dim, coords) != null;
    }

    public boolean isValidSourceBlockID(Block id) {
        return id == HostileWorlds.blockSourceInvasion || id == Blocks.field_150427_aO;
    }

    public WorldEvent.EnumWorldEventType getSourceType(int dim, ChunkCoordinates coords) {
        Block id = DimensionManager.getWorld((int)dim).func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (id == HostileWorlds.blockSourceInvasion) {
            return WorldEvent.EnumWorldEventType.INV_PORTAL_CATACOMBS;
        }
        if (id == Blocks.field_150427_aO) {
            return WorldEvent.EnumWorldEventType.INV_PORTAL_NETHER;
        }
        if (coordCaves.get(dim).contains(coords)) {
            return WorldEvent.EnumWorldEventType.INV_CAVE;
        }
        return null;
    }

    public void onTickOverworld(World world) {
        EntityPlayer entP;
        int i;
        if (ModConfigFields.autoSaveFrequencyInTicks > 0 && world.func_72820_D() % (long)ModConfigFields.autoSaveFrequencyInTicks == 0L) {
            HostileWorlds.instance.writeGameNBT();
        }
        for (i = 0; i < world.field_73010_i.size(); ++i) {
            boolean initialized;
            entP = (EntityPlayer)world.field_73010_i.get(i);
            if (entP == null || entP.field_70128_L || ModConfigFields.noInvadeWhitelist.contains(CoroUtilEntity.getName((Entity)entP))) continue;
            NBTTagCompound playerData = WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)entP));
            int time = playerData.func_74762_e("HWPortalTime");
            if (time > 0) {
                playerData.func_74768_a("HWPortalTime", --time);
            }
            if (!(initialized = playerData.func_74767_n("HWFirstCooldownInitialized"))) {
                playerData.func_74768_a("HWInvasionCooldown", ModConfigFields.coolDownFirstTime);
                playerData.func_74757_a("HWFirstCooldownInitialized", true);
            }
            boolean canInvade = false;
            if (ModConfigFields.timeBasedInvasionsInstead) {
                int cooldown = playerData.func_74762_e("HWInvasionCooldown");
                if (cooldown > 0) {
                    playerData.func_74768_a("HWInvasionCooldown", --cooldown);
                }
                if (cooldown <= 0) {
                    canInvade = true;
                }
            } else if (WorldDirectorMultiDim.isInvadeable(entP)) {
                canInvade = true;
            }
            int maxDistance = ModConfigFields.meteorCrashDistFromPlayerMax;
            int minDistance = ModConfigFields.meteorCrashDistFromPlayerMin;
            if (world.func_72820_D() % 100L == 0L && ModConfigFields.debugDoAreaScans) {
                this.tryAreaScan(entP);
            }
            if (!canInvade || !this.isCursed(entP) || this.getInvasionCountForPlayer(entP) >= this.maxActiveInvasionsPerPlayer) continue;
            WorldDirectorMultiDim.dbg("start try invasion logic");
            Random rand = new Random();
            int[] typeWeights = new int[]{70, 30};
            int totalWeight = 0;
            for (int ii = 0; ii < typeWeights.length; ++ii) {
                totalWeight += typeWeights[ii];
            }
            int randomIndex = -1;
            double random = Math.random() * (double)totalWeight;
            for (int ii = 0; ii < typeWeights.length; ++ii) {
                if (!((random -= (double)typeWeights[ii]) <= 0.0)) continue;
                randomIndex = ii;
                break;
            }
            ArrayList<Object> invasionSources = new ArrayList();
            ChunkCoordinates finalSource = null;
            boolean spawnInvasion = false;
            boolean keepTry = true;
            WorldEvent.EnumWorldEventType invType = WorldEvent.EnumWorldEventType.INV_CAVE;
            if (ModConfigFields.invasionCaves && coordInvasionSources.get(entP.field_71093_bK).size() > 0 && randomIndex == 0 && coordCaves.get(entP.field_71093_bK).size() > 0) {
                invasionSources = this.getUnusedInvasionSourcesInRange(coordCaves.get(entP.field_71093_bK), entP, ModConfigFields.invasionCaveMaxDistStart);
                WorldDirectorMultiDim.dbg("cave source size: " + invasionSources.size());
                if (invasionSources.size() > 0) {
                    invType = WorldEvent.EnumWorldEventType.INV_CAVE;
                    keepTry = false;
                }
            }
            if (keepTry || randomIndex == 1) {
                WorldDirectorMultiDim.dbg("trying portal source");
                if (coordInvasionSources.get(entP.field_71093_bK).size() > 0 && (invasionSources = this.getUnusedInvasionSourcesInRange(coordInvasionSources.get(entP.field_71093_bK), entP, maxDistance)).size() > 0) {
                    invType = WorldEvent.EnumWorldEventType.INV_PORTAL_CATACOMBS;
                    keepTry = false;
                }
            }
            WorldDirectorMultiDim.dbg("keeptry: " + keepTry);
            boolean spawnMeteor = false;
            if (invasionSources.size() > 0) {
                while (finalSource == null && invasionSources.size() > 0) {
                    TileEntity tEnt;
                    spawnInvasion = true;
                    if (invasionSources.size() == 1) {
                        finalSource = (ChunkCoordinates)invasionSources.get(0);
                    } else {
                        int choice = rand.nextInt(invasionSources.size());
                        finalSource = (ChunkCoordinates)invasionSources.get(choice);
                    }
                    if (invType != WorldEvent.EnumWorldEventType.INV_PORTAL_CATACOMBS || (tEnt = world.func_147438_o(finalSource.field_71574_a, finalSource.field_71572_b, finalSource.field_71573_c)) != null) continue;
                    invasionSources.remove(finalSource);
                    finalSource = null;
                    spawnInvasion = false;
                }
            }
            if (finalSource == null) {
                WorldDirectorMultiDim.dbg("couldnt find a source, meteorite based invasion!");
                invType = WorldEvent.EnumWorldEventType.INV_PORTAL_CATACOMBS;
                spawnInvasion = true;
                spawnMeteor = true;
            }
            if (!spawnInvasion) continue;
            ChunkCoordinates curseCoord = new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v);
            WorldEvent invasion = null;
            if (invType == WorldEvent.EnumWorldEventType.INV_PORTAL_CATACOMBS) {
                WorldDirectorMultiDim.dbg("spawn hw portal invasion!");
                invasion = new InvasionPortalCatacombs(world.field_73011_w.field_76574_g, CoroUtilEntity.getName((Entity)entP), invType, finalSource, curseCoord);
                if (ModConfigFields.timeBasedInvasionsInstead) {
                    playerData.func_74768_a("HWInvasionCooldown", ModConfigFields.coolDownBetweenInvasionsPortal);
                } else {
                    WorldDirectorMultiDim.decreaseInvadeRating(entP, WorldDirectorMultiDim.getHarvestRatingInvadeThreshold() / 2.0f);
                }
            } else if (invType == WorldEvent.EnumWorldEventType.INV_CAVE) {
                WorldDirectorMultiDim.dbg("spawn cave invasion!");
                invasion = new InvasionCaves(world.field_73011_w.field_76574_g, CoroUtilEntity.getName((Entity)entP), invType, finalSource, curseCoord);
                if (ModConfigFields.timeBasedInvasionsInstead) {
                    playerData.func_74768_a("HWInvasionCooldown", ModConfigFields.coolDownBetweenInvasionsCave);
                } else {
                    WorldDirectorMultiDim.decreaseInvadeRating(entP, WorldDirectorMultiDim.getHarvestRatingInvadeThreshold() / 2.0f);
                }
            }
            boolean foundSafeSpot = false;
            if (spawnMeteor) {
                ChunkCoordinates dest = null;
                int randX = -1;
                int randZ = -1;
                for (int tries = 0; !foundSafeSpot && tries < 100; ++tries) {
                    randX = (int)entP.field_70165_t - maxDistance / 2 + entP.field_70170_p.field_73012_v.nextInt(maxDistance);
                    if (!(entP.func_70011_f((double)randX, entP.field_70163_u, (double)(randZ = (int)entP.field_70161_v - maxDistance / 2 + entP.field_70170_p.field_73012_v.nextInt(maxDistance))) > (double)minDistance)) continue;
                    int tryY = entP.field_70170_p.func_72976_f(randX, randZ) - 1;
                    Block id = world.func_147439_a(randX, tryY, randZ);
                    if (!this.isCoordAndNearAreaNaturalBlocks(world, randX, tryY, randZ, 8)) continue;
                    while (this.isLogOrLeafBlock(id)) {
                        id = world.func_147439_a(randX, tryY -= 2, randZ);
                    }
                    WorldDirectorMultiDim.dbg("Found safe crash site! " + randX + " - " + tryY + " - " + randZ);
                    foundSafeSpot = true;
                    dest = new ChunkCoordinates(randX, tryY, randZ);
                }
                if (foundSafeSpot) {
                    ChunkCoordinates spawn = new ChunkCoordinates((int)entP.field_70165_t - maxDistance / 2 + entP.field_70170_p.field_73012_v.nextInt(maxDistance), 500, (int)entP.field_70161_v - maxDistance / 2 + entP.field_70170_p.field_73012_v.nextInt(maxDistance));
                    this.eventMeteorite(world, spawn, dest, invasion);
                } else {
                    WorldDirectorMultiDim.dbg("couldnt find a safe crash spot D:");
                }
            }
            if (spawnMeteor && !foundSafeSpot) continue;
            curInvasions.get(entP.field_71093_bK).add(invasion);
        }
        for (i = 0; i < world.field_73010_i.size(); ++i) {
            entP = (EntityPlayer)world.field_73010_i.get(i);
            if (entP == null || entP.field_70128_L || world.func_72820_D() % 400L != 0L) continue;
            this.tryCurseUpdate(entP);
        }
    }

    public boolean tryCurseUpdate(EntityPlayer entP) {
        return false;
    }

    public void eventMeteorite(World world, ChunkCoordinates spawn, ChunkCoordinates impact, WorldEvent parInvasion) {
        EntityMeteorite ent = new EntityMeteorite(world, impact, parInvasion);
        Random rand = new Random();
        ent.func_70107_b(spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c);
        HostileWorlds.eventChannel.sendToDimension(WorldDirectorMultiDim.getMeteorPacket(ent, 0), ent.field_71093_bK);
        ent.field_70170_p.field_73007_j.add(ent);
    }

    public static FMLProxyPacket getMeteorPacket(Entity ent, int type) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("packetCommand", "Meteor");
        nbt.func_74768_a("state", type);
        nbt.func_74768_a("entityID", ent.func_145782_y());
        nbt.func_74776_a("x", (float)ent.field_70165_t);
        nbt.func_74776_a("y", (float)ent.field_70163_u);
        nbt.func_74776_a("z", (float)ent.field_70161_v);
        nbt.func_74776_a("vecX", (float)ent.field_70159_w);
        nbt.func_74776_a("vecY", (float)ent.field_70181_x);
        nbt.func_74776_a("vecZ", (float)ent.field_70179_y);
        return PacketHelper.getNBTPacket((NBTTagCompound)nbt, (String)HostileWorlds.eventChannelName);
    }

    public static FMLProxyPacket getInvasionDataPacketForPlayer(int dim, String player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("packetCommand", "InvasionData");
        EntityPlayerMP entP = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(player);
        if (ModConfigFields.timeBasedInvasionsInstead) {
            nbt.func_74768_a("cooldown", WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)entP)).func_74762_e("HWInvasionCooldown"));
        } else {
            nbt.func_74768_a("cooldown", -1);
        }
        nbt.func_74776_a("invadeValue", WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)entP)).func_74760_g("harvested_Rating"));
        nbt.func_74768_a("dimID", dim);
        NBTTagCompound nbtListing = new NBTTagCompound();
        for (int j = 0; j < curInvasions.get(dim).size(); ++j) {
            WorldEvent invasion = curInvasions.get(dim).get(j);
            NBTTagCompound nbtEntry = new NBTTagCompound();
            invasion.writeNBT(nbtEntry);
            nbtListing.func_74782_a("entry_" + j, (NBTBase)nbtEntry);
        }
        nbt.func_74782_a("invasionListing", (NBTBase)nbtListing);
        return PacketHelper.getNBTPacket((NBTTagCompound)nbt, (String)HostileWorlds.eventChannelName);
    }

    public static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutputStream par1DataOutputStream) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutputStream.writeShort((short)abyte.length);
            par1DataOutputStream.write(abyte);
        }
    }

    public boolean triggerHordeEvent(World world, ChunkCoordinates curseCoord, ChunkCoordinates destCoord) {
        int dim = world.field_73011_w.field_76574_g;
        ChunkCoordinates bestCave = null;
        float closest = 99999.0f;
        Random rand = new Random(world.func_72820_D());
        int i = rand.nextInt(coordSurfaceCaves.get(dim).size());
        int tries = 0;
        int min = 10;
        int max = 100;
        while (closest > (float)max && tries++ < 200) {
            float dist;
            i = rand.nextInt(coordSurfaceCaves.get(dim).size());
            if (!world.func_72863_F().func_73149_a(WorldDirectorMultiDim.coordSurfaceCaves.get((Object)Integer.valueOf((int)dim)).get((int)i).field_71574_a / 16, WorldDirectorMultiDim.coordSurfaceCaves.get((Object)Integer.valueOf((int)dim)).get((int)i).field_71573_c / 16) || !((dist = (float)Math.sqrt(coordSurfaceCaves.get(dim).get(i).func_71569_e(curseCoord.field_71574_a, curseCoord.field_71572_b, curseCoord.field_71573_c))) < closest) || !(dist > (float)min)) continue;
            closest = dist;
            bestCave = coordSurfaceCaves.get(dim).get(i);
        }
        if (!(closest <= (float)max) || !(closest > (float)min) || bestCave == null) {
            WorldDirectorMultiDim.dbg("failed to find close cave, closest: " + closest + ", " + tries);
            return false;
        }
        WorldDirectorMultiDim.dbg(world.field_73011_w.field_76574_g + ": Horde Spawn Event: " + bestCave.field_71574_a + ", " + bestCave.field_71572_b + ", " + bestCave.field_71573_c);
        this.spawnHorde(world, curseCoord, bestCave);
        return true;
    }

    public float distanceTo(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = x2 - x1;
        float f1 = y2 - y1;
        float f2 = z2 - z1;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void spawnHorde(World world, ChunkCoordinates attackCoord, ChunkCoordinates spawnCoord) {
        WorldDirectorMultiDim.dbg(world.field_73011_w.field_76574_g + ": Horde Spawn Event: " + spawnCoord.field_71574_a + ", " + spawnCoord.field_71572_b + ", " + spawnCoord.field_71573_c);
        Zombie zombie = null;
        for (int i = 0; i < 10; ++i) {
            zombie = new Zombie(world);
            zombie.func_70107_b(spawnCoord.field_71574_a, spawnCoord.field_71572_b + 2, spawnCoord.field_71573_c);
            if (attackCoord != null) {
                ((JobGroupHorde)zombie.getAIAgent().jobMan.priJob).attackCoord = attackCoord;
            } else {
                EntityPlayer entP = world.func_72890_a((Entity)zombie, -1.0);
                if (entP != null) {
                    WorldDirectorMultiDim.dbg("setting player coords");
                    ((JobGroupHorde)zombie.getAIAgent().jobMan.priJob).attackCoord = new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v);
                }
            }
            world.func_72838_d((Entity)zombie);
        }
    }

    public boolean tryAreaScan(EntityPlayer entP) {
        boolean debug = false;
        if (!this.scanning && entP.field_70170_p.func_82737_E() % 1200L == 0L && (debug || !this.lastScanPlayerLocations.containsKey(CoroUtilEntity.getName((Entity)entP)) || Math.sqrt(this.lastScanPlayerLocations.get(CoroUtilEntity.getName((Entity)entP)).func_71569_e((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v)) > 64.0)) {
            this.lastScanPlayerLocations.put(CoroUtilEntity.getName((Entity)entP), new ChunkCoordinates((int)entP.field_70165_t, (int)entP.field_70163_u, (int)entP.field_70161_v));
            if (entP.field_70170_p.field_73011_w.func_80007_l().equalsIgnoreCase("catacombs")) {
                this.areaScanner = new AreaScanner(this, entP.field_70170_p);
                this.areaScanner.pfToPlayer = true;
                new Thread((Runnable)this.areaScanner, "HW Area Scanner").start();
            } else {
                this.areaScanner = new AreaScanner(this, entP.field_70170_p);
                new Thread((Runnable)this.areaScanner, "HW Area Scanner").start();
            }
            this.scanning = true;
        }
        return false;
    }

    public synchronized void areaScanCompleteCallback() {
        coordSurfaceCaves.put(this.areaScanner.world.field_73011_w.field_76574_g, this.areaScanner.tempSurfaceCaves);
        coordCaves.put(this.areaScanner.world.field_73011_w.field_76574_g, this.areaScanner.tempCaves);
        this.scanning = false;
        WorldDirectorMultiDim.dbg("Hostile worlds dim " + this.areaScanner.world.field_73011_w.field_76574_g + ": Area scan complete, surface caves: " + coordSurfaceCaves.get(this.areaScanner.world.field_73011_w.field_76574_g).size() + ", caves: " + coordCaves.get(this.areaScanner.world.field_73011_w.field_76574_g).size());
    }

    public boolean triggerEvent(World world, ChunkCoordinates curseCoord) {
        int dim = world.field_73011_w.field_76574_g;
        ChunkCoordinates bestCave = null;
        float closest = 99999.0f;
        Random rand = new Random(world.func_72820_D());
        int i = rand.nextInt(coordCaves.get(dim).size());
        int tries = 0;
        while (closest > 160.0f && tries++ < 100) {
            float dist;
            i = rand.nextInt(coordCaves.get(dim).size());
            if (!world.func_72863_F().func_73149_a(WorldDirectorMultiDim.coordCaves.get((Object)Integer.valueOf((int)dim)).get((int)i).field_71574_a / 16, WorldDirectorMultiDim.coordCaves.get((Object)Integer.valueOf((int)dim)).get((int)i).field_71573_c / 16) || !((dist = (float)Math.sqrt(coordCaves.get(dim).get(i).func_71569_e(curseCoord.field_71574_a, curseCoord.field_71572_b, curseCoord.field_71573_c))) < closest)) continue;
            closest = dist;
            bestCave = coordCaves.get(dim).get(i);
        }
        if (!(closest <= 160.0f) || bestCave == null) {
            WorldDirectorMultiDim.dbg("failed to find close cave, closest: " + closest);
            return false;
        }
        WorldDirectorMultiDim.dbg(world.field_73011_w.field_76574_g + ": Cave Spawn Event: " + bestCave.field_71574_a + ", " + bestCave.field_71572_b + ", " + bestCave.field_71573_c);
        this.spawnGroup(world, curseCoord, bestCave, null, 1);
        return true;
    }

    public boolean spawnGroup(World world, ChunkCoordinates attackCoord, ChunkCoordinates spawnCoord, WorldEvent invasion, int spawnCount) {
        int spawned = 0;
        int amountToSpawn = spawnCount;
        int tries = 0;
        String prefix = "HostileWorlds.";
        String mobToSpawnLeader = "InvaderZombieMiner";
        String mobToSpawn = "InvaderZombie";
        ZombieMiner leader = null;
        if (ModConfigFields.warpInvadersCloser) {
            ChunkCoordinates newCoord = spawnCoord;
            HostileWorlds.dbg("forcing spawn point closer");
            double var1 = attackCoord.field_71574_a - spawnCoord.field_71574_a;
            double var3 = attackCoord.field_71572_b - spawnCoord.field_71572_b;
            double var5 = attackCoord.field_71573_c - spawnCoord.field_71573_c;
            double var7 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
            float stepSize = 16.0f;
            int scanDirX = (int)(var1 / var7 * (double)stepSize);
            int scanDirY = (int)(var3 / var7 * (double)stepSize);
            int scanDirZ = (int)(var5 / var7 * (double)stepSize);
            int tryCount = 0;
            int maxDist = 150;
            while (tryCount < 200 && !(Math.sqrt((newCoord = new ChunkCoordinates(newCoord.field_71574_a + scanDirX, newCoord.field_71572_b + scanDirY, newCoord.field_71573_c + scanDirZ)).func_82371_e(attackCoord)) < (double)maxDist)) {
            }
            spawnCoord = new ChunkCoordinates(newCoord.field_71574_a, world.func_72976_f(newCoord.field_71574_a, newCoord.field_71573_c), newCoord.field_71573_c);
            HostileWorlds.dbg("Done, trycount: " + tryCount + ", newCoord on surface, dist: " + Math.sqrt(newCoord.func_82371_e(attackCoord)));
        }
        while (spawned < amountToSpawn && tries++ < 100) {
            Entity ent = EntityList.func_75620_a((String)(prefix + (spawned < 1 ? mobToSpawnLeader : mobToSpawn)), (World)world);
            int range = 8;
            if (ent instanceof EntityLiving) {
                EntityLiving ent2 = (EntityLiving)ent;
                double var5 = (double)spawnCoord.field_71574_a + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)range;
                double var7 = spawnCoord.field_71572_b - 1 + world.field_73012_v.nextInt(6) - 3;
                double var9 = (double)spawnCoord.field_71573_c + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)range;
                ent2.func_70012_b(var5, var7, var9, ent2.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!ent2.func_70601_bi()) continue;
                if (ent instanceof ICoroAI && ((ICoroAI)ent).getAIAgent().jobMan.priJob instanceof JobGroupHorde) {
                    ((JobGroupHorde)((ICoroAI)ent).getAIAgent().jobMan.priJob).attackCoord = attackCoord;
                    if (invasion != null) {
                        if (ent instanceof EntityInvader) {
                            invasion.setEntityInvasionInfo((EntityInvader)ent);
                        }
                        if (ent instanceof ZombieMiner) {
                            invasion.registerWithInvasion((ICoroAI)ent);
                            System.out.println("zombie miner SPAWN request ticket");
                            ((ZombieMiner)ent).requestTicket();
                            ((ZombieMiner)ent).forceChunkLoading(ent.field_70176_ah, ent.field_70164_aj);
                            leader = (ZombieMiner)ent;
                        }
                    }
                    if (leader != null) {
                        ((JobGroupHorde)((ICoroAI)ent).getAIAgent().jobMan.priJob).leader = leader;
                    }
                }
                world.func_72838_d((Entity)ent2);
                ++spawned;
                tries = 0;
                continue;
            }
            HostileWorlds.dbg("invalid entity, aborting");
            return false;
        }
        if (tries >= 100) {
            HostileWorlds.dbg("hit max tries, aborted");
            if (spawned > 0) {
                HostileWorlds.dbg("spawned some at least, returning true");
                return true;
            }
            return false;
        }
        return true;
    }

    public void pfComplete(PFCallbackItem ci) {
        this.getQueue().add(ci);
    }

    public void manageCallbackQueue() {
        ArrayList<PFCallbackItem> list = this.getQueue();
        try {
            for (int i = 0; i < list.size(); ++i) {
                PFCallbackItem item = list.get(i);
                WorldDirectorMultiDim.dbg("processing queue");
                this.waitingOnPF = false;
                float dist = this.distanceTo(item.pe.func_75870_c().field_75839_a, item.pe.func_75870_c().field_75837_b, item.pe.func_75870_c().field_75838_c, item.pe.func_75877_a((int)0).field_75839_a, item.pe.func_75877_a((int)0).field_75837_b, item.pe.func_75877_a((int)0).field_75838_c);
                WorldDirectorMultiDim.dbg(Float.valueOf(dist));
                if (!(dist < 7.0f)) continue;
                WorldDirectorMultiDim.dbg("found a pathable spot!");
                this.spawnHorde((World)DimensionManager.getWorld((int)this.detectedIDCatacombs), new ChunkCoordinates(item.pe.func_75870_c().field_75839_a, item.pe.func_75870_c().field_75837_b, item.pe.func_75870_c().field_75838_c), new ChunkCoordinates(item.pe.func_75877_a((int)0).field_75839_a, item.pe.func_75877_a((int)0).field_75837_b, item.pe.func_75877_a((int)0).field_75838_c));
            }
        }
        catch (Exception ex) {
            WorldDirectorMultiDim.dbg("Crash in HW Callback PF manager");
            ex.printStackTrace();
        }
        list.clear();
    }

    public ArrayList<PFCallbackItem> getQueue() {
        return this.queue;
    }

    public static float getBlockImportanceValue(Block block) {
        boolean test = false;
        if (test) {
            System.out.println("TEST INVADE IS ON!");
            return 30.0f;
        }
        float scaleBase = 1.0f;
        float defaultIron = scaleBase * 0.3f;
        if (block instanceof BlockLog) {
            return scaleBase * 0.1f;
        }
        if (block instanceof BlockSapling) {
            return scaleBase * 0.3f;
        }
        if (block instanceof BlockOre) {
            if (block == Blocks.field_150365_q) {
                return scaleBase * 0.2f;
            }
            if (block == Blocks.field_150366_p) {
                return defaultIron;
            }
            if (block == Blocks.field_150352_o) {
                return scaleBase * 0.4f;
            }
            if (block == Blocks.field_150439_ay || block == Blocks.field_150450_ax) {
                return scaleBase * 0.5f;
            }
            if (block == Blocks.field_150369_x) {
                return scaleBase * 0.6f;
            }
            if (block == Blocks.field_150482_ag) {
                return scaleBase * 1.0f;
            }
            if (block == Blocks.field_150412_bA) {
                return scaleBase * 1.2f;
            }
            return defaultIron;
        }
        if (OreDictionary.getOres((String)Block.field_149771_c.func_148750_c((Object)block)).size() > 0) {
            return defaultIron;
        }
        return 0.0f;
    }

    public static void handleHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.world.field_73010_i.contains(event.harvester)) {
            NBTTagCompound nbt = WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)event.harvester));
            if (event.block instanceof BlockOre) {
                int curVal = nbt.func_74762_e("harvested_Ore");
                nbt.func_74768_a("harvested_Ore", ++curVal);
            } else if (event.block instanceof BlockLog) {
                int curVal = nbt.func_74762_e("harvested_Log");
                nbt.func_74768_a("harvested_Log", ++curVal);
            }
            WorldDirectorMultiDim.increaseInvadeRating(event.harvester, WorldDirectorMultiDim.getBlockImportanceValue(event.block));
        }
    }

    public static void increaseInvadeRating(EntityPlayer parPlayer, float parVal) {
        NBTTagCompound nbt = WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)parPlayer));
        float curVal = nbt.func_74760_g("harvested_Rating");
        nbt.func_74776_a("harvested_Rating", curVal += parVal);
    }

    public static void decreaseInvadeRating(EntityPlayer parPlayer, float parVal) {
        NBTTagCompound nbt = WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)parPlayer));
        float curVal = nbt.func_74760_g("harvested_Rating");
        nbt.func_74776_a("harvested_Rating", curVal -= parVal);
    }

    public static float getHarvestRatingInvadeThreshold() {
        return 30.0f;
    }

    public static boolean isInvadeable(EntityPlayer parPlayer) {
        return WorldDirectorMultiDim.getPlayerNBT(CoroUtilEntity.getName((Entity)parPlayer)).func_74760_g("harvested_Rating") >= WorldDirectorMultiDim.getHarvestRatingInvadeThreshold();
    }

    static {
        playerNBT = new HashMap();
    }
}

