/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity;

import CoroUtil.util.CoroUtilBlock;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hostileworlds.HostileWorlds;
import hostileworlds.entity.EntityWorm;
import hostileworlds.entity.monster.ZombieBlockWielder;
import hostileworlds.entity.particle.EntityMeteorTrailFX;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MovingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public boolean noCollision = false;
    public int age = 0;
    public Block blockID;
    public int blockMeta = 0;
    public float gravity = 0.04f;
    public float speedSlowing = 0.99f;
    public int blockifyDelay = 30;
    public EntityLivingBase target;
    public float targetTillDist = -1.0f;
    public double targPrevPosX;
    public double targPrevPosY;
    public double targPrevPosZ;
    public int blockNum;
    public int blockRow;
    public boolean createParticles = false;

    public MovingBlock(World var1) {
        super(var1);
    }

    public MovingBlock(World var1, Block parBlockID, int parMeta) {
        super(var1);
        this.blockID = parBlockID;
        this.blockMeta = parMeta;
    }

    public boolean func_70112_a(double var1) {
        return true;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void func_70088_a() {
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && !this.noCollision;
    }

    public void moveTowards(Entity ent, Entity targ, float speed, int leadTicks) {
        double vecX = targ.field_70165_t + (targ.field_70165_t - this.targPrevPosX) * (double)leadTicks - ent.field_70165_t;
        double vecZ = targ.field_70161_v + (targ.field_70161_v - this.targPrevPosZ) * (double)leadTicks - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        this.field_70159_w *= (double)this.speedSlowing;
        this.field_70181_x *= (double)this.speedSlowing;
        this.field_70179_y *= (double)this.speedSlowing;
        this.field_70181_x -= (double)this.gravity;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            int aheadZ;
            int aheadY;
            float ahead;
            int aheadX;
            Block id;
            if (this.target != null && this.targetTillDist != -1.0f) {
                float var2 = (float)(this.field_70165_t - this.target.field_70165_t);
                float var4 = (float)(this.field_70161_v - this.target.field_70161_v);
                float dist = MathHelper.func_76129_c((float)(var2 * var2 + var4 * var4));
                if (dist > this.targetTillDist) {
                    this.field_70159_w *= (double)0.95f;
                    this.field_70179_y *= (double)0.95f;
                    if (this.field_70181_x < 0.0) {
                        this.field_70181_x += (double)0.02f;
                    }
                    if (Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < (double)0.2f) {
                        this.moveTowards(this, (Entity)this.target, dist * 0.025f, (int)(dist * 2.5f));
                    }
                }
                this.targPrevPosX = this.target.field_70165_t;
                this.targPrevPosY = this.target.field_70163_u;
                this.targPrevPosZ = this.target.field_70161_v;
            }
            if (this.blockifyDelay != -1 && this.age > this.blockifyDelay && !CoroUtilBlock.isAir((Block)(id = this.field_70170_p.func_147439_a(aheadX = (int)(this.field_70165_t + this.field_70159_w * (double)(ahead = 1.0f)), aheadY = (int)(this.field_70163_u + this.field_70181_x * (double)ahead), aheadZ = (int)(this.field_70161_v + this.field_70179_y * (double)ahead)))) && this.field_70170_p.func_147438_o(aheadX, aheadY, aheadZ) == null && id != HostileWorlds.blockBloodyCobblestone && id.func_149688_o() != Material.field_151586_h && id.func_149688_o() != Material.field_151594_q && id.func_149688_o() != Material.field_151597_y && id.func_149688_o() != Material.field_151585_k && id.func_149688_o().func_76220_a()) {
                this.blockify((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            }
            double size = 0.5;
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(size, size, size));
            for (int i = 0; entities != null && i < entities.size(); ++i) {
                Entity var10 = (Entity)entities.get(i);
                if (var10 == null || var10.field_70128_L || !(var10 instanceof EntityLivingBase) || var10 instanceof ZombieBlockWielder || var10 instanceof EntityWorm) continue;
                var10.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this), 4.0f);
            }
        } else if (this.createParticles) {
            this.spawnParticles();
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70181_x = 0.0;
        }
    }

    public void triggerOwnerDied() {
        this.blockifyDelay = 1;
        this.gravity = 0.03f;
        double speed = 0.3f;
        this.field_70159_w = this.field_70146_Z.nextGaussian() * speed - this.field_70146_Z.nextGaussian() * speed;
        this.field_70181_x = (double)0.3f + this.field_70146_Z.nextGaussian() * speed - this.field_70146_Z.nextGaussian() * speed;
        this.field_70179_y = this.field_70146_Z.nextGaussian() * speed - this.field_70146_Z.nextGaussian() * speed;
    }

    public void blockify(int x, int y, int z) {
        this.field_70170_p.func_147449_b(x, y, z, this.blockID);
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        this.func_70106_y();
        return super.func_70097_a(par1DamageSource, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        for (int i = 0; i < 1; ++i) {
            float speed = 0.1f;
            float randPos = 8.0f;
            float ahead = 2.5f;
            EntityMeteorTrailFX particle = new EntityMeteorTrailFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, 0.25, this.field_70179_y, 0.0f, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.maxScale = 3.0f;
            particle.setMaxAge(100);
            particle.field_70159_w = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
            particle.field_70181_x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f;
            particle.field_70179_y = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
            particle.spawnAsWeatherEffect();
        }
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public boolean isInRangeToRenderVec3D(Vec3 asd) {
        return true;
    }

    public void setEntityDead() {
        super.func_70106_y();
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)Block.field_149771_c.func_148750_c((Object)this.blockID));
        data.writeInt(this.blockMeta);
        data.writeFloat(this.gravity);
        data.writeInt(this.blockifyDelay);
        data.writeInt(this.blockNum);
        data.writeInt(this.blockRow);
        data.writeBoolean(this.createParticles);
    }

    public void readSpawnData(ByteBuf data) {
        this.blockID = (Block)Block.field_149771_c.func_82594_a(ByteBufUtils.readUTF8String((ByteBuf)data));
        this.blockMeta = data.readInt();
        this.gravity = data.readFloat();
        this.blockifyDelay = data.readInt();
        this.blockNum = data.readInt();
        this.blockRow = data.readInt();
        this.createParticles = data.readBoolean();
    }

    protected void func_70037_a(NBTTagCompound data) {
        this.blockID = (Block)Block.field_149771_c.func_82594_a(data.func_74779_i("blockID"));
        this.blockMeta = data.func_74762_e("blockMeta");
    }

    protected void func_70014_b(NBTTagCompound data) {
        data.func_74778_a("blockID", Block.field_149771_c.func_148750_c((Object)this.blockID));
        data.func_74768_a("blockMeta", this.blockMeta);
        data.func_74768_a("blockifyDelay", this.blockifyDelay);
        data.func_74776_a("gravity", this.gravity);
    }
}

