/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity.bt.ai;

import CoroUtil.bt.AIBTAgent;
import CoroUtil.bt.Behavior;
import CoroUtil.bt.EnumBehaviorState;
import CoroUtil.bt.IBTAgent;
import CoroUtil.bt.selector.Selector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class SeekPlayerBase
extends Selector {
    public IBTAgent entInt;
    public EntityLiving ent;
    public float rangeHunt = 16.0f;
    public int scanRate = 80;
    public int randRate = -1;
    public long lastBestTime = -1L;
    public ChunkDataPoint lastBestChunk = null;

    public SeekPlayerBase(Behavior parParent, IBTAgent parEnt, float parRange) {
        super(parParent);
        this.entInt = parEnt;
        this.ent = (EntityLiving)parEnt;
        this.rangeHunt = parRange;
    }

    public boolean sanityCheck(Entity target) {
        return true;
    }

    public EnumBehaviorState tick() {
        boolean xRay = false;
        EntityLiving protectEnt = this.ent;
        Random rand = new Random();
        AIBTAgent ai = this.entInt.getAIBTAgent();
        EntityPlayerMP entP = this.getPlayerToSeek();
        if (!(entP == null || this.scanRate != -1 && this.ent.field_70170_p.func_82737_E() % (long)this.scanRate != 0L || this.randRate != -1 && rand.nextInt(this.randRate) != 0)) {
            ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(this.ent.field_70170_p).getChunkData(MathHelper.func_76128_c((double)this.ent.field_70165_t) / 16, MathHelper.func_76128_c((double)this.ent.field_70161_v) / 16);
            long thisChunkTime = cdp.getPlayerData((UUID)entP.func_146103_bH().getId()).playerActivityInteraction;
            ChunkDataPoint chunkBest = cdp;
            long chunkTimeBest = thisChunkTime;
            ChunkDataPoint nextChunk = null;
            int radius = 6;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    nextChunk = WorldDirectorManager.instance().getChunkDataGrid(this.ent.field_70170_p).getChunkData(cdp.xCoord + x, cdp.zCoord + z);
                    if (cdp.getPlayerData((UUID)entP.func_146103_bH().getId()).playerActivityInteraction <= chunkTimeBest) continue;
                    chunkBest = nextChunk;
                    chunkTimeBest = cdp.getPlayerData((UUID)entP.func_146103_bH().getId()).playerActivityInteraction;
                }
            }
            boolean forceSeekSpawn = true;
            if (!forceSeekSpawn && cdp != chunkBest) {
                if (chunkTimeBest > this.lastBestTime) {
                    this.lastBestTime = chunkTimeBest;
                    this.lastBestChunk = chunkBest;
                    System.out.println("found better chunk! pathing to chunk pos " + chunkBest.xCoord + " - " + chunkBest.zCoord + " - " + chunkTimeBest);
                    int topY = this.ent.field_70170_p.func_72976_f(chunkBest.xCoord * 16 + 8, chunkBest.zCoord * 16 + 8) - 1;
                    ai.blackboard.setMoveAndPathTo(Vec3.func_72443_a((double)(chunkBest.xCoord * 16 + 8), (double)topY, (double)(chunkBest.zCoord * 16 + 8)));
                } else {
                    System.out.println("still pursuing best chunk - " + this.lastBestTime + " - moving to: x" + this.lastBestChunk.xCoord + " - z" + this.lastBestChunk.zCoord + " : " + ai.blackboard.posMoveTo);
                }
            }
            if (forceSeekSpawn || this.lastBestTime <= 0L) {
                ChunkCoordinates spawnCoords = entP.getBedLocation(entP.field_70170_p.field_73011_w.field_76574_g);
                this.lastBestChunk = WorldDirectorManager.instance().getChunkDataGrid(this.ent.field_70170_p).getChunkData(MathHelper.func_76128_c((double)spawnCoords.field_71574_a) / 16, MathHelper.func_76128_c((double)spawnCoords.field_71573_c) / 16);
                int topY = this.ent.field_70170_p.func_72976_f(this.lastBestChunk.xCoord * 16 + 8, this.lastBestChunk.zCoord * 16 + 8) - 1;
                ai.blackboard.setMoveAndPathTo(Vec3.func_72443_a((double)(this.lastBestChunk.xCoord * 16 + 8), (double)topY, (double)(this.lastBestChunk.zCoord * 16 + 8)));
                System.out.println("seeking out players spawn coord - curpos: " + (int)this.ent.field_70165_t + ", " + (int)this.ent.field_70163_u + ", " + (int)this.ent.field_70161_v + ", moving to: x: " + this.lastBestChunk.xCoord + " - z: " + this.lastBestChunk.zCoord + " : " + ai.blackboard.posMoveTo);
            }
        }
        return super.tick();
    }

    public EntityPlayerMP getPlayerToSeek() {
        for (int i = 0; i < this.ent.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayerMP entP = (EntityPlayerMP)this.ent.field_70170_p.field_73010_i.get(0);
            if (entP.field_70128_L) continue;
            return entP;
        }
        return null;
    }
}

