/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest.quests;

import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilNBT;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.event.world.BlockEvent;

public class BreakBlockQuest
extends ActiveQuest {
    public ChunkCoordinates blockCoords;
    public String blockType;
    public int blockCountNeeded = -1;
    public int blockCountCurrent = 0;

    public BreakBlockQuest() {
        this.questType = "breakBlock";
    }

    public void initCustomData(ChunkCoordinates parCoords, Block parBlock) {
        super.initCustomData();
        this.blockCoords = parCoords;
        this.blockType = Block.field_149771_c.func_148750_c((Object)parBlock);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.curState == EnumQuestState.ASSIGNED) {
            if (this.blockCountNeeded != -1 && this.blockCountCurrent >= this.blockCountNeeded) {
                if (this.returnToQuestGiver) {
                    this.setState(EnumQuestState.CONCLUDING);
                } else {
                    this.eventComplete();
                }
            }
        } else if (this.curState == EnumQuestState.CONCLUDING) {
            // empty if block
        }
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof BlockEvent.BreakEvent) {
            this.handleEvent((BlockEvent.BreakEvent)event);
        }
    }

    public void handleEvent(BlockEvent.BreakEvent event) {
        System.out.println("EVENT!: " + event.getPlayer() + " - " + event.x + " - " + event.y + " - " + event.z);
        if (event.getPlayer() == null || !CoroUtilEntity.getName((Entity)event.getPlayer()).equals(this.playerQuests.playerName)) {
            return;
        }
        if (this.getBlock() != null && this.getBlock() != event.block) {
            return;
        }
        if (this.blockCoords != null && (this.blockCoords.field_71574_a != event.x || this.blockCoords.field_71572_b != event.y || this.blockCoords.field_71573_c != event.z)) {
            return;
        }
        if (this.blockCountNeeded != -1) {
            ++this.blockCountCurrent;
        } else {
            this.eventComplete();
        }
        this.saveAndSync();
    }

    public Block getBlock() {
        return (Block)Block.field_149771_c.func_82594_a(this.blockType);
    }

    @Override
    public void load(NBTTagCompound parNBT) {
        super.load(parNBT);
        this.blockCountNeeded = parNBT.func_74762_e("blockCountNeeded");
        this.blockCountCurrent = parNBT.func_74762_e("blockCountCurrent");
        this.blockCoords = CoroUtilNBT.readCoords("blockCoords", parNBT);
        this.blockType = parNBT.func_74779_i("blockType");
    }

    @Override
    public void save(NBTTagCompound parNBT) {
        super.save(parNBT);
        parNBT.func_74768_a("blockCountNeeded", this.blockCountNeeded);
        parNBT.func_74768_a("blockCountCurrent", this.blockCountCurrent);
        CoroUtilNBT.writeCoords("blockCoords", this.blockCoords, parNBT);
        parNBT.func_74778_a("blockType", this.blockType);
    }
}

